/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jetty.maven.plugin.AbstractForker;
import org.eclipse.jetty.maven.plugin.JettyForkedChild;
import org.eclipse.jetty.maven.plugin.MavenWebAppContext;
import org.eclipse.jetty.maven.plugin.PluginLog;
import org.eclipse.jetty.maven.plugin.QuickStartGenerator;
import org.eclipse.jetty.server.Server;

public class JettyForker
extends AbstractForker {
    protected File forkWebXml;
    protected Server server;
    protected MavenWebAppContext webApp;
    protected String containerClassPath;
    protected File webAppPropsFile;
    protected String contextXml;
    protected boolean scan;
    QuickStartGenerator generator;

    public boolean isScan() {
        return this.scan;
    }

    public void setScan(boolean scan) {
        this.scan = scan;
    }

    public File getWebAppPropsFile() {
        return this.webAppPropsFile;
    }

    public void setWebAppPropsFile(File webAppPropsFile) {
        this.webAppPropsFile = webAppPropsFile;
    }

    public File getForkWebXml() {
        return this.forkWebXml;
    }

    public void setForkWebXml(File forkWebXml) {
        this.forkWebXml = forkWebXml;
    }

    public String getContextXml() {
        return this.contextXml;
    }

    public void setContextXml(String contextXml) {
        this.contextXml = contextXml;
    }

    public String getContainerClassPath() {
        return this.containerClassPath;
    }

    public void setContainerClassPath(String containerClassPath) {
        this.containerClassPath = containerClassPath;
    }

    public void setWebApp(MavenWebAppContext app) {
        this.webApp = app;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    @Override
    public void doStart() throws Exception {
        this.generator = new QuickStartGenerator(this.forkWebXml, this.webApp);
        this.generator.setContextXml(this.contextXml);
        this.generator.setWebAppPropsFile(this.webAppPropsFile);
        this.generator.setServer(this.server);
        this.generator.generate();
        super.doStart();
    }

    @Override
    protected void redeployWebApp() throws Exception {
        this.generator.generate();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ProcessBuilder createCommand() {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.getJavaBin());
        if (this.jvmArgs != null) {
            void var3_4;
            String[] args = this.jvmArgs.split(" ");
            boolean bl = false;
            while (args != null && var3_4 < args.length) {
                if (args[var3_4] != null && !"".equals(args[var3_4])) {
                    cmd.add(((String)args[var3_4]).trim());
                }
                ++var3_4;
            }
        }
        if (this.systemProperties != null) {
            for (Map.Entry entry : this.systemProperties.entrySet()) {
                cmd.add("-D" + (String)entry.getKey() + "=" + (String)entry.getValue());
            }
        }
        if (this.containerClassPath != null && this.containerClassPath.length() > 0) {
            cmd.add("-cp");
            cmd.add(this.containerClassPath);
        }
        cmd.add(JettyForkedChild.class.getCanonicalName());
        if (this.stopPort > 0 && this.stopKey != null) {
            cmd.add("--stop-port");
            cmd.add(Integer.toString(this.stopPort));
            cmd.add("--stop-key");
            cmd.add(this.stopKey);
        }
        if (this.jettyXmlFiles != null) {
            cmd.add("--jetty-xml");
            StringBuilder tmp = new StringBuilder();
            for (File jettyXml : this.jettyXmlFiles) {
                if (tmp.length() != 0) {
                    tmp.append(",");
                }
                tmp.append(jettyXml.getAbsolutePath());
            }
            cmd.add(tmp.toString());
        }
        cmd.add("--webprops");
        cmd.add(this.webAppPropsFile.getAbsolutePath());
        cmd.add("--token");
        cmd.add(this.tokenFile.getAbsolutePath());
        if (this.scan) {
            cmd.add("--scan");
        }
        if (this.jettyProperties != null) {
            for (Map.Entry entry : this.jettyProperties.entrySet()) {
                cmd.add((String)entry.getKey() + "=" + (String)entry.getValue());
            }
        }
        ProcessBuilder command = new ProcessBuilder(cmd);
        command.directory(this.workDir);
        if (PluginLog.getLog().isDebugEnabled()) {
            PluginLog.getLog().debug((CharSequence)("Forked cli:" + command.command()));
        }
        PluginLog.getLog().info((CharSequence)"Forked process starting");
        if (this.env != null && !this.env.isEmpty()) {
            command.environment().putAll(this.env);
        }
        if (this.waitForChild) {
            command.inheritIO();
        } else {
            command.redirectOutput(this.jettyOutputFile);
            command.redirectErrorStream(true);
        }
        return command;
    }

    private String getJavaBin() {
        String[] javaexes = new String[]{"java", "java.exe"};
        File javaHomeDir = new File(System.getProperty("java.home"));
        for (String javaexe : javaexes) {
            File javabin = new File(javaHomeDir, JettyForker.fileSeparators("bin/" + javaexe));
            if (!javabin.exists() || !javabin.isFile()) continue;
            return javabin.getAbsolutePath();
        }
        return "java";
    }

    public static String fileSeparators(String path) {
        StringBuilder ret = new StringBuilder();
        for (char c : path.toCharArray()) {
            if (c == '/' || c == '\\') {
                ret.append(File.separatorChar);
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public static String pathSeparators(String path) {
        StringBuilder ret = new StringBuilder();
        for (char c : path.toCharArray()) {
            if (c == ',' || c == ':') {
                ret.append(File.pathSeparatorChar);
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }
}

