/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.maven;

import aQute.bnd.osgi.Jar;
import java.net.URI;
import java.util.Set;
import javax.inject.Inject;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.transformer.AppOption;
import org.eclipse.transformer.TransformOptions;
import org.eclipse.transformer.Transformer;
import org.eclipse.transformer.maven.TransformerMojoOptions;
import org.eclipse.transformer.maven.action.TransformerJarAction;
import org.eclipse.transformer.maven.action.TransformerJarChanges;
import org.eclipse.transformer.maven.configuration.TransformerRules;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractTransformerMojo
extends AbstractMojo {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${mojoExecution}", required=true, readonly=true)
    private MojoExecution mojoExecution;
    @Parameter(property="transformer.packagingTypes", defaultValue="jar,war,ear,ejb,ejb3,par,rar,maven-plugin")
    private Set<String> packagingTypes;
    @Parameter
    private TransformerRules rules = new TransformerRules();
    @Parameter(property="transform.skip", defaultValue="false")
    private boolean skip;
    @Inject
    private BuildContext buildContext;

    public boolean skip() {
        if (!this.getPackagingTypes().contains(this.getProject().getPackaging())) {
            this.getLogger().debug("skip project with packaging={}", (Object)this.getProject().getPackaging());
            return true;
        }
        if (this.isSkip()) {
            this.getLogger().info("skip project as configured");
            return true;
        }
        return false;
    }

    public TransformerJarChanges transform(Jar jar, String inputName, String outputName) throws MojoExecutionException, MojoFailureException {
        boolean validRules;
        TransformerMojoOptions options = new TransformerMojoOptions(this.getRules());
        Transformer transformer = new Transformer(this.getLogger(), (TransformOptions)options);
        URI base = this.getProject().getBasedir().toURI();
        this.getLogger().debug("Setting Transformer base {}", (Object)base);
        transformer.setBase(base);
        try {
            validRules = transformer.setRules(transformer.getImmediateData());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception loading transformer rules", e);
        }
        if (!validRules) {
            throw new MojoFailureException("Transformation rules are not valid and cannot be used");
        }
        transformer.logRules();
        TransformerJarAction action = new TransformerJarAction(transformer.getActionContext(), transformer.getActionSelector(), options.hasOption(AppOption.OVERWRITE));
        action.apply(jar, inputName, outputName);
        TransformerJarChanges lastActiveChanges = action.getLastActiveChanges();
        lastActiveChanges.log(this.getLogger(), lastActiveChanges.getInputResourceName(), lastActiveChanges.getOutputResourceName());
        return lastActiveChanges;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public TransformerRules getRules() {
        return this.rules;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public BuildContext getBuildContext() {
        return this.buildContext;
    }

    public MojoExecution getMojoExecution() {
        return this.mojoExecution;
    }

    public Set<String> getPackagingTypes() {
        return this.packagingTypes;
    }
}

