/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.maven;

import aQute.bnd.maven.PomPropertiesResource;
import aQute.bnd.osgi.FileResource;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import aQute.lib.io.IO;
import aQute.libg.glob.PathSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.transformer.maven.AbstractTransformerMojo;
import org.eclipse.transformer.maven.TransformerMavenLifecycleParticipant;
import org.eclipse.transformer.maven.configuration.TransformerArtifact;

@Mojo(name="jar", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class TransformerJarMojo
extends AbstractTransformerMojo {
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", required=true, readonly=true)
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${project.build.directory}")
    private File buildDirectory;
    @Parameter(defaultValue="${project.build.finalName}")
    private String baseName;
    @Parameter
    private String classifier;
    @Parameter(defaultValue="${project.packaging}")
    private String type;
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    private String outputTimestamp;
    @Parameter(defaultValue="true")
    private boolean attach;
    @Parameter
    private TransformerArtifact artifact = new TransformerArtifact();
    @Inject
    private ArtifactResolver artifactResolver;
    @Inject
    private MavenProjectHelper projectHelper;
    @Inject
    private ArtifactHandlerManager artifactHandlerManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip()) {
            return;
        }
        TransformerArtifact artifactDescription = this.prepareArtifactDescription(this.getArtifact());
        if (StringUtils.isBlank((String)this.getClassifier())) {
            this.setClassifier(artifactDescription.getClassifier());
        } else if (Objects.equals("-", this.getClassifier())) {
            this.setClassifier(null);
        }
        if (TransformerMavenLifecycleParticipant.isPackagingGoal(this.getMojoExecution().getGoal()) && StringUtils.isBlank((String)this.getClassifier()) && !this.getMojoExecution().getPlugin().isExtensions()) {
            throw new MojoExecutionException(String.format("In order to use the %s packaging goal %s without a classifier, <extensions>true</extensions> must be set on the plugin configuration", "transformer-maven-plugin", this.getMojoExecution().getGoal()));
        }
        Artifact input = this.getArtifact(artifactDescription);
        try (Jar jar = new Jar(input.getFile());){
            File output = this.getOutput();
            this.getLogger().debug("Transforming {} to {}", (Object)input, (Object)output);
            PathSet excludes = new PathSet(new String[]{"META-INF/maven/**"});
            excludes.includes(artifactDescription.getExcludes());
            List<String> remove = jar.getResourceNames(excludes.matches()).collect(Collectors.toList());
            this.getLogger().debug("Excluding {}", remove);
            remove.forEach(arg_0 -> ((Jar)jar).remove(arg_0));
            String inputName = input.getFile().getAbsolutePath();
            String outputName = output.getAbsolutePath();
            this.transform(jar, inputName, outputName);
            this.writeOutput(jar, output);
        }
        catch (Exception e) {
            throw new MojoFailureException("Exception transforming jar", (Throwable)e);
        }
    }

    private String getExtension(String type) {
        ArtifactHandler artifactHandler = this.getArtifactHandlerManager().getArtifactHandler(type);
        if (artifactHandler != null) {
            type = artifactHandler.getExtension();
        }
        return type;
    }

    private File getOutput() throws IOException {
        String extension = this.getExtension(this.getType());
        String classifier = this.getClassifier();
        String name = StringUtils.isBlank((String)classifier) ? this.getBaseName() + "." + extension : this.getBaseName() + "-" + classifier + "." + extension;
        File output = IO.getBasedFile((File)this.getBuildDirectory(), (String)name);
        return output;
    }

    private void writeOutput(Jar jar, File output) throws Exception {
        boolean isReproducible;
        String outputTimestamp = this.getOutputTimestamp();
        boolean bl = isReproducible = StringUtils.isNotEmpty((String)outputTimestamp) && (outputTimestamp.length() > 1 || Character.isDigit(outputTimestamp.charAt(0)));
        if (isReproducible) {
            jar.setReproducible(outputTimestamp);
        }
        this.addMavenMetadataToJar(jar);
        IO.mkdirs((File)output.getParentFile());
        jar.write(output);
        this.getBuildContext().refresh(output);
        if (this.isAttach()) {
            String classifier = this.getClassifier();
            if (StringUtils.isBlank((String)classifier)) {
                this.getLogger().debug("Setting {} as project main artifact", (Object)output);
                Artifact main = this.getProject().getArtifact();
                main.setFile(output);
            } else {
                this.getLogger().debug("Attaching {} to project", (Object)output);
                this.getProjectHelper().attachArtifact(this.getProject(), this.getType(), classifier, output);
            }
        }
    }

    private void addMavenMetadataToJar(Jar jar) throws IOException {
        MavenProject project = this.getProject();
        String groupId = project.getGroupId();
        String artifactId = project.getArtifactId();
        String version = project.getArtifact().isSnapshot() ? project.getArtifact().getVersion() : project.getVersion();
        jar.putResource(String.format("META-INF/maven/%s/%s/pom.xml", groupId, artifactId), (Resource)new FileResource(project.getFile()));
        PomPropertiesResource pomProperties = new PomPropertiesResource(groupId, artifactId, version);
        jar.putResource(pomProperties.getWhere(), (Resource)pomProperties);
    }

    private Artifact getArtifact(TransformerArtifact artifactDescription) throws MojoExecutionException {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.getSession().getProjectBuildingRequest());
        buildingRequest.setRemoteRepositories(this.getRemoteRepositories());
        DefaultArtifactCoordinate coordinate = new DefaultArtifactCoordinate();
        coordinate.setGroupId(artifactDescription.getGroupId());
        coordinate.setArtifactId(artifactDescription.getArtifactId());
        coordinate.setVersion(artifactDescription.getVersion());
        coordinate.setClassifier(artifactDescription.getClassifier());
        coordinate.setExtension(this.getExtension(artifactDescription.getType()));
        try {
            Artifact artifact = this.getArtifactResolver().resolveArtifact((ProjectBuildingRequest)buildingRequest, (ArtifactCoordinate)coordinate).getArtifact();
            return artifact;
        }
        catch (ArtifactResolverException e) {
            throw new MojoExecutionException(String.format("Unable to resolve artifact %s", artifactDescription));
        }
    }

    private TransformerArtifact prepareArtifactDescription(TransformerArtifact artifactDescription) throws MojoExecutionException {
        MavenProject project = this.getProject();
        if (StringUtils.isBlank((String)artifactDescription.getType())) {
            artifactDescription.setType(project.getPackaging());
        }
        if (StringUtils.isBlank((String)artifactDescription.getVersion())) {
            ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
            dependencies.add(TransformerJarMojo.toDependency(project.getArtifact()));
            for (Artifact artifact : project.getAttachedArtifacts()) {
                dependencies.add(TransformerJarMojo.toDependency(artifact));
            }
            dependencies.addAll(project.getDependencies());
            Optional.ofNullable(project.getDependencyManagement()).map(DependencyManagement::getDependencies).ifPresent(dependencies::addAll);
            List<Dependency> firstPass = dependencies.stream().filter(dependency -> Objects.equals(artifactDescription.getGroupId(), dependency.getGroupId()) && Objects.equals(artifactDescription.getArtifactId(), dependency.getArtifactId())).toList();
            Optional<Object> matchingDependency = firstPass.stream().filter(dependency -> Objects.equals(artifactDescription.getClassifier(), dependency.getClassifier()) && Objects.equals(artifactDescription.getType(), dependency.getType())).findFirst();
            if (matchingDependency.isEmpty() && (matchingDependency = firstPass.stream().findFirst()).isEmpty()) {
                throw new MojoExecutionException(String.format("No version found for artifact %s:%s in project, dependencies, or dependency management", artifactDescription.getGroupId(), artifactDescription.getArtifactId()));
            }
            artifactDescription.setVersion(matchingDependency.get().getVersion());
        }
        return artifactDescription;
    }

    private static Dependency toDependency(Artifact artifact) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(artifact.getGroupId());
        dependency.setArtifactId(artifact.getArtifactId());
        dependency.setVersion(artifact.getVersion());
        dependency.setClassifier(artifact.getClassifier());
        dependency.setType(artifact.getType());
        return dependency;
    }

    public List<ArtifactRepository> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public MavenProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    public ArtifactResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    public ArtifactHandlerManager getArtifactHandlerManager() {
        return this.artifactHandlerManager;
    }

    public TransformerArtifact getArtifact() {
        return this.artifact;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public File getBuildDirectory() {
        return this.buildDirectory;
    }

    public String getOutputTimestamp() {
        return this.outputTimestamp;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getType() {
        return this.type;
    }

    public boolean isAttach() {
        return this.attach;
    }
}

