/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.maven;

import aQute.bnd.unmodifiable.Sets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="transformer")
public class TransformerMavenLifecycleParticipant
extends AbstractMavenLifecycleParticipant
implements LogEnabled {
    static final String THIS_GROUP_ID = "org.eclipse.transformer";
    static final String THIS_ARTIFACT_ID = "transformer-maven-plugin";
    static final String MAVEN_JAR_PLUGIN_GROUP_ID = "org.apache.maven.plugins";
    static final String MAVEN_JAR_PLUGIN_ARTIFACT_ID = "maven-jar-plugin";
    static final String JAR_PACKAGING = "jar";
    static final Set<String> PACKAGING_GOALS = Sets.of((Object)"jar", (Object)"test-jar");
    private Logger logger;

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        try {
            for (MavenProject project : session.getProjects()) {
                Plugin mavenJarPlugin;
                Model model = project.getModel();
                Plugin transformerMavenPlugin = this.getTransformerMavenPlugin(model);
                if (transformerMavenPlugin == null || (mavenJarPlugin = this.getMavenJarPlugin(model)) == null) continue;
                this.processExecutions(transformerMavenPlugin.getExecutions(), mavenJarPlugin, project);
            }
        }
        catch (IllegalStateException e) {
            throw new MavenExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    protected Optional<PluginExecution> findMatchingPluginExecution(List<PluginExecution> pluginExecutions, String classifier) {
        return pluginExecutions.stream().filter(execution -> TransformerMavenLifecycleParticipant.matchesClassifier(execution, classifier)).findFirst();
    }

    protected Plugin getTransformerMavenPlugin(Model model) {
        Build build = model.getBuild();
        if (build != null) {
            return this.getTransformerMavenPluginFromContainer((PluginContainer)build);
        }
        return null;
    }

    protected Plugin getTransformerMavenPluginFromContainer(PluginContainer pluginContainer) {
        return this.getPluginByGAFromContainer(THIS_GROUP_ID, THIS_ARTIFACT_ID, pluginContainer);
    }

    protected Plugin getMavenJarPlugin(Model model) {
        Build build;
        if (Objects.equals(model.getPackaging(), JAR_PACKAGING) && (build = model.getBuild()) != null) {
            return this.getMavenJarPluginFromContainer((PluginContainer)build);
        }
        return null;
    }

    protected Plugin getMavenJarPluginFromContainer(PluginContainer pluginContainer) {
        return this.getPluginByGAFromContainer(MAVEN_JAR_PLUGIN_GROUP_ID, MAVEN_JAR_PLUGIN_ARTIFACT_ID, pluginContainer);
    }

    protected Plugin getPluginByGAFromContainer(String groupId, String artifactId, PluginContainer pluginContainer) {
        Plugin result = null;
        for (Plugin plugin : pluginContainer.getPlugins()) {
            if (!this.nullToEmpty(groupId).equals(this.nullToEmpty(plugin.getGroupId())) || !this.nullToEmpty(artifactId).equals(this.nullToEmpty(plugin.getArtifactId()))) continue;
            if (result != null) {
                throw new IllegalStateException("The build contains multiple versions of plugin " + groupId + ":" + artifactId);
            }
            result = plugin;
        }
        return result;
    }

    protected String nullToEmpty(String str) {
        return Optional.ofNullable(str).orElse("");
    }

    protected void processExecutions(List<PluginExecution> transformerExecutions, Plugin mavenPackagingPlugin, MavenProject project) {
        transformerExecutions.stream().filter(TransformerMavenLifecycleParticipant::hasPackagingGoal).forEach(transformerExecution -> {
            String classifier = TransformerMavenLifecycleParticipant.extractClassifier(transformerExecution);
            this.findMatchingPluginExecution(mavenPackagingPlugin.getExecutions(), classifier).ifPresent(execution -> {
                List goals = execution.getGoals();
                boolean removed = goals.removeIf(goal -> {
                    if (TransformerMavenLifecycleParticipant.isPackagingGoal(goal)) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("transformer-maven-plugin disabled " + mavenPackagingPlugin.getArtifactId() + ":" + goal + " (" + execution.getId() + ") @ " + project.getArtifactId());
                        }
                        return true;
                    }
                    return false;
                });
                if (removed && goals.isEmpty()) {
                    mavenPackagingPlugin.removeExecution(execution);
                }
            });
        });
    }

    public static String defaultClassifier(PluginExecution execution) {
        List goals = execution.getGoals();
        if (goals.contains(JAR_PACKAGING)) {
            return "";
        }
        if (goals.contains("test-jar")) {
            return "tests";
        }
        return "";
    }

    public static String extractClassifier(PluginExecution execution) {
        Optional<Xpp3Dom> rootConfiguration = Optional.ofNullable((Xpp3Dom)execution.getConfiguration());
        Optional<Xpp3Dom> classifierConfiguration = rootConfiguration.map(configuration -> configuration.getChild("classifier"));
        if (classifierConfiguration.isEmpty()) {
            classifierConfiguration = rootConfiguration.map(configuration -> configuration.getChild("artifact")).map(configuration -> configuration.getChild("classifier"));
        }
        if (classifierConfiguration.isEmpty()) {
            return TransformerMavenLifecycleParticipant.defaultClassifier(execution);
        }
        return classifierConfiguration.map(Xpp3Dom::getValue).map(String::trim).filter(s -> !s.isEmpty() && !Objects.equals("-", s)).orElse("");
    }

    public static boolean matchesClassifier(PluginExecution execution, String classifier) {
        return Objects.equals(TransformerMavenLifecycleParticipant.extractClassifier(execution), classifier);
    }

    public static boolean isPackagingGoal(String goal) {
        return PACKAGING_GOALS.contains(goal);
    }

    public static boolean hasPackagingGoal(PluginExecution execution) {
        return execution.getGoals().stream().anyMatch(TransformerMavenLifecycleParticipant::isPackagingGoal);
    }
}

