/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.maven;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.transformer.AppOption;
import org.eclipse.transformer.TransformOptions;
import org.eclipse.transformer.jakarta.JakartaTransform;
import org.eclipse.transformer.maven.configuration.TransformerRules;

public class TransformerMojoOptions
implements TransformOptions {
    private final TransformerRules rules;
    private final Map<String, String> optionDefaults;
    private final Function<String, URL> ruleLoader;

    public TransformerMojoOptions(TransformerRules rules) {
        this.rules = Objects.requireNonNull(rules);
        if (rules.isJakartaDefaults()) {
            this.optionDefaults = JakartaTransform.getOptionDefaults();
            this.ruleLoader = JakartaTransform.getRuleLoader();
        } else {
            this.optionDefaults = Collections.emptyMap();
            this.ruleLoader = this.getClass()::getResource;
        }
    }

    private static List<String> condition(List<String> values) {
        if (values == null) {
            return null;
        }
        ListIterator<String> iterator = values.listIterator();
        while (iterator.hasNext()) {
            String value = StringUtils.trim((String)iterator.next());
            if (StringUtils.isBlank((String)value) || Objects.equals("-", value)) {
                iterator.remove();
                continue;
            }
            iterator.set(value);
        }
        return values;
    }

    public List<String> getOptionValues(AppOption option) {
        List<String> values = switch (option) {
            case AppOption.RULES_BUNDLES -> this.rules.getBundles();
            case AppOption.RULES_DIRECT -> this.rules.getDirects();
            case AppOption.RULES_IMMEDIATE_DATA -> this.rules.getImmediates();
            case AppOption.RULES_MASTER_TEXT -> this.rules.getTexts();
            case AppOption.RULES_PER_CLASS_CONSTANT -> this.rules.getPerClassConstants();
            case AppOption.RULES_RENAMES -> this.rules.getRenames();
            case AppOption.RULES_SELECTIONS -> this.rules.getSelections();
            case AppOption.RULES_VERSIONS -> this.rules.getVersions();
            default -> null;
        };
        return TransformerMojoOptions.condition(values);
    }

    public boolean hasOption(AppOption option) {
        boolean has = switch (option) {
            case AppOption.OVERWRITE -> this.rules.isOverwrite();
            case AppOption.INVERT -> this.rules.isInvert();
            case AppOption.WIDEN_ARCHIVE_NESTING -> this.rules.isWiden();
            case AppOption.STRIP_SIGNATURES -> this.rules.isStripSignatures();
            default -> super.hasOption(option);
        };
        return has;
    }

    public String getDefaultValue(AppOption option) {
        String longTag = option.getLongTag();
        String defaultValue = this.optionDefaults.get(longTag);
        if (defaultValue == null) {
            String shortTag = option.getShortTag();
            defaultValue = this.optionDefaults.get(shortTag);
        }
        return defaultValue;
    }

    public Function<String, URL> getRuleLoader() {
        return this.ruleLoader;
    }
}

