/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.maven;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.transformer.AppOption;
import org.eclipse.transformer.TransformOptions;
import org.eclipse.transformer.Transformer;
import org.eclipse.transformer.jakarta.JakartaTransform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="run", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM, requiresProject=true, threadSafe=true)
public class TransformerRunMojo
extends AbstractMojo {
    static final Logger logger = LoggerFactory.getLogger(TransformerRunMojo.class);
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="false", property="transformer-plugin.invert", required=true)
    private boolean invert;
    @Parameter(defaultValue="true", property="transformer-plugin.overwrite", required=true)
    private boolean overwrite;
    @Parameter(defaultValue="false", property="transformer-plugin.stripSignatures", required=false)
    private boolean stripSignatures;
    @Parameter(defaultValue="true", property="transformer-plugin.attach", required=true)
    private boolean attach;
    @Parameter(property="transformer-plugin.renames", defaultValue="")
    private String rulesRenamesUri;
    @Parameter(property="transformer-plugin.versions", defaultValue="")
    private String rulesVersionUri;
    @Parameter(property="transformer-plugin.bundles", defaultValue="")
    private String rulesBundlesUri;
    @Parameter(property="transformer-plugin.direct", defaultValue="")
    private String rulesDirectUri;
    @Parameter(property="transformer-plugin.per-class-constant", defaultValue="")
    private String rulesPerClassConstantUri;
    @Parameter(property="transformer-plugin.xml", defaultValue="")
    private String rulesXmlsUri;
    @Parameter(defaultValue="transformed")
    private String classifier;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Inject
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoFailureException, MojoExecutionException {
        Artifact[] sourceArtifacts;
        for (Artifact sourceArtifact : sourceArtifacts = this.getSourceArtifacts()) {
            this.transform(sourceArtifact);
        }
    }

    public void transform(final Artifact sourceArtifact) throws MojoFailureException, MojoExecutionException {
        Transformer.ResultCode rc;
        String sourceClassifier = sourceArtifact.getClassifier();
        String targetClassifier = sourceClassifier == null || sourceClassifier.isEmpty() ? this.classifier : sourceClassifier + "-" + this.classifier;
        final File targetFile = new File(this.outputDirectory, sourceArtifact.getArtifactId() + "-" + targetClassifier + "-" + sourceArtifact.getVersion() + "." + sourceArtifact.getType());
        TransformOptions options = new TransformOptions(){
            final Map<String, String> optionDefaults = JakartaTransform.getOptionDefaults();
            final Function<String, URL> ruleLoader = JakartaTransform.getRuleLoader();

            public boolean hasOption(AppOption option) {
                return switch (option) {
                    case AppOption.OVERWRITE -> TransformerRunMojo.this.overwrite;
                    case AppOption.INVERT -> TransformerRunMojo.this.invert;
                    case AppOption.STRIP_SIGNATURES -> TransformerRunMojo.this.stripSignatures;
                    default -> super.hasOption(option);
                };
            }

            public String getOptionValue(AppOption option) {
                return switch (option) {
                    case AppOption.RULES_RENAMES -> TransformerRunMojo.this.emptyAsNull(TransformerRunMojo.this.rulesRenamesUri);
                    case AppOption.RULES_VERSIONS -> TransformerRunMojo.this.emptyAsNull(TransformerRunMojo.this.rulesVersionUri);
                    case AppOption.RULES_BUNDLES -> TransformerRunMojo.this.emptyAsNull(TransformerRunMojo.this.rulesBundlesUri);
                    case AppOption.RULES_DIRECT -> TransformerRunMojo.this.emptyAsNull(TransformerRunMojo.this.rulesDirectUri);
                    case AppOption.RULES_MASTER_TEXT -> TransformerRunMojo.this.emptyAsNull(TransformerRunMojo.this.rulesXmlsUri);
                    case AppOption.RULES_PER_CLASS_CONSTANT -> TransformerRunMojo.this.emptyAsNull(TransformerRunMojo.this.rulesPerClassConstantUri);
                    default -> null;
                };
            }

            public List<String> getOptionValues(AppOption option) {
                String result = this.getOptionValue(option);
                if (Objects.nonNull(result)) {
                    return Collections.singletonList(result);
                }
                return null;
            }

            public String getDefaultValue(AppOption option) {
                return this.optionDefaults.get(option.getLongTag());
            }

            public Function<String, URL> getRuleLoader() {
                return this.ruleLoader;
            }

            public String getInputFileName() {
                return sourceArtifact.getFile().getAbsolutePath();
            }

            public String getOutputFileName() {
                return targetFile.getAbsolutePath();
            }
        };
        Transformer transformer = new Transformer(logger, options);
        try {
            rc = transformer.run();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Transformer failed with an exception", e);
        }
        if (rc != Transformer.ResultCode.SUCCESS_RC) {
            throw new MojoFailureException("Transformer failed with an error: " + rc);
        }
        if (this.attach) {
            this.projectHelper.attachArtifact(this.project, sourceArtifact.getType(), targetClassifier, targetFile);
        }
    }

    public Artifact[] getSourceArtifacts() {
        ArrayList<Artifact> artifactList = new ArrayList<Artifact>();
        if (this.project.getArtifact() != null && this.project.getArtifact().getFile() != null) {
            artifactList.add(this.project.getArtifact());
        }
        for (Artifact attachedArtifact : this.project.getAttachedArtifacts()) {
            if (attachedArtifact.getFile() == null) continue;
            artifactList.add(attachedArtifact);
        }
        return artifactList.toArray(new Artifact[0]);
    }

    private String emptyAsNull(String input) {
        return Objects.nonNull(input) && !(input = input.trim()).isEmpty() ? input : null;
    }

    void setProject(MavenProject project) {
        this.project = project;
    }

    void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    MavenProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    void setProjectHelper(MavenProjectHelper projectHelper) {
        this.projectHelper = projectHelper;
    }

    void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    void setAttach(boolean attach) {
        this.attach = attach;
    }

    void setStripSignatures(boolean stripSignatures) {
        this.stripSignatures = stripSignatures;
    }
}

