/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.model;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.json.bind.JsonbException;
import org.eclipse.yasson.internal.model.JsonbAnnotatedElement;

public class Property {
    private final String name;
    private final JsonbAnnotatedElement<Class<?>> declaringClassElement;
    private JsonbAnnotatedElement<Field> fieldElement;
    private JsonbAnnotatedElement<Method> getterElement;
    private JsonbAnnotatedElement<Method> setterElement;

    public Property(String name, JsonbAnnotatedElement<Class<?>> declaringClassModel) {
        this.name = name;
        this.declaringClassElement = declaringClassModel;
    }

    public String getName() {
        return this.name;
    }

    public Field getField() {
        if (this.fieldElement == null) {
            return null;
        }
        return this.fieldElement.getElement();
    }

    public void setField(Field field) {
        this.fieldElement = new JsonbAnnotatedElement<Field>(field);
    }

    public Method getGetter() {
        if (this.getterElement == null) {
            return null;
        }
        return this.getterElement.getElement();
    }

    public void setGetter(Method getter) {
        this.getterElement = new JsonbAnnotatedElement<Method>(getter);
    }

    public Method getSetter() {
        if (this.setterElement == null) {
            return null;
        }
        return this.setterElement.getElement();
    }

    public void setSetter(Method setter) {
        this.setterElement = new JsonbAnnotatedElement<Method>(setter);
    }

    public JsonbAnnotatedElement<Class<?>> getDeclaringClassElement() {
        return this.declaringClassElement;
    }

    public Type getPropertyType() {
        if (this.getField() != null) {
            return this.getField().getGenericType();
        }
        if (this.getGetter() != null) {
            return this.getGetter().getGenericReturnType();
        }
        if (this.getSetter() != null) {
            Type[] genericParameterTypes = this.getSetter().getGenericParameterTypes();
            if (genericParameterTypes.length != 1) {
                throw new JsonbException("Invalid count of arguments for setter: " + this.getSetter());
            }
            return genericParameterTypes[0];
        }
        throw new JsonbException("Empty property: " + this.name);
    }

    public JsonbAnnotatedElement<Field> getFieldElement() {
        return this.fieldElement;
    }

    public JsonbAnnotatedElement<Method> getGetterElement() {
        return this.getterElement;
    }

    public JsonbAnnotatedElement<Method> getSetterElement() {
        return this.setterElement;
    }
}

