/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.feature;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public class ResetFeaturesResponse {
    private final List<ResetFeatureStateStatus> features;
    private static final ParseField FEATURES = new ParseField("features", new String[0]);
    private static final ConstructingObjectParser<ResetFeaturesResponse, Void> PARSER = new ConstructingObjectParser("features_reset_status_response", true, (a, ctx) -> new ResetFeaturesResponse((List)a[0]));

    public ResetFeaturesResponse(List<ResetFeatureStateStatus> features) {
        this.features = features;
    }

    public List<ResetFeatureStateStatus> getFeatureResetStatuses() {
        return this.features;
    }

    public static ResetFeaturesResponse parse(XContentParser parser) {
        return (ResetFeaturesResponse)PARSER.apply(parser, null);
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), ResetFeatureStateStatus::parse, FEATURES);
    }

    public static class ResetFeatureStateStatus {
        private final String featureName;
        private final String status;
        private final Exception exception;
        private static final ParseField FEATURE_NAME = new ParseField("feature_name", new String[0]);
        private static final ParseField STATUS = new ParseField("status", new String[0]);
        private static final ParseField EXCEPTION = new ParseField("exception", new String[0]);
        private static final ConstructingObjectParser<ResetFeatureStateStatus, Void> PARSER = new ConstructingObjectParser("feature_state_reset_stats", true, (a, ctx) -> new ResetFeatureStateStatus((String)a[0], (String)a[1], (Exception)((ElasticsearchException)a[2])));

        ResetFeatureStateStatus(String featureName, String status, @Nullable Exception exception) {
            this.featureName = featureName;
            assert ("SUCCESS".equals(status) || "FAILURE".equals(status));
            this.status = status;
            assert (!"FAILURE".equals(status) ? Objects.isNull(exception) : Objects.nonNull(exception));
            this.exception = exception;
        }

        public static ResetFeatureStateStatus parse(XContentParser parser, Void ctx) {
            return (ResetFeatureStateStatus)PARSER.apply(parser, (Object)ctx);
        }

        public String getFeatureName() {
            return this.featureName;
        }

        public String getStatus() {
            return this.status;
        }

        @Nullable
        public Exception getException() {
            return this.exception;
        }

        static {
            PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> p.text(), FEATURE_NAME, ObjectParser.ValueType.STRING);
            PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> p.text(), STATUS, ObjectParser.ValueType.STRING);
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ElasticsearchException.fromXContent((XContentParser)p), EXCEPTION);
        }
    }
}

