/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.scanner;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.flywaydb.core.api.ClassProvider;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.scanner.LocationScannerCache;
import org.flywaydb.core.internal.scanner.ResourceNameCache;
import org.flywaydb.core.internal.scanner.android.AndroidScanner;
import org.flywaydb.core.internal.scanner.classpath.ClassPathScanner;
import org.flywaydb.core.internal.scanner.classpath.ResourceAndClassScanner;
import org.flywaydb.core.internal.scanner.filesystem.FileSystemScanner;
import org.flywaydb.core.internal.util.FeatureDetector;
import org.flywaydb.core.internal.util.StringUtils;

public class Scanner<I>
implements ResourceProvider,
ClassProvider<I> {
    private static final Log LOG = LogFactory.getLog(Scanner.class);
    private final List<LoadableResource> resources = new ArrayList<LoadableResource>();
    private final List<Class<? extends I>> classes = new ArrayList<Class<? extends I>>();

    public Scanner(Class<I> implementedInterface, Collection<Location> locations, ClassLoader classLoader, Charset encoding, ResourceNameCache resourceNameCache, LocationScannerCache locationScannerCache) {
        FileSystemScanner fileSystemScanner = new FileSystemScanner(encoding);
        boolean android = new FeatureDetector(classLoader).isAndroidAvailable();
        for (Location location : locations) {
            if (location.isFileSystem()) {
                this.resources.addAll(fileSystemScanner.scanForResources(location));
                continue;
            }
            ResourceAndClassScanner<I> resourceAndClassScanner = android ? new AndroidScanner<I>(implementedInterface, classLoader, encoding, location) : new ClassPathScanner<I>(implementedInterface, classLoader, encoding, location, resourceNameCache, locationScannerCache);
            this.resources.addAll(resourceAndClassScanner.scanForResources());
            this.classes.addAll(resourceAndClassScanner.scanForClasses());
        }
    }

    @Override
    public LoadableResource getResource(String name) {
        for (LoadableResource resource : this.resources) {
            String absolutePath = resource.getAbsolutePathOnDisk();
            String relativePath = resource.getRelativePath();
            if (!relativePath.equals(name) && !absolutePath.equals(name)) continue;
            return resource;
        }
        return null;
    }

    @Override
    public Collection<LoadableResource> getResources(String prefix, String ... suffixes) {
        ArrayList<LoadableResource> result = new ArrayList<LoadableResource>();
        for (LoadableResource resource : this.resources) {
            String fileName = resource.getFilename();
            if (StringUtils.startsAndEndsWith(fileName, prefix, suffixes)) {
                result.add(resource);
                continue;
            }
            LOG.debug("Filtering out resource: " + resource.getAbsolutePath() + " (filename: " + fileName + ")");
        }
        return result;
    }

    @Override
    public Collection<Class<? extends I>> getClasses() {
        return Collections.unmodifiableCollection(this.classes);
    }
}

