/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.configuration.models;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.flywaydb.core.internal.util.MergeUtils;

public class EnvironmentModel {
    private String url;
    private String user;
    private String password;
    private String driver;
    private List<String> schemas;
    private String token;
    private Integer connectRetries;
    private Integer connectRetriesInterval;
    private String initSql;
    private Map<String, String> jdbcProperties;
    private Map<String, Map<String, String>> resolvers;

    public static EnvironmentModel defaults() {
        EnvironmentModel model = new EnvironmentModel();
        model.schemas = new ArrayList<String>();
        model.connectRetries = 0;
        model.connectRetriesInterval = 120;
        return model;
    }

    public EnvironmentModel merge(EnvironmentModel otherPojo) {
        EnvironmentModel result = new EnvironmentModel();
        result.url = MergeUtils.merge(this.url, otherPojo.url);
        result.user = MergeUtils.merge(this.user, otherPojo.user);
        result.password = MergeUtils.merge(this.password, otherPojo.password);
        result.driver = MergeUtils.merge(this.driver, otherPojo.driver);
        result.schemas = MergeUtils.merge(this.schemas, otherPojo.schemas);
        result.token = MergeUtils.merge(this.token, otherPojo.token);
        result.connectRetries = MergeUtils.merge(this.connectRetries, otherPojo.connectRetries);
        result.connectRetriesInterval = MergeUtils.merge(this.connectRetriesInterval, otherPojo.connectRetriesInterval);
        result.initSql = MergeUtils.merge(this.initSql, otherPojo.initSql);
        result.jdbcProperties = MergeUtils.merge(this.jdbcProperties, otherPojo.jdbcProperties, MergeUtils::merge);
        result.resolvers = MergeUtils.merge(this.resolvers, otherPojo.resolvers, (a, b) -> b != null ? b : a);
        return result;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDriver() {
        return this.driver;
    }

    public List<String> getSchemas() {
        return this.schemas;
    }

    public String getToken() {
        return this.token;
    }

    public Integer getConnectRetries() {
        return this.connectRetries;
    }

    public Integer getConnectRetriesInterval() {
        return this.connectRetriesInterval;
    }

    public String getInitSql() {
        return this.initSql;
    }

    public Map<String, String> getJdbcProperties() {
        return this.jdbcProperties;
    }

    public Map<String, Map<String, String>> getResolvers() {
        return this.resolvers;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setSchemas(List<String> schemas) {
        this.schemas = schemas;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setConnectRetries(Integer connectRetries) {
        this.connectRetries = connectRetries;
    }

    public void setConnectRetriesInterval(Integer connectRetriesInterval) {
        this.connectRetriesInterval = connectRetriesInterval;
    }

    public void setInitSql(String initSql) {
        this.initSql = initSql;
    }

    public void setJdbcProperties(Map<String, String> jdbcProperties) {
        this.jdbcProperties = jdbcProperties;
    }

    public void setResolvers(Map<String, Map<String, String>> resolvers) {
        this.resolvers = resolvers;
    }
}

