/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.postgresql;

import java.util.Map;
import org.flywaydb.core.extensibility.ConfigurationExtension;

public class PostgreSQLConfigurationExtension
implements ConfigurationExtension {
    private static final String TRANSACTIONAL_LOCK = "flyway.postgresql.transactional.lock";
    private boolean transactionalLock = true;

    @Override
    public void extractParametersFromConfiguration(Map<String, String> configuration) {
        this.transactionalLock = Boolean.parseBoolean(configuration.getOrDefault(TRANSACTIONAL_LOCK, Boolean.toString(this.transactionalLock)));
        configuration.remove(TRANSACTIONAL_LOCK);
    }

    @Override
    public String getConfigurationParameterFromEnvironmentVariable(String environmentVariable) {
        if ("FLYWAY_POSTGRESQL_TRANSACTIONAL_LOCK".equals(environmentVariable)) {
            return TRANSACTIONAL_LOCK;
        }
        return null;
    }

    public boolean isTransactionalLock() {
        return this.transactionalLock;
    }

    public void setTransactionalLock(boolean transactionalLock) {
        this.transactionalLock = transactionalLock;
    }
}

