/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later.
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package org.hibernate.hql.internal.ast;

import java.io.Reader;

import org.hibernate.QueryException;
import org.hibernate.hql.internal.antlr.HqlBaseLexer;

import antlr.Token;

/**
 * Custom lexer for the HQL grammar.  Extends the base lexer generated by ANTLR
 * in order to keep the grammar source file clean.
 */
class HqlLexer extends HqlBaseLexer {
	private boolean possibleID;

	public HqlLexer(Reader in) {
		super( in );
	}

	@Override
	public void setTokenObjectClass(String cl) {
		this.tokenObjectClass = HqlToken.class;
	}

	@Override
	protected void setPossibleID(boolean possibleID) {
		this.possibleID = possibleID;
	}

	@Override
	protected Token makeToken(int i) {
		HqlToken token = (HqlToken) super.makeToken( i );
		token.setPossibleID( possibleID );
		possibleID = false;
		return token;
	}

	@Override
	public void panic() {
		//overridden to avoid System.exit
		panic( "CharScanner: panic" );
	}

	@Override
	public void panic(String s) {
		//overridden to avoid System.exit
		throw new QueryException( s );
	}
}
