---
-- #%L
-- %%
-- Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---
--
-- Copyright © 2005-2021 Kuali, Inc.
-- All Rights Reserved
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
--
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
--

--Original mySQL
/*
-- Add ALLOWS_MULTIPLE_VALUES column --
ALTER TABLE custom_attribute ADD COLUMN ALLOWS_MULTIPLE_VALUES CHAR(1) NOT NULL DEFAULT 'N';

-- Create a KRMS type for CustomDataJavaFunctionKrmsTermService --
SET @idPrefix = 'KC';
SET @idPrefixLike = CONCAT(@idPrefix, '%');
SET @idSuffixStart = LENGTH(@idPrefix) + 1;

-- NOTE: Not using sequence tables (..._s) because they don't always work with any given ID prefix.
SET @typeId = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(TYP_ID, @idSuffixStart) AS UNSIGNED) + 1) FROM KRMS_TYP_T WHERE TYP_ID LIKE @idPrefixLike));

insert into KRMS_TYP_T (TYP_ID, NM, NMSPC_CD, SRVC_NM, ACTV, VER_NBR)
values (@typeId, 'Custom Data Java Function Term Service', 'KC-KRMS', 'customDataJavaFunctionKrmsTermService', 'Y', 1);

SET @funcName = 'containsValue';
SET @funcDesc = 'Check if value is in custom attribute\'s list of values';

-- Create Development Proposal Function --
SET @funcId = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(func_id, @idSuffixStart) AS UNSIGNED)) FROM krms_func_t WHERE func_id LIKE @idPrefixLike) + 1);
SET @nmspCd = 'KC-PD';
SET @nmspAbbrev = 'PD';
SET @boName = 'DevelopmentProposal';
SET @boParamDesc = 'Development Proposal BO';
SET @boParamTyp = 'org.kuali.coeus.propdev.impl.core.DevelopmentProposal';
SET @ctgryId = 'RES-BOOT1032';
SET @contextId = 'KC-PD-CONTEXT';

-- NOTE: The inserts below are copied exactly for each function this script creates.
insert into krms_func_t (func_id, nmspc_cd, nm, desc_txt, rtrn_typ, typ_id, actv, ver_nbr)
values (@funcId, @nmspCd, @funcName, @funcDesc, 'java.lang.Boolean', @typeId, 'Y', 1);

SET @func_parm_id = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(func_parm_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_func_parm_t WHERE func_parm_id LIKE @idPrefixLike));
insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values (@func_parm_id, @boName, @boParamDesc, @boParamTyp, @funcId, 1);

SET @func_parm_id = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(func_parm_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_func_parm_t WHERE func_parm_id LIKE @idPrefixLike));
insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values (@func_parm_id, 'Custom Attribute Id', 'Custom Attribute Id', 'java.lang.String', @funcId, 2);

SET @func_parm_id = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(func_parm_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_func_parm_t WHERE func_parm_id LIKE @idPrefixLike));
insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values (@func_parm_id, 'Value', 'Value', 'java.lang.String', @funcId, 3);

SET @termSpecId = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(term_spec_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_term_spec_t WHERE term_spec_id LIKE @idPrefixLike));
insert into krms_term_spec_t (term_spec_id, nm, typ, actv, ver_nbr, desc_txt, nmspc_cd)
values (@termSpecId, @funcId, 'java.lang.Boolean', 'Y', 1, @funcDesc, @nmspCd);

SET @termResolverId = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(term_rslvr_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_term_rslvr_t WHERE term_rslvr_id LIKE @idPrefixLike));
insert into krms_term_rslvr_t (term_rslvr_id, nmspc_cd, nm, typ_id, output_term_spec_id, actv, ver_nbr)
values (@termResolverId, @nmspCd, CONCAT(@nmspAbbrev, ' Contains Value Resolver'), 'KC1001', @termSpecId, 'Y', 1);

SET @termRslvrParmSpecId = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(term_rslvr_parm_spec_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_term_rslvr_parm_spec_t WHERE term_rslvr_parm_spec_id LIKE @idPrefixLike));
insert into krms_term_rslvr_parm_spec_t (term_rslvr_parm_spec_id, term_rslvr_id, nm, ver_nbr)
values (@termRslvrParmSpecId, @termResolverId, 'Custom Attribute Id', 1);

SET @termRslvrParmSpecId = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(term_rslvr_parm_spec_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_term_rslvr_parm_spec_t WHERE term_rslvr_parm_spec_id LIKE @idPrefixLike));
insert into krms_term_rslvr_parm_spec_t (term_rslvr_parm_spec_id, term_rslvr_id, nm, ver_nbr)
values (@termRslvrParmSpecId, @termResolverId, 'Value', 1);

SET @ctxValidTermSpecId = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(cntxt_term_spec_prereq_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_cntxt_vld_term_spec_t WHERE cntxt_term_spec_prereq_id LIKE @idPrefixLike));
insert into krms_cntxt_vld_term_spec_t (cntxt_term_spec_prereq_id, cntxt_id, term_spec_id, prereq)
values (@ctxValidTermSpecId, @contextId, @termSpecId, 'Y');

insert into krms_term_spec_ctgry_t (term_spec_id, ctgry_id)
values (@termSpecId, @ctgryId);

-- Create Institutional Proposal Function --
SET @funcId = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(func_id, @idSuffixStart) AS UNSIGNED)) FROM krms_func_t WHERE func_id LIKE @idPrefixLike) + 1);
SET @nmspCd = 'KC-IP';
SET @nmspAbbrev = 'IP';
SET @boName = 'InstitutionalProposal';
SET @boParamDesc = 'Institutional Proposal BO';
SET @boParamTyp = 'org.kuali.kra.institutionalproposal.home.InstitutionalProposal';
SET @ctgryId = 'RES-BOOT1027';
SET @contextId = 'KC-IP-CONTEXT';

insert into krms_func_t (func_id, nmspc_cd, nm, desc_txt, rtrn_typ, typ_id, actv, ver_nbr)
values (@funcId, @nmspCd, @funcName, @funcDesc, 'java.lang.Boolean', @typeId, 'Y', 1);

SET @func_parm_id = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(func_parm_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_func_parm_t WHERE func_parm_id LIKE @idPrefixLike));
insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values (@func_parm_id, @boName, @boParamDesc, @boParamTyp, @funcId, 1);

SET @func_parm_id = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(func_parm_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_func_parm_t WHERE func_parm_id LIKE @idPrefixLike));
insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values (@func_parm_id, 'Custom Attribute Id', 'Custom Attribute Id', 'java.lang.String', @funcId, 2);

SET @func_parm_id = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(func_parm_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_func_parm_t WHERE func_parm_id LIKE @idPrefixLike));
insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values (@func_parm_id, 'Value', 'Value', 'java.lang.String', @funcId, 3);

SET @termSpecId = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(term_spec_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_term_spec_t WHERE term_spec_id LIKE @idPrefixLike));
insert into krms_term_spec_t (term_spec_id, nm, typ, actv, ver_nbr, desc_txt, nmspc_cd)
values (@termSpecId, @funcId, 'java.lang.Boolean', 'Y', 1, @funcDesc, @nmspCd);

SET @termResolverId = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(term_rslvr_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_term_rslvr_t WHERE term_rslvr_id LIKE @idPrefixLike));
insert into krms_term_rslvr_t (term_rslvr_id, nmspc_cd, nm, typ_id, output_term_spec_id, actv, ver_nbr)
values (@termResolverId, @nmspCd, CONCAT(@nmspAbbrev, ' Contains Value Resolver'), 'KC1001', @termSpecId, 'Y', 1);

SET @termRslvrParmSpecId = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(term_rslvr_parm_spec_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_term_rslvr_parm_spec_t WHERE term_rslvr_parm_spec_id LIKE @idPrefixLike));
insert into krms_term_rslvr_parm_spec_t (term_rslvr_parm_spec_id, term_rslvr_id, nm, ver_nbr)
values (@termRslvrParmSpecId, @termResolverId, 'Custom Attribute Id', 1);

SET @termRslvrParmSpecId = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(term_rslvr_parm_spec_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_term_rslvr_parm_spec_t WHERE term_rslvr_parm_spec_id LIKE @idPrefixLike));
insert into krms_term_rslvr_parm_spec_t (term_rslvr_parm_spec_id, term_rslvr_id, nm, ver_nbr)
values (@termRslvrParmSpecId, @termResolverId, 'Value', 1);

SET @ctxValidTermSpecId = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(cntxt_term_spec_prereq_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_cntxt_vld_term_spec_t WHERE cntxt_term_spec_prereq_id LIKE @idPrefixLike));
insert into krms_cntxt_vld_term_spec_t (cntxt_term_spec_prereq_id, cntxt_id, term_spec_id, prereq)
values (@ctxValidTermSpecId, @contextId, @termSpecId, 'Y');

insert into krms_term_spec_ctgry_t (term_spec_id, ctgry_id)
values (@termSpecId, @ctgryId);

-- Create Award Function --
SET @funcId = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(func_id, @idSuffixStart) AS UNSIGNED)) FROM krms_func_t WHERE func_id LIKE @idPrefixLike) + 1);
SET @nmspCd = 'KC-AWARD';
SET @nmspAbbrev = 'Award';
SET @boName = 'Award';
SET @boParamDesc = 'Award BO';
SET @boParamTyp = 'org.kuali.kra.award.home.Award';
SET @ctgryId = 'RES-BOOT1028';
SET @contextId = 'KC-AWARD-CONTEXT';

insert into krms_func_t (func_id, nmspc_cd, nm, desc_txt, rtrn_typ, typ_id, actv, ver_nbr)
values (@funcId, @nmspCd, @funcName, @funcDesc, 'java.lang.Boolean', @typeId, 'Y', 1);

SET @func_parm_id = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(func_parm_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_func_parm_t WHERE func_parm_id LIKE @idPrefixLike));
insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values (@func_parm_id, @boName, @boParamDesc, @boParamTyp, @funcId, 1);

SET @func_parm_id = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(func_parm_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_func_parm_t WHERE func_parm_id LIKE @idPrefixLike));
insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values (@func_parm_id, 'Custom Attribute Id', 'Custom Attribute Id', 'java.lang.String', @funcId, 2);

SET @func_parm_id = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(func_parm_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_func_parm_t WHERE func_parm_id LIKE @idPrefixLike));
insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values (@func_parm_id, 'Value', 'Value', 'java.lang.String', @funcId, 3);

SET @termSpecId = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(term_spec_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_term_spec_t WHERE term_spec_id LIKE @idPrefixLike));
insert into krms_term_spec_t (term_spec_id, nm, typ, actv, ver_nbr, desc_txt, nmspc_cd)
values (@termSpecId, @funcId, 'java.lang.Boolean', 'Y', 1, @funcDesc, @nmspCd);

SET @termResolverId = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(term_rslvr_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_term_rslvr_t WHERE term_rslvr_id LIKE @idPrefixLike));
insert into krms_term_rslvr_t (term_rslvr_id, nmspc_cd, nm, typ_id, output_term_spec_id, actv, ver_nbr)
values (@termResolverId, @nmspCd, CONCAT(@nmspAbbrev, ' Contains Value Resolver'), 'KC1001', @termSpecId, 'Y', 1);

SET @termRslvrParmSpecId = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(term_rslvr_parm_spec_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_term_rslvr_parm_spec_t WHERE term_rslvr_parm_spec_id LIKE @idPrefixLike));
insert into krms_term_rslvr_parm_spec_t (term_rslvr_parm_spec_id, term_rslvr_id, nm, ver_nbr)
values (@termRslvrParmSpecId, @termResolverId, 'Custom Attribute Id', 1);

SET @termRslvrParmSpecId = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(term_rslvr_parm_spec_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_term_rslvr_parm_spec_t WHERE term_rslvr_parm_spec_id LIKE @idPrefixLike));
insert into krms_term_rslvr_parm_spec_t (term_rslvr_parm_spec_id, term_rslvr_id, nm, ver_nbr)
values (@termRslvrParmSpecId, @termResolverId, 'Value', 1);

SET @ctxValidTermSpecId = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(cntxt_term_spec_prereq_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_cntxt_vld_term_spec_t WHERE cntxt_term_spec_prereq_id LIKE @idPrefixLike));
insert into krms_cntxt_vld_term_spec_t (cntxt_term_spec_prereq_id, cntxt_id, term_spec_id, prereq)
values (@ctxValidTermSpecId, @contextId, @termSpecId, 'Y');

insert into krms_term_spec_ctgry_t (term_spec_id, ctgry_id)
values (@termSpecId, @ctgryId);

-- Create Sub Award Function --
SET @funcId = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(func_id, @idSuffixStart) AS UNSIGNED)) FROM krms_func_t WHERE func_id LIKE @idPrefixLike) + 1);
SET @nmspCd = 'KC-SUBAWARD';
SET @nmspAbbrev = 'Subaward';
SET @boName = 'SubAward';
SET @boParamDesc = 'Sub Award BO';
SET @boParamTyp = 'org.kuali.kra.subaward.bo.SubAward';
SET @ctgryId = 'RES-BOOT1029';
SET @contextId = 'KC-SUBAWARD-CONTEXT';

insert into krms_func_t (func_id, nmspc_cd, nm, desc_txt, rtrn_typ, typ_id, actv, ver_nbr)
values (@funcId, @nmspCd, @funcName, @funcDesc, 'java.lang.Boolean', @typeId, 'Y', 1);

SET @func_parm_id = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(func_parm_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_func_parm_t WHERE func_parm_id LIKE @idPrefixLike));
insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values (@func_parm_id, @boName, @boParamDesc, @boParamTyp, @funcId, 1);

SET @func_parm_id = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(func_parm_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_func_parm_t WHERE func_parm_id LIKE @idPrefixLike));
insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values (@func_parm_id, 'Custom Attribute Id', 'Custom Attribute Id', 'java.lang.String', @funcId, 2);

SET @func_parm_id = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(func_parm_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_func_parm_t WHERE func_parm_id LIKE @idPrefixLike));
insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values (@func_parm_id, 'Value', 'Value', 'java.lang.String', @funcId, 3);

SET @termSpecId = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(term_spec_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_term_spec_t WHERE term_spec_id LIKE @idPrefixLike));
insert into krms_term_spec_t (term_spec_id, nm, typ, actv, ver_nbr, desc_txt, nmspc_cd)
values (@termSpecId, @funcId, 'java.lang.Boolean', 'Y', 1, @funcDesc, @nmspCd);

SET @termResolverId = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(term_rslvr_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_term_rslvr_t WHERE term_rslvr_id LIKE @idPrefixLike));
insert into krms_term_rslvr_t (term_rslvr_id, nmspc_cd, nm, typ_id, output_term_spec_id, actv, ver_nbr)
values (@termResolverId, @nmspCd, CONCAT(@nmspAbbrev, ' Contains Value Resolver'), 'KC1001', @termSpecId, 'Y', 1);

SET @termRslvrParmSpecId = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(term_rslvr_parm_spec_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_term_rslvr_parm_spec_t WHERE term_rslvr_parm_spec_id LIKE @idPrefixLike));
insert into krms_term_rslvr_parm_spec_t (term_rslvr_parm_spec_id, term_rslvr_id, nm, ver_nbr)
values (@termRslvrParmSpecId, @termResolverId, 'Custom Attribute Id', 1);

SET @termRslvrParmSpecId = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(term_rslvr_parm_spec_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_term_rslvr_parm_spec_t WHERE term_rslvr_parm_spec_id LIKE @idPrefixLike));
insert into krms_term_rslvr_parm_spec_t (term_rslvr_parm_spec_id, term_rslvr_id, nm, ver_nbr)
values (@termRslvrParmSpecId, @termResolverId, 'Value', 1);

SET @ctxValidTermSpecId = CONCAT(@idPrefix, (SELECT MAX(CAST(SUBSTRING(cntxt_term_spec_prereq_id, @idSuffixStart) AS UNSIGNED) + 1) FROM krms_cntxt_vld_term_spec_t WHERE cntxt_term_spec_prereq_id LIKE @idPrefixLike));
insert into krms_cntxt_vld_term_spec_t (cntxt_term_spec_prereq_id, cntxt_id, term_spec_id, prereq)
values (@ctxValidTermSpecId, @contextId, @termSpecId, 'Y');

insert into krms_term_spec_ctgry_t (term_spec_id, ctgry_id)
values (@termSpecId, @ctgryId);
*/




--Converted to Oracle

-- Add ALLOWS_MULTIPLE_VALUES column --
ALTER TABLE custom_attribute ADD COLUMN ALLOWS_MULTIPLE_VALUES CHAR(1) NOT NULL DEFAULT 'N';
-- Create a KRMS type for CustomDataJavaFunctionKrmsTermService --
Declare 
idPrefix varchar2(40); 
idPrefixLike varchar2(20);
idSuffixStart Number;
typeId varchar2(20);
funcName varchar2(100);
funcDesc varchar2(255);
funcId varchar2(40);
nmspCd varchar2(40);
nmspAbbrev varchar2(20);
boName varchar2(100);
boParamDesc varchar2(255);
boParamTyp varchar2(255);
ctgryId varchar2(40);
contextId varchar2(40);
func_parm_id varchar2(40);
termSpecId varchar2(40);
termResolverId varchar2(40);
termRslvrParmSpecId varchar2(40);
ctxValidTermSpecId varchar2(40);
Begin
-- Create a KRMS type for CustomDataJavaFunctionKrmsTermService --
idPrefix := 'KC';
idPrefixLike := CONCAT(idPrefix, '%');
idSuffixStart := LENGTH(idPrefix) + 1;
Select CONCAT(idPrefix, (SELECT MAX(To_Number (SUBSTR(TYP_ID,idSuffixStart),'9999999') + 1) FROM KRMS_TYP_T WHERE TYP_ID LIKE idPrefixLike))Into typeId from dual;
insert into KRMS_TYP_T (TYP_ID, NM, NMSPC_CD, SRVC_NM, ACTV, VER_NBR)
values (typeId, 'Custom Data Java Function Term Service', 'KC-KRMS', 'customDataJavaFunctionKrmsTermService', 'Y', 1);
funcName := 'containsValue';
funcDesc := 'Check if value is in custom attribute''s list of values';
Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(func_id,idSuffixStart),'9999999')) FROM krms_func_t WHERE func_id LIKE idPrefixLike) + 1) Into funcId from dual;
nmspCd := 'KC-PD';
nmspAbbrev := 'PD';
boName := 'DevelopmentProposal';
boParamDesc := 'Development Proposal BO';
boParamTyp := 'org.kuali.coeus.propdev.impl.core.DevelopmentProposal';
ctgryId := 'RES-BOOT1032';
contextId := 'KC-PD-CONTEXT';

insert into krms_func_t (func_id, nmspc_cd, nm, desc_txt, rtrn_typ, typ_id, actv, ver_nbr)
values (funcId,nmspCd,funcName,funcDesc, 'java.lang.Boolean',typeId,'Y',1);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(func_parm_id, idSuffixStart),'9999999') + 1) FROM krms_func_parm_t WHERE func_parm_id LIKE idPrefixLike)) Into func_parm_id from dual;
insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values (func_parm_id, boName, boParamDesc, boParamTyp, funcId, 1);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(func_parm_id, idSuffixStart),'9999999') + 1) FROM krms_func_parm_t WHERE func_parm_id LIKE idPrefixLike)) Into func_parm_id from dual;
insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values (func_parm_id, 'Custom Attribute Id', 'Custom Attribute Id', 'java.lang.String', funcId, 2);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(func_parm_id, idSuffixStart),'9999999') + 1) FROM krms_func_parm_t WHERE func_parm_id LIKE idPrefixLike)) Into func_parm_id from dual;
insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values (func_parm_id, 'Value', 'Value', 'java.lang.String', funcId, 3);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(term_spec_id, idSuffixStart),'9999999') + 1) FROM krms_term_spec_t WHERE term_spec_id LIKE idPrefixLike)) Into termSpecId from dual;
insert into krms_term_spec_t (term_spec_id, nm, typ, actv, ver_nbr, desc_txt, nmspc_cd)
values (termSpecId, funcId, 'java.lang.Boolean', 'Y', 1, funcDesc, nmspCd);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(term_rslvr_id, idSuffixStart),'9999999') + 1) FROM krms_term_rslvr_t WHERE term_rslvr_id LIKE idPrefixLike)) Into termResolverId from dual;
insert into krms_term_rslvr_t (term_rslvr_id, nmspc_cd, nm, typ_id, output_term_spec_id, actv, ver_nbr)
values (termResolverId, nmspCd, CONCAT(nmspAbbrev, ' Contains Value Resolver'), 'KC1001', termSpecId, 'Y', 1);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(term_rslvr_parm_spec_id, idSuffixStart),'9999999') + 1) FROM krms_term_rslvr_parm_spec_t WHERE term_rslvr_parm_spec_id LIKE idPrefixLike)) Into termRslvrParmSpecId from dual;
insert into krms_term_rslvr_parm_spec_t (term_rslvr_parm_spec_id, term_rslvr_id, nm, ver_nbr)
values (termRslvrParmSpecId, termResolverId, 'Custom Attribute Id', 1);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(term_rslvr_parm_spec_id, idSuffixStart),'9999999') + 1) FROM krms_term_rslvr_parm_spec_t WHERE term_rslvr_parm_spec_id LIKE idPrefixLike)) Into termRslvrParmSpecId from dual;
insert into krms_term_rslvr_parm_spec_t (term_rslvr_parm_spec_id, term_rslvr_id, nm, ver_nbr)
values (termRslvrParmSpecId, termResolverId, 'Value', 1);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(cntxt_term_spec_prereq_id, idSuffixStart),'9999999') + 1) FROM krms_cntxt_vld_term_spec_t WHERE cntxt_term_spec_prereq_id LIKE idPrefixLike)) Into ctxValidTermSpecId from dual;
insert into krms_cntxt_vld_term_spec_t (cntxt_term_spec_prereq_id, cntxt_id, term_spec_id, prereq)
values (ctxValidTermSpecId, contextId, termSpecId, 'Y');

insert into krms_term_spec_ctgry_t (term_spec_id, ctgry_id)
values (termSpecId, ctgryId);

-- Create Institutional Proposal Function --
Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(func_id,idSuffixStart),'9999999')) FROM krms_func_t WHERE func_id LIKE idPrefixLike) + 1) Into funcId from dual;
nmspCd := 'KC-IP';
nmspAbbrev := 'IP';
boName := 'InstitutionalProposal';
boParamDesc := 'Institutional Proposal BO';
boParamTyp := 'org.kuali.kra.institutionalproposal.home.InstitutionalProposal';
ctgryId := 'RES-BOOT1027';
contextId := 'KC-IP-CONTEXT';

insert into krms_func_t (func_id, nmspc_cd, nm, desc_txt, rtrn_typ, typ_id, actv, ver_nbr)
values (funcId, nmspCd, funcName, funcDesc, 'java.lang.Boolean', typeId, 'Y', 1);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(func_parm_id, idSuffixStart),'9999999') + 1) FROM krms_func_parm_t WHERE func_parm_id LIKE idPrefixLike)) Into func_parm_id from dual;
insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values (func_parm_id, boName, boParamDesc, boParamTyp, funcId, 1);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(func_parm_id, idSuffixStart),'9999999') + 1) FROM krms_func_parm_t WHERE func_parm_id LIKE idPrefixLike)) Into func_parm_id from dual;
insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values (func_parm_id, 'Custom Attribute Id', 'Custom Attribute Id', 'java.lang.String', funcId, 2);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(func_parm_id, idSuffixStart),'9999999') + 1) FROM krms_func_parm_t WHERE func_parm_id LIKE idPrefixLike)) Into func_parm_id from dual;
insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values (func_parm_id, 'Value', 'Value', 'java.lang.String', funcId, 3);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(term_spec_id, idSuffixStart),'9999999') + 1) FROM krms_term_spec_t WHERE term_spec_id LIKE idPrefixLike)) Into termSpecId from dual;
insert into krms_term_spec_t (term_spec_id, nm, typ, actv, ver_nbr, desc_txt, nmspc_cd)
values (termSpecId, funcId, 'java.lang.Boolean', 'Y', 1, funcDesc, nmspCd);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(term_rslvr_id, idSuffixStart),'9999999') + 1) FROM krms_term_rslvr_t WHERE term_rslvr_id LIKE idPrefixLike)) Into termResolverId from dual;
insert into krms_term_rslvr_t (term_rslvr_id, nmspc_cd, nm, typ_id, output_term_spec_id, actv, ver_nbr)
values (termResolverId, nmspCd, CONCAT(nmspAbbrev, ' Contains Value Resolver'), 'KC1001', termSpecId, 'Y', 1);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(term_rslvr_parm_spec_id, idSuffixStart),'9999999') + 1) FROM krms_term_rslvr_parm_spec_t WHERE term_rslvr_parm_spec_id LIKE idPrefixLike)) Into termRslvrParmSpecId from dual;
insert into krms_term_rslvr_parm_spec_t (term_rslvr_parm_spec_id, term_rslvr_id, nm, ver_nbr)
values (termRslvrParmSpecId, termResolverId, 'Custom Attribute Id', 1);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(term_rslvr_parm_spec_id, idSuffixStart),'9999999') + 1) FROM krms_term_rslvr_parm_spec_t WHERE term_rslvr_parm_spec_id LIKE idPrefixLike)) Into termRslvrParmSpecId from dual;
insert into krms_term_rslvr_parm_spec_t (term_rslvr_parm_spec_id, term_rslvr_id, nm, ver_nbr)
values (termRslvrParmSpecId, termResolverId, 'Value', 1);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(cntxt_term_spec_prereq_id, idSuffixStart),'9999999') + 1) FROM krms_cntxt_vld_term_spec_t WHERE cntxt_term_spec_prereq_id LIKE idPrefixLike)) Into ctxValidTermSpecId from dual;
insert into krms_cntxt_vld_term_spec_t (cntxt_term_spec_prereq_id, cntxt_id, term_spec_id, prereq)
values (ctxValidTermSpecId, contextId, termSpecId, 'Y');

insert into krms_term_spec_ctgry_t (term_spec_id, ctgry_id)
values (termSpecId, ctgryId);

-- Create Award Function --
Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(func_id,idSuffixStart),'9999999')) FROM krms_func_t WHERE func_id LIKE idPrefixLike) + 1) Into funcId from dual;
nmspCd := 'KC-AWARD';
nmspAbbrev := 'Award';
boName := 'Award';
boParamDesc := 'Award BO';
boParamTyp := 'org.kuali.kra.award.home.Award';
ctgryId := 'RES-BOOT1028';
contextId := 'KC-AWARD-CONTEXT';

insert into krms_func_t (func_id, nmspc_cd, nm, desc_txt, rtrn_typ, typ_id, actv, ver_nbr)
values (funcId, nmspCd, funcName, funcDesc, 'java.lang.Boolean', typeId, 'Y', 1);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(func_parm_id, idSuffixStart),'9999999') + 1) FROM krms_func_parm_t WHERE func_parm_id LIKE idPrefixLike)) Into func_parm_id from dual;
insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values (func_parm_id, boName, boParamDesc, boParamTyp, funcId, 1);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(func_parm_id, idSuffixStart),'9999999') + 1) FROM krms_func_parm_t WHERE func_parm_id LIKE idPrefixLike)) Into func_parm_id from dual;
insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values (func_parm_id, 'Custom Attribute Id', 'Custom Attribute Id', 'java.lang.String', funcId, 2);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(func_parm_id, idSuffixStart),'9999999') + 1) FROM krms_func_parm_t WHERE func_parm_id LIKE idPrefixLike)) Into func_parm_id from dual;
insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values (func_parm_id, 'Value', 'Value', 'java.lang.String', funcId, 3);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(term_spec_id, idSuffixStart),'9999999') + 1) FROM krms_term_spec_t WHERE term_spec_id LIKE idPrefixLike)) Into termSpecId from dual;
insert into krms_term_spec_t (term_spec_id, nm, typ, actv, ver_nbr, desc_txt, nmspc_cd)
values (termSpecId, funcId, 'java.lang.Boolean', 'Y', 1, funcDesc, nmspCd);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(term_rslvr_id, idSuffixStart),'9999999') + 1) FROM krms_term_rslvr_t WHERE term_rslvr_id LIKE idPrefixLike)) Into termResolverId from dual;
insert into krms_term_rslvr_t (term_rslvr_id, nmspc_cd, nm, typ_id, output_term_spec_id, actv, ver_nbr)
values (termResolverId, nmspCd, CONCAT(nmspAbbrev, ' Contains Value Resolver'), 'KC1001', termSpecId, 'Y', 1);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(term_rslvr_parm_spec_id, idSuffixStart),'9999999') + 1) FROM krms_term_rslvr_parm_spec_t WHERE term_rslvr_parm_spec_id LIKE idPrefixLike)) Into termRslvrParmSpecId from dual;
insert into krms_term_rslvr_parm_spec_t (term_rslvr_parm_spec_id, term_rslvr_id, nm, ver_nbr)
values (termRslvrParmSpecId, termResolverId, 'Custom Attribute Id', 1);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(term_rslvr_parm_spec_id, idSuffixStart),'9999999') + 1) FROM krms_term_rslvr_parm_spec_t WHERE term_rslvr_parm_spec_id LIKE idPrefixLike)) Into termRslvrParmSpecId from dual;
insert into krms_term_rslvr_parm_spec_t (term_rslvr_parm_spec_id, term_rslvr_id, nm, ver_nbr)
values (termRslvrParmSpecId, termResolverId, 'Value', 1);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(cntxt_term_spec_prereq_id, idSuffixStart),'9999999') + 1) FROM krms_cntxt_vld_term_spec_t WHERE cntxt_term_spec_prereq_id LIKE idPrefixLike)) Into ctxValidTermSpecId from dual;
insert into krms_cntxt_vld_term_spec_t (cntxt_term_spec_prereq_id, cntxt_id, term_spec_id, prereq)
values (ctxValidTermSpecId, contextId, termSpecId, 'Y');

insert into krms_term_spec_ctgry_t (term_spec_id, ctgry_id)
values (termSpecId, ctgryId);

-- Create Sub Award Function --
Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(func_id,idSuffixStart),'9999999')) FROM krms_func_t WHERE func_id LIKE idPrefixLike) + 1) Into funcId from dual;
nmspCd := 'KC-SUBAWARD';
nmspAbbrev := 'Subaward';
boName := 'SubAward';
boParamDesc := 'Sub Award BO';
boParamTyp := 'org.kuali.kra.subaward.bo.SubAward';
ctgryId := 'RES-BOOT1029';
contextId := 'KC-SUBAWARD-CONTEXT';

insert into krms_func_t (func_id, nmspc_cd, nm, desc_txt, rtrn_typ, typ_id, actv, ver_nbr)
values (funcId, nmspCd, funcName, funcDesc, 'java.lang.Boolean', typeId, 'Y', 1);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(func_parm_id, idSuffixStart),'9999999') + 1) FROM krms_func_parm_t WHERE func_parm_id LIKE idPrefixLike)) Into func_parm_id from dual;
insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values (func_parm_id, boName, boParamDesc, boParamTyp, funcId, 1);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(func_parm_id, idSuffixStart),'9999999') + 1) FROM krms_func_parm_t WHERE func_parm_id LIKE idPrefixLike)) Into func_parm_id from dual;
insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values (func_parm_id, 'Custom Attribute Id', 'Custom Attribute Id', 'java.lang.String', funcId, 2);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(func_parm_id, idSuffixStart),'9999999') + 1) FROM krms_func_parm_t WHERE func_parm_id LIKE idPrefixLike)) Into func_parm_id from dual;
insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
values (func_parm_id, 'Value', 'Value', 'java.lang.String', funcId, 3);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(term_spec_id, idSuffixStart),'9999999') + 1) FROM krms_term_spec_t WHERE term_spec_id LIKE idPrefixLike)) Into termSpecId from dual;
insert into krms_term_spec_t (term_spec_id, nm, typ, actv, ver_nbr, desc_txt, nmspc_cd)
values (termSpecId, funcId, 'java.lang.Boolean', 'Y', 1, funcDesc, nmspCd);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(term_rslvr_id, idSuffixStart),'9999999') + 1) FROM krms_term_rslvr_t WHERE term_rslvr_id LIKE idPrefixLike)) Into termResolverId from dual;
insert into krms_term_rslvr_t (term_rslvr_id, nmspc_cd, nm, typ_id, output_term_spec_id, actv, ver_nbr)
values (termResolverId, nmspCd, CONCAT(nmspAbbrev, ' Contains Value Resolver'), 'KC1001', termSpecId, 'Y', 1);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(term_rslvr_parm_spec_id, idSuffixStart),'9999999') + 1) FROM krms_term_rslvr_parm_spec_t WHERE term_rslvr_parm_spec_id LIKE idPrefixLike)) Into termRslvrParmSpecId from dual;
insert into krms_term_rslvr_parm_spec_t (term_rslvr_parm_spec_id, term_rslvr_id, nm, ver_nbr)
values (termRslvrParmSpecId, termResolverId, 'Custom Attribute Id', 1);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(term_rslvr_parm_spec_id, idSuffixStart),'9999999') + 1) FROM krms_term_rslvr_parm_spec_t WHERE term_rslvr_parm_spec_id LIKE idPrefixLike)) Into termRslvrParmSpecId from dual;
insert into krms_term_rslvr_parm_spec_t (term_rslvr_parm_spec_id, term_rslvr_id, nm, ver_nbr)
values (termRslvrParmSpecId, termResolverId, 'Value', 1);

Select CONCAT(idPrefix, (SELECT MAX(To_Number(SUBSTR(cntxt_term_spec_prereq_id, idSuffixStart),'9999999') + 1) FROM krms_cntxt_vld_term_spec_t WHERE cntxt_term_spec_prereq_id LIKE idPrefixLike)) Into ctxValidTermSpecId from dual;
insert into krms_cntxt_vld_term_spec_t (cntxt_term_spec_prereq_id, cntxt_id, term_spec_id, prereq)
values (ctxValidTermSpecId, contextId, termSpecId, 'Y');

insert into krms_term_spec_ctgry_t (term_spec_id, ctgry_id)
values (termSpecId, ctgryId);

End;





