---
-- #%L
-- %%
-- Copyright (C) 2005 - 2022 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


ALTER TABLE NOTIFICATION_TYPE ADD (
  FROM_ADDRESS VARCHAR2(1000 BYTE),
  EMAIL_ONLY CHAR(1 BYTE) DEFAULT 'N' NOT NULL
);

CREATE TABLE AWARD_NOTIFICATION
(
      NOTIFICATION_ID NUMBER(20)
        , NOTIFICATION_TYPE_ID NUMBER(6) NOT NULL
        , DOCUMENT_NUMBER VARCHAR2(40) NOT NULL
        , OWNING_DOCUMENT_ID_FK NUMBER(12) NOT NULL
        , RECIPIENTS VARCHAR2(1000)
        , SUBJECT VARCHAR2(1000)
        , MESSAGE VARCHAR2(4000)
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , CREATE_TIMESTAMP DATE NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36) NOT NULL
);
ALTER TABLE AWARD_NOTIFICATION
    ADD CONSTRAINT AWARD_NOTIFICATIONP1
PRIMARY KEY (NOTIFICATION_ID);

ALTER TABLE AWARD_NOTIFICATION ADD CONSTRAINT FK1_AWARD_NOTIFICATION
  FOREIGN KEY (OWNING_DOCUMENT_ID_FK) REFERENCES AWARD (AWARD_ID);

ALTER TABLE AWARD_NOTIFICATION ADD CONSTRAINT FK2_AWARD_NOTIFICATION
  FOREIGN KEY (NOTIFICATION_TYPE_ID) REFERENCES NOTIFICATION_TYPE (NOTIFICATION_TYPE_ID);

CREATE TABLE PROPOSAL_NOTIFICATION
(
      NOTIFICATION_ID NUMBER(20)
        , NOTIFICATION_TYPE_ID NUMBER(6) NOT NULL
        , DOCUMENT_NUMBER VARCHAR2(40) NOT NULL
        , OWNING_DOCUMENT_ID_FK VARCHAR2(12) NOT NULL
        , RECIPIENTS VARCHAR2(1000)
        , SUBJECT VARCHAR2(1000)
        , MESSAGE VARCHAR2(4000)
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , CREATE_TIMESTAMP DATE NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36) NOT NULL
);
ALTER TABLE PROPOSAL_NOTIFICATION
    ADD CONSTRAINT PROPOSAL_NOTIFICATIONP1
PRIMARY KEY (NOTIFICATION_ID);

ALTER TABLE PROPOSAL_NOTIFICATION ADD CONSTRAINT FK1_PROPOSAL_NOTIFICATION
  FOREIGN KEY (OWNING_DOCUMENT_ID_FK) REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);

ALTER TABLE PROPOSAL_NOTIFICATION ADD CONSTRAINT FK2_PROPOSAL_NOTIFICATION
  FOREIGN KEY (NOTIFICATION_TYPE_ID) REFERENCES NOTIFICATION_TYPE (NOTIFICATION_TYPE_ID);
