---
-- #%L
-- %%
-- Copyright (C) 2005 - 2022 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---
DECLARE

	val number;

BEGIN

	SELECT count(*) INTO val
	   	FROM KRMS_TERM_SPEC_T WHERE NM = 'RES-BOOT10050' AND TERM_SPEC_ID = 'RES-BOOT2133' AND NMSPC_CD = 'KC-AWARD';

	IF val = 0 THEN

		insert into krms_func_t (func_id, nmspc_cd, nm, desc_txt, rtrn_typ, typ_id, actv, ver_nbr)
		values ('RES-BOOT10050', 'KC-AWARD', 'sponsorTypeRule', 'Check if Award has a Sponsor with the specified type', 'java.lang.String', 'KC10001', 'Y', 1);
		insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
		values ('RES-BOOT10093', 'award', 'Award BO', 'org.kuali.kra.award.home.Award', 'RES-BOOT10050', 1);
		insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
		values ('RES-BOOT10094', 'Sponsor Type', 'Sponsor Type', 'java.lang.String', 'RES-BOOT10050', 2);
		insert into krms_term_spec_t (term_spec_id, nm, typ, actv, ver_nbr, desc_txt, nmspc_cd)
		values ('RES-BOOT2133', 'RES-BOOT10050', 'java.lang.String', 'Y', 1, 'Check if Award has a Sponsor with the specified type', 'KC-AWARD');
		insert into krms_term_rslvr_t (term_rslvr_id, nmspc_cd, nm, typ_id, output_term_spec_id, actv, ver_nbr)
		values ('RES-BOOT2120', 'KC-AWARD', 'Award Sponsor Type Resolver', 'KC1001', 'RES-BOOT2133', 'Y', 1);
		insert into krms_term_rslvr_parm_spec_t (term_rslvr_parm_spec_id, term_rslvr_id, nm, ver_nbr)
		values ('RES-BOOT2113', 'RES-BOOT2120', 'Sponsor Type', 1);
		insert into krms_cntxt_vld_term_spec_t (cntxt_term_spec_prereq_id, cntxt_id, term_spec_id, prereq)
		values ('RES-BOOT1073', 'KC-AWARD-CONTEXT', 'RES-BOOT2133', 'Y');
		insert into krms_term_spec_ctgry_t (term_spec_id, ctgry_id)
		values ('RES-BOOT2133', 'KC1010');

	END IF;


	SELECT count(*) INTO val
	   	FROM KRMS_TERM_SPEC_T WHERE NM = 'RES-BOOT10051' AND TERM_SPEC_ID = 'RES-BOOT2134' AND NMSPC_CD = 'KC-AWARD';

	IF val = 0 THEN

		insert into krms_func_t (func_id, nmspc_cd, nm, desc_txt, rtrn_typ, typ_id, actv, ver_nbr)
		values ('RES-BOOT10051', 'KC-AWARD', 'monitoredSponsorRule', 'Check if Award has a Sponsor in the specified hierarchy', 'java.lang.String', 'KC10001', 'Y', 1);
		insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
		values ('RES-BOOT10095', 'award', 'Award BO', 'org.kuali.kra.award.home.Award', 'RES-BOOT10051', 1);
		insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
		values ('RES-BOOT10096', 'Monitored Sponsor Hierarchy', 'Monitored Sponsor Hierarchy', 'java.lang.String', 'RES-BOOT10051', 2);
		insert into krms_term_spec_t (term_spec_id, nm, typ, actv, ver_nbr, desc_txt, nmspc_cd)
		values ('RES-BOOT2134', 'RES-BOOT10051', 'java.lang.String', 'Y', 1, 'Check if Award has a Sponsor in the specified hierarchy', 'KC-AWARD');
		insert into krms_term_rslvr_t (term_rslvr_id, nmspc_cd, nm, typ_id, output_term_spec_id, actv, ver_nbr)
		values ('RES-BOOT2121', 'KC-AWARD', 'Award Monitored Sponsor Resolver', 'KC1001', 'RES-BOOT2134', 'Y', 1);
		insert into krms_term_rslvr_parm_spec_t (term_rslvr_parm_spec_id, term_rslvr_id, nm, ver_nbr)
		values ('RES-BOOT2114', 'RES-BOOT2121', 'Monitored Sponsor Hierarchy', 1);
		insert into krms_cntxt_vld_term_spec_t (cntxt_term_spec_prereq_id, cntxt_id, term_spec_id, prereq)
		values ('RES-BOOT1074', 'KC-AWARD-CONTEXT', 'RES-BOOT2134', 'Y');
		insert into krms_term_spec_ctgry_t (term_spec_id, ctgry_id)
		values ('RES-BOOT2134', 'KC1010');

	END IF;


	SELECT count(*) INTO val
	   	FROM KRMS_TERM_SPEC_T WHERE NM = 'RES-BOOT10052' AND TERM_SPEC_ID = 'RES-BOOT2135' AND NMSPC_CD = 'KC-AWARD';

	IF val = 0 THEN

		insert into krms_func_t (func_id, nmspc_cd, nm, desc_txt, rtrn_typ, typ_id, actv, ver_nbr)
		values ('RES-BOOT10052', 'KC-AWARD', 'checkCFDAEntered', 'Check if CFDA exists', 'java.lang.Boolean', 'KC10001', 'Y', 1);
		insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
		values ('RES-BOOT10097', 'award', 'Award BO', 'org.kuali.kra.award.home.Award', 'RES-BOOT10052', 1);
		insert into krms_term_spec_t (term_spec_id, nm, typ, actv, ver_nbr, desc_txt, nmspc_cd)
		values ('RES-BOOT2135', 'RES-BOOT10052', 'java.lang.String', 'Y', 1, 'Check if CFDA exists', 'KC-AWARD');
		insert into krms_term_t (term_id, term_spec_id, ver_nbr, desc_txt)
        values ('RES-BOOT10026', 'RES-BOOT2135', '1', 'Check if CFDA exists');
		insert into krms_term_rslvr_t (term_rslvr_id, nmspc_cd, nm, typ_id, output_term_spec_id, actv, ver_nbr)
		values ('RES-BOOT2122', 'KC-AWARD', 'CFDA exists Resolver', 'KC1001', 'RES-BOOT2135', 'Y', 1);
		insert into krms_cntxt_vld_term_spec_t (cntxt_term_spec_prereq_id, cntxt_id, term_spec_id, prereq)
		values ('RES-BOOT1075', 'KC-AWARD-CONTEXT', 'RES-BOOT2135', 'Y');
		insert into krms_term_spec_ctgry_t (term_spec_id, ctgry_id)
		values ('RES-BOOT2135', 'KC1010');

	END IF;


	SELECT count(*) INTO val
	   	FROM KRMS_TERM_SPEC_T WHERE NM = 'RES-BOOT10053' AND TERM_SPEC_ID = 'RES-BOOT2136' AND NMSPC_CD = 'KC-AWARD';

	IF val = 0 THEN

		insert into krms_func_t (func_id, nmspc_cd, nm, desc_txt, rtrn_typ, typ_id, actv, ver_nbr)
		values ('RES-BOOT10053', 'KC-AWARD', 'checkAnticipatedEqualsObligatedCostRule', 'Check Anticipated costs equal Obligated costs', 'java.lang.Boolean', 'KC10001', 'Y', 1);
		insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
		values ('RES-BOOT10098', 'award', 'Award BO', 'org.kuali.kra.award.home.Award', 'RES-BOOT10053', 1);
		insert into krms_term_spec_t (term_spec_id, nm, typ, actv, ver_nbr, desc_txt, nmspc_cd)
		values ('RES-BOOT2136', 'RES-BOOT10053', 'java.lang.String', 'Y', 1, 'Check Anticipated costs equal Obligated costs', 'KC-AWARD');
		insert into krms_term_t (term_id, term_spec_id, ver_nbr, desc_txt)
        values ('RES-BOOT10027', 'RES-BOOT2135', '1', 'Check Anticipated costs equal Obligated costs');
		insert into krms_term_rslvr_t (term_rslvr_id, nmspc_cd, nm, typ_id, output_term_spec_id, actv, ver_nbr)
		values ('RES-BOOT2123', 'KC-AWARD', 'Anticipated costs equal Obligated costs Resolver', 'KC1001', 'RES-BOOT2136', 'Y', 1);
		insert into krms_cntxt_vld_term_spec_t (cntxt_term_spec_prereq_id, cntxt_id, term_spec_id, prereq)
		values ('RES-BOOT1076', 'KC-AWARD-CONTEXT', 'RES-BOOT2136', 'Y');
		insert into krms_term_spec_ctgry_t (term_spec_id, ctgry_id)
		values ('RES-BOOT2136', 'KC1010');

	END IF;

	SELECT count(*) INTO val
	   	FROM KRMS_TERM_SPEC_T WHERE NM = 'RES-BOOT10054' AND TERM_SPEC_ID = 'RES-BOOT2137' AND NMSPC_CD = 'KC-AWARD';

	IF val = 0 THEN

		insert into krms_func_t (func_id, nmspc_cd, nm, desc_txt, rtrn_typ, typ_id, actv, ver_nbr)
		values ('RES-BOOT10054', 'KC-AWARD', 'sponsorTermIdRule', 'Check if Award has a Sponsor Term in the specified list', 'java.lang.Boolean', 'KC10001', 'Y', 1);
		insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
		values ('RES-BOOT10099', 'award', 'Award BO', 'org.kuali.kra.award.home.Award', 'RES-BOOT10054', 1);
		insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
		values ('RES-BOOT10100', 'Award Sponsor Term Ids', 'Award Sponsor Term Ids', 'java.lang.String', 'RES-BOOT10054', 2);
		insert into krms_term_spec_t (term_spec_id, nm, typ, actv, ver_nbr, desc_txt, nmspc_cd)
		values ('RES-BOOT2137', 'RES-BOOT10054', 'java.lang.String', 'Y', 1, 'Check if Award has a Sponsor Term in the specified list', 'KC-AWARD');
		insert into krms_term_rslvr_t (term_rslvr_id, nmspc_cd, nm, typ_id, output_term_spec_id, actv, ver_nbr)
		values ('RES-BOOT2124', 'KC-AWARD', 'Award Sponsor Term Ids Resolver', 'KC1001', 'RES-BOOT2137', 'Y', 1);
		insert into krms_term_rslvr_parm_spec_t (term_rslvr_parm_spec_id, term_rslvr_id, nm, ver_nbr)
		values ('RES-BOOT2115', 'RES-BOOT2124', 'Award Sponsor Term Ids', 1);
		insert into krms_cntxt_vld_term_spec_t (cntxt_term_spec_prereq_id, cntxt_id, term_spec_id, prereq)
		values ('RES-BOOT1077', 'KC-AWARD-CONTEXT', 'RES-BOOT2137', 'Y');
		insert into krms_term_spec_ctgry_t (term_spec_id, ctgry_id)
		values ('RES-BOOT2137', 'KC1010');

	END IF;

	SELECT count(*) INTO val
	   	FROM KRMS_TERM_SPEC_T WHERE NM = 'RES-BOOT10055' AND TERM_SPEC_ID = 'RES-BOOT2138' AND NMSPC_CD = 'KC-AWARD';

	IF val = 0 THEN

		insert into krms_func_t (func_id, nmspc_cd, nm, desc_txt, rtrn_typ, typ_id, actv, ver_nbr)
		values ('RES-BOOT10055', 'KC-AWARD', 'fundingProposalRule', 'Count Award Funding Proposals', 'java.lang.Integer', 'KC10001', 'Y', 1);
		insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
		values ('RES-BOOT10101', 'award', 'Award BO', 'org.kuali.kra.award.home.Award', 'RES-BOOT10055', 1);
		insert into krms_term_spec_t (term_spec_id, nm, typ, actv, ver_nbr, desc_txt, nmspc_cd)
		values ('RES-BOOT2138', 'RES-BOOT10055', 'java.lang.String', 'Y', 1, 'Count Award Funding Proposals', 'KC-AWARD');
		insert into krms_term_t (term_id, term_spec_id, ver_nbr, desc_txt)
        values ('RES-BOOT10028', 'RES-BOOT2138', '1', 'Count Award Funding Proposals');
		insert into krms_term_rslvr_t (term_rslvr_id, nmspc_cd, nm, typ_id, output_term_spec_id, actv, ver_nbr)
		values ('RES-BOOT2125', 'KC-AWARD', 'Count Award Funding Proposals Resolver', 'KC1001', 'RES-BOOT2138', 'Y', 1);
		insert into krms_cntxt_vld_term_spec_t (cntxt_term_spec_prereq_id, cntxt_id, term_spec_id, prereq)
		values ('RES-BOOT1078', 'KC-AWARD-CONTEXT', 'RES-BOOT2138', 'Y');
		insert into krms_term_spec_ctgry_t (term_spec_id, ctgry_id)
		values ('RES-BOOT2138', 'KC1010');

	END IF;

	SELECT count(*) INTO val
	   	FROM KRMS_TERM_SPEC_T WHERE NM = 'RES-BOOT10056' AND TERM_SPEC_ID = 'RES-BOOT2139' AND NMSPC_CD = 'KC-AWARD';

	IF val = 0 THEN

		insert into krms_func_t (func_id, nmspc_cd, nm, desc_txt, rtrn_typ, typ_id, actv, ver_nbr)
		values ('RES-BOOT10056', 'KC-AWARD', 'obligationStartEndExistsRule', 'Check Obligated Start and End exists', 'java.lang.Boolean', 'KC10001', 'Y', 1);
		insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
		values ('RES-BOOT10102', 'award', 'Award BO', 'org.kuali.kra.award.home.Award', 'RES-BOOT10056', 1);
		insert into krms_term_spec_t (term_spec_id, nm, typ, actv, ver_nbr, desc_txt, nmspc_cd)
		values ('RES-BOOT2139', 'RES-BOOT10056', 'java.lang.String', 'Y', 1, 'Check Obligated Start and End exists', 'KC-AWARD');
		insert into krms_term_t (term_id, term_spec_id, ver_nbr, desc_txt)
        values ('RES-BOOT10029', 'RES-BOOT2139', '1', 'Check Obligated Start and End exists');
		insert into krms_term_rslvr_t (term_rslvr_id, nmspc_cd, nm, typ_id, output_term_spec_id, actv, ver_nbr)
		values ('RES-BOOT2126', 'KC-AWARD', 'Check Obligated Start and End exists Resolver', 'KC1001', 'RES-BOOT2139', 'Y', 1);
		insert into krms_cntxt_vld_term_spec_t (cntxt_term_spec_prereq_id, cntxt_id, term_spec_id, prereq)
		values ('RES-BOOT1079', 'KC-AWARD-CONTEXT', 'RES-BOOT2139', 'Y');
		insert into krms_term_spec_ctgry_t (term_spec_id, ctgry_id)
		values ('RES-BOOT2139', 'KC1010');

	END IF;

	SELECT count(*) INTO val
	   	FROM KRMS_TERM_SPEC_T WHERE NM = 'RES-BOOT10057' AND TERM_SPEC_ID = 'RES-BOOT2140' AND NMSPC_CD = 'KC-AWARD';

	IF val = 0 THEN

		insert into krms_func_t (func_id, nmspc_cd, nm, desc_txt, rtrn_typ, typ_id, actv, ver_nbr)
		values ('RES-BOOT10057', 'KC-AWARD', 'unitContactTypeRule', 'Check if Award has a Unit Contact Type in the specified list', 'java.lang.Boolean', 'KC10001', 'Y', 1);
		insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
		values ('RES-BOOT10103', 'award', 'Award BO', 'org.kuali.kra.award.home.Award', 'RES-BOOT10057', 1);
		insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
		values ('RES-BOOT10104', 'Award Unit Contact Types', 'Award Unit Contact Types', 'java.lang.String', 'RES-BOOT10057', 2);
		insert into krms_term_spec_t (term_spec_id, nm, typ, actv, ver_nbr, desc_txt, nmspc_cd)
		values ('RES-BOOT2140', 'RES-BOOT10057', 'java.lang.String', 'Y', 1, 'Check if Award has a Unit Contact Type in the specified list', 'KC-AWARD');
		insert into krms_term_rslvr_t (term_rslvr_id, nmspc_cd, nm, typ_id, output_term_spec_id, actv, ver_nbr)
		values ('RES-BOOT2127', 'KC-AWARD', 'Award Unit Contact Types Resolver', 'KC1001', 'RES-BOOT2140', 'Y', 1);
		insert into krms_term_rslvr_parm_spec_t (term_rslvr_parm_spec_id, term_rslvr_id, nm, ver_nbr)
		values ('RES-BOOT2116', 'RES-BOOT2127', 'Award Unit Contact Types3', 1);
		insert into krms_cntxt_vld_term_spec_t (cntxt_term_spec_prereq_id, cntxt_id, term_spec_id, prereq)
		values ('RES-BOOT1080', 'KC-AWARD-CONTEXT', 'RES-BOOT2140', 'Y');
		insert into krms_term_spec_ctgry_t (term_spec_id, ctgry_id)
		values ('RES-BOOT2140', 'KC1010');

	END IF;

	SELECT count(*) INTO val
	   	FROM KRMS_TERM_SPEC_T WHERE NM = 'RES-BOOT10058' AND TERM_SPEC_ID = 'RES-BOOT2141' AND NMSPC_CD = 'KC-AWARD';

	IF val = 0 THEN

		insert into krms_func_t (func_id, nmspc_cd, nm, desc_txt, rtrn_typ, typ_id, actv, ver_nbr)
		values ('RES-BOOT10058', 'KC-AWARD', 'attachmentTypeRule', 'Check specified attachment type', 'java.lang.Boolean', 'KC10001', 'Y', 1);
		insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
		values ('RES-BOOT10105', 'award', 'Award BO', 'org.kuali.kra.award.home.Award', 'RES-BOOT10058', 1);
		insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
		values ('RES-BOOT10106', 'Award Attachment Type', 'Award Attachment Type', 'java.lang.String', 'RES-BOOT10058', 2);
		insert into krms_term_spec_t (term_spec_id, nm, typ, actv, ver_nbr, desc_txt, nmspc_cd)
		values ('RES-BOOT2141', 'RES-BOOT10058', 'java.lang.String', 'Y', 1, 'Check specified attachment type', 'KC-AWARD');
		insert into krms_term_rslvr_t (term_rslvr_id, nmspc_cd, nm, typ_id, output_term_spec_id, actv, ver_nbr)
		values ('RES-BOOT2128', 'KC-AWARD', 'Award Attachment Type Resolver', 'KC1001', 'RES-BOOT2141', 'Y', 1);
		insert into krms_term_rslvr_parm_spec_t (term_rslvr_parm_spec_id, term_rslvr_id, nm, ver_nbr)
		values ('RES-BOOT2117', 'RES-BOOT2128', 'Award Attachment Type', 1);
		insert into krms_cntxt_vld_term_spec_t (cntxt_term_spec_prereq_id, cntxt_id, term_spec_id, prereq)
		values ('RES-BOOT1081', 'KC-AWARD-CONTEXT', 'RES-BOOT2141', 'Y');
		insert into krms_term_spec_ctgry_t (term_spec_id, ctgry_id)
		values ('RES-BOOT2141', 'KC1010');

	END IF;

	SELECT count(*) INTO val
	   	FROM KRMS_TERM_SPEC_T WHERE NM = 'RES-BOOT10059' AND TERM_SPEC_ID = 'RES-BOOT2142' AND NMSPC_CD = 'KC-AWARD';

	IF val = 0 THEN

		insert into krms_func_t (func_id, nmspc_cd, nm, desc_txt, rtrn_typ, typ_id, actv, ver_nbr)
		values ('RES-BOOT10059', 'KC-AWARD', 'hierarchyLevel', 'Check hierarchy level, parent=0, child=1', 'java.lang.Integer', 'KC10001', 'Y', 1);
		insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
		values ('RES-BOOT10107', 'award', 'Award BO', 'org.kuali.kra.award.home.Award', 'RES-BOOT10059', 1);
		insert into krms_term_spec_t (term_spec_id, nm, typ, actv, ver_nbr, desc_txt, nmspc_cd)
		values ('RES-BOOT2142', 'RES-BOOT10059', 'java.lang.String', 'Y', 1, 'Check award hierarchy level', 'KC-AWARD');
		insert into krms_term_t (term_id, term_spec_id, ver_nbr, desc_txt)
        values ('RES-BOOT10030', 'RES-BOOT2142', '1', 'Check award hierarchy level');
		insert into krms_term_rslvr_t (term_rslvr_id, nmspc_cd, nm, typ_id, output_term_spec_id, actv, ver_nbr)
		values ('RES-BOOT2129', 'KC-AWARD', 'award hierarchy level Resolver', 'KC1001', 'RES-BOOT2142', 'Y', 1);
		insert into krms_cntxt_vld_term_spec_t (cntxt_term_spec_prereq_id, cntxt_id, term_spec_id, prereq)
		values ('RES-BOOT1082', 'KC-AWARD-CONTEXT', 'RES-BOOT2142', 'Y');
		insert into krms_term_spec_ctgry_t (term_spec_id, ctgry_id)
		values ('RES-BOOT2142', 'KC1010');

	END IF;

	SELECT count(*) INTO val
	   	FROM KRMS_TERM_SPEC_T WHERE NM = 'RES-BOOT10060' AND TERM_SPEC_ID = 'RES-BOOT2143' AND NMSPC_CD = 'KC-AWARD';

	IF val = 0 THEN

		insert into krms_func_t (func_id, nmspc_cd, nm, desc_txt, rtrn_typ, typ_id, actv, ver_nbr)
		values ('RES-BOOT10060', 'KC-AWARD', 'uniqueSponsorAwardIdByHierarchy', 'Checks if Sponsor Award Id is used outside this Award hierarchy', 'java.lang.Boolean', 'KC10001', 'Y', 1);
		insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
		values ('RES-BOOT10108', 'award', 'Award BO', 'org.kuali.kra.award.home.Award', 'RES-BOOT10060', 1);
		insert into krms_term_spec_t (term_spec_id, nm, typ, actv, ver_nbr, desc_txt, nmspc_cd)
		values ('RES-BOOT2143', 'RES-BOOT10060', 'java.lang.String', 'Y', 1, 'Checks if Sponsor Award Id is used outside this Award hierarchy', 'KC-AWARD');
		insert into krms_term_t (term_id, term_spec_id, ver_nbr, desc_txt)
        values ('RES-BOOT10031', 'RES-BOOT2143', '1', 'Checks if Sponsor Award Id is used outside this Award hierarchy');
		insert into krms_term_rslvr_t (term_rslvr_id, nmspc_cd, nm, typ_id, output_term_spec_id, actv, ver_nbr)
		values ('RES-BOOT2130', 'KC-AWARD', 'Sponsor Award Id unique Resolver', 'KC1001', 'RES-BOOT2143', 'Y', 1);
		insert into krms_cntxt_vld_term_spec_t (cntxt_term_spec_prereq_id, cntxt_id, term_spec_id, prereq)
		values ('RES-BOOT1083', 'KC-AWARD-CONTEXT', 'RES-BOOT2143', 'Y');
		insert into krms_term_spec_ctgry_t (term_spec_id, ctgry_id)
		values ('RES-BOOT2143', 'KC1010');

	END IF;

	SELECT count(*) INTO val
	   	FROM KRMS_TERM_SPEC_T WHERE NM = 'RES-BOOT10061' AND TERM_SPEC_ID = 'RES-BOOT2144' AND NMSPC_CD = 'KC-AWARD';

	IF val = 0 THEN

		insert into krms_func_t (func_id, nmspc_cd, nm, desc_txt, rtrn_typ, typ_id, actv, ver_nbr)
		values ('RES-BOOT10061', 'KC-AWARD', 'primeSponsorTypeRule', 'Check if Award has a Prime Sponsor with the specified type', 'java.lang.String', 'KC10001', 'Y', 1);
		insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
		values ('RES-BOOT10109', 'award', 'Award BO', 'org.kuali.kra.award.home.Award', 'RES-BOOT10061', 1);
		insert into krms_func_parm_t (func_parm_id, nm, desc_txt, typ, func_id, seq_no)
		values ('RES-BOOT10110', 'Prime Sponsor Type', 'Prime Sponsor Type', 'java.lang.String', 'RES-BOOT10061', 2);
		insert into krms_term_spec_t (term_spec_id, nm, typ, actv, ver_nbr, desc_txt, nmspc_cd)
		values ('RES-BOOT2144', 'RES-BOOT10061', 'java.lang.String', 'Y', 1, 'Check if Award has a Prime Sponsor with the specified type', 'KC-AWARD');
		insert into krms_term_rslvr_t (term_rslvr_id, nmspc_cd, nm, typ_id, output_term_spec_id, actv, ver_nbr)
		values ('RES-BOOT2131', 'KC-AWARD', 'Award Prime Sponsor Type Resolver', 'KC1001', 'RES-BOOT2144', 'Y', 1);
		insert into krms_term_rslvr_parm_spec_t (term_rslvr_parm_spec_id, term_rslvr_id, nm, ver_nbr)
		values ('RES-BOOT10061', 'RES-BOOT2131', 'Prime Sponsor Type', 1);
		insert into krms_cntxt_vld_term_spec_t (cntxt_term_spec_prereq_id, cntxt_id, term_spec_id, prereq)
		values ('RES-BOOT1084', 'KC-AWARD-CONTEXT', 'RES-BOOT2144', 'Y');
		insert into krms_term_spec_ctgry_t (term_spec_id, ctgry_id)
		values ('RES-BOOT2144', 'KC1010');

	END IF;

END;
