---
-- #%L
-- %%
-- Copyright (C) 2005 - 2022 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---
DECLARE
  CURSOR RECORD_CUR IS
    SELECT BUDGET_ID, BUDGET_PERIOD_NUMBER, BUDGET_PERIOD FROM BUDGET_PERIODS;
BEGIN
  FOR RECORD in RECORD_CUR
  LOOP

    UPDATE BUDGET_DETAILS
    SET BUDGET_ID = RECORD.BUDGET_ID, BUDGET_PERIOD = RECORD.BUDGET_PERIOD
    WHERE BUDGET_PERIOD_NUMBER = RECORD.BUDGET_PERIOD_NUMBER;

    UPDATE BUDGET_MODULAR
    SET BUDGET_ID = RECORD.BUDGET_ID, BUDGET_PERIOD = RECORD.BUDGET_PERIOD
    WHERE BUDGET_PERIOD_NUMBER = RECORD.BUDGET_PERIOD_NUMBER;

    UPDATE BUDGET_MODULAR_IDC
    SET BUDGET_ID = RECORD.BUDGET_ID, BUDGET_PERIOD = RECORD.BUDGET_PERIOD
    WHERE BUDGET_PERIOD_NUMBER = RECORD.BUDGET_PERIOD_NUMBER;

  END LOOP;
END;
/


DECLARE
  -- budget details was fixed above so we can query it for correct data
  CURSOR RECORD_CUR IS
    SELECT BUDGET_ID, BUDGET_PERIOD_NUMBER, BUDGET_PERIOD, BUDGET_DETAILS_ID FROM BUDGET_DETAILS;
BEGIN
  FOR RECORD in RECORD_CUR
  LOOP

    UPDATE BUDGET_DETAILS_CAL_AMTS
    SET BUDGET_ID = RECORD.BUDGET_ID, BUDGET_PERIOD = RECORD.BUDGET_PERIOD, BUDGET_PERIOD_NUMBER = RECORD.BUDGET_PERIOD_NUMBER
    WHERE BUDGET_DETAILS_ID = RECORD.BUDGET_DETAILS_ID;

    UPDATE BUDGET_PERSONNEL_DETAILS
    SET BUDGET_ID = RECORD.BUDGET_ID, BUDGET_PERIOD = RECORD.BUDGET_PERIOD, BUDGET_PERIOD_NUMBER = RECORD.BUDGET_PERIOD_NUMBER
    WHERE BUDGET_DETAILS_ID = RECORD.BUDGET_DETAILS_ID;

  END LOOP;
END;
/

DECLARE
  -- budget personnel details was fixed above so we can query it for correct data
  CURSOR RECORD_CUR IS
    SELECT BUDGET_ID, BUDGET_PERIOD_NUMBER, BUDGET_PERIOD, BUDGET_PERSONNEL_DETAILS_ID FROM BUDGET_PERSONNEL_DETAILS;
BEGIN
  FOR RECORD in RECORD_CUR
  LOOP

    UPDATE BUDGET_PERSONNEL_CAL_AMTS
    SET BUDGET_ID = RECORD.BUDGET_ID, BUDGET_PERIOD = RECORD.BUDGET_PERIOD, BUDGET_PERIOD_NUMBER = RECORD.BUDGET_PERIOD_NUMBER
    WHERE BUDGET_PERSONNEL_DETAILS_ID = RECORD.BUDGET_PERSONNEL_DETAILS_ID;

    UPDATE BUDGET_PER_DET_RATE_AND_BASE
    SET BUDGET_ID = RECORD.BUDGET_ID, BUDGET_PERIOD = RECORD.BUDGET_PERIOD, BUDGET_PERIOD_NUMBER = RECORD.BUDGET_PERIOD_NUMBER
    WHERE BUDGET_PERSONNEL_DETAILS_ID = RECORD.BUDGET_PERSONNEL_DETAILS_ID;

  END LOOP;
END;
/
