---
-- #%L
-- %%
-- Copyright (C) 2005 - 2022 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


CREATE SEQUENCE SEQ_S2S_FORM_CONFIG_ID INCREMENT BY 1 START WITH 1 NOCACHE;

CREATE TABLE S2S_FORM_CONFIG (
    S2S_FORM_CONFIG_ID VARCHAR2(25) NOT NULL,
    FORM_NAME VARCHAR2(50) NOT NULL,
    ACTIVE_FLAG CHAR(1) NOT NULL,
    INACTIVE_MESSAGE VARCHAR2(200),
    UPDATE_TIMESTAMP DATE NOT NULL,
    UPDATE_USER VARCHAR2(60) NOT NULL,
    VER_NBR NUMBER(8,0) DEFAULT 1 NOT NULL,
    OBJ_ID VARCHAR2(36) NOT NULL);

ALTER TABLE S2S_FORM_CONFIG
ADD CONSTRAINT PK_S2S_FORM_CONFIG
PRIMARY KEY (S2S_FORM_CONFIG_ID);

ALTER TABLE S2S_FORM_CONFIG
ADD CONSTRAINT UQ_S2S_FORM_CONFIG
UNIQUE (FORM_NAME);

ALTER TABLE S2S_FORM_CONFIG
    ADD CONSTRAINT UQ_S2S_FORM_CONFIG2
UNIQUE (OBJ_ID);

