---
-- #%L
-- %%
-- Copyright (C) 2005 - 2022 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'COI_REVIEW_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE COI_REVIEW_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE COI_REVIEW_TYPE (
	COI_REVIEW_TYPE_CODE VARCHAR2(3),
	DESCRIPTION VARCHAR2(200) NOT NULL,
	UPDATE_TIMESTAMP DATE NOT NULL,
	UPDATE_USER VARCHAR2(60) NOT NULL,
	VER_NBR NUMBER(8) DEFAULT 1 NOT NULL,
	OBJ_ID VARCHAR2(36) NOT NULL);

ALTER TABLE COI_REVIEW_TYPE
    ADD CONSTRAINT PK_COI_REVIEW_TYPE
		PRIMARY KEY (COI_REVIEW_TYPE_CODE);
