---
-- #%L
-- %%
-- Copyright (C) 2005 - 2022 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


INSERT INTO NOTIFICATION_TYPE (NOTIFICATION_TYPE_ID, MODULE_CODE, ACTION_CODE, DESCRIPTION, SUBJECT, MESSAGE, PROMPT_USER, SEND_NOTIFICATION, UPDATE_USER, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID)
	VALUES (SEQ_NOTIFICATION_TYPE_ID.NEXTVAL, 3, '101','Proposal sumbitted to sponsor after routing.',
	'{LEAD_UNIT} - Proposal {PROPOSAL_NUMBER} is submitted',
	'The Proposal {PROPOSAL_NUMBER} has been submitted to sponsor.<br/>The institute proposal number is {INSTITUTIONAL_PROPOSAL_NUMBER}.',  'Y', 'Y', 'admin', SYSDATE, 1, SYS_GUID());

INSERT INTO NOTIFICATION_TYPE (NOTIFICATION_TYPE_ID, MODULE_CODE, ACTION_CODE, DESCRIPTION, SUBJECT, MESSAGE, PROMPT_USER, SEND_NOTIFICATION, UPDATE_USER, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID)
	VALUES (SEQ_NOTIFICATION_TYPE_ID.NEXTVAL, 3, '102','Notification sent when a narrative is is added to a proposal that is not in pending status.',
	'{LEAD_UNIT} - Notification : Narrative added to proposal : {PROPOSAL_NUMBER}',
	'A new attachment is uploaded for Proposal : {PROPOSAL_NUMBER}, Module No. {NARRATIVE_MODULE_NUM} have been changed.<br/>Narrative Type: {NARRATIVE_TYPE}<br/>Module Description: {NARRATIVE_MODULE_DESCRIPTION}',  'Y', 'Y', 'admin', SYSDATE, 1, SYS_GUID());

INSERT INTO NOTIFICATION_TYPE (NOTIFICATION_TYPE_ID, MODULE_CODE, ACTION_CODE, DESCRIPTION, SUBJECT, MESSAGE, PROMPT_USER, SEND_NOTIFICATION, UPDATE_USER, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID)
	VALUES (SEQ_NOTIFICATION_TYPE_ID.NEXTVAL, 3, '103','When an admin changes the data in proposal after it is approved.',
	'{LEAD_UNIT} - Notification',
	'{OVERRIDE_FIELD_NAME} for proposal {PROPOSAL_NUMBER} has been changed to {OVERRIDE_FIELD_VALUE}',  'Y', 'Y', 'admin', SYSDATE, 1, SYS_GUID());

INSERT INTO NOTIFICATION_TYPE_RECIPIENT (NOTIFICATION_TYPE_RECIPIENT_ID, NOTIFICATION_TYPE_ID, ROLE_NAME, UPDATE_USER, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID)
	VALUES (SEQ_NOTIFICATION_TYPE_ID.NEXTVAL, (select NOTIFICATION_TYPE_ID from notification_type where MODULE_CODE = 3 and ACTION_CODE = '101'), 'KC-PD:Aggregator', 'admin', SYSDATE, 1, SYS_GUID());

INSERT INTO NOTIFICATION_TYPE_RECIPIENT (NOTIFICATION_TYPE_RECIPIENT_ID, NOTIFICATION_TYPE_ID, ROLE_NAME, UPDATE_USER, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID)
	VALUES (SEQ_NOTIFICATION_TYPE_ID.NEXTVAL, (select NOTIFICATION_TYPE_ID from notification_type where MODULE_CODE = 3 and ACTION_CODE = '102'), 'KC-WKFLW:All Past Approvers', 'admin', SYSDATE, 1, SYS_GUID());

INSERT INTO NOTIFICATION_TYPE_RECIPIENT (NOTIFICATION_TYPE_RECIPIENT_ID, NOTIFICATION_TYPE_ID, ROLE_NAME, UPDATE_USER, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID)
	VALUES (SEQ_NOTIFICATION_TYPE_ID.NEXTVAL, (select NOTIFICATION_TYPE_ID from notification_type where MODULE_CODE = 3 and ACTION_CODE = '103'), 'KC-PD:Aggregator', 'admin', SYSDATE, 1, SYS_GUID());


insert into NOTIFICATION_MODULE_ROLE (NOTIFICATION_MODULE_ROLE_ID, MODULE_CODE, ROLE_NAME, OBJ_ID, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER)
	VALUES (SEQ_NTFCTN_MODULE_ROLE_ID.NEXTVAL, 3, 'KC-PD:Aggregator', sys_guid(), 1, sysdate, 'admin');

insert into NOTIFICATION_MDL_ROLE_QLFR (NOTIFICATION_MDL_ROLE_QLFR_ID, NOTIFICATION_MODULE_ROLE_ID, QUALIFIER, OBJ_ID, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER)
	VALUES (SEQ_NTFCTN_MDL_ROLE_QLFR_ID.NEXTVAL, SEQ_NTFCTN_MODULE_ROLE_ID.CURRVAL ,
			'proposal', sys_guid(), 1, sysdate, 'admin');

insert into NOTIFICATION_MODULE_ROLE (NOTIFICATION_MODULE_ROLE_ID, MODULE_CODE, ROLE_NAME, OBJ_ID, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER)
	VALUES (SEQ_NTFCTN_MODULE_ROLE_ID.NEXTVAL, 3, 'KC-PD:Investigators', sys_guid(), 1, sysdate, 'admin');

insert into NOTIFICATION_MDL_ROLE_QLFR (NOTIFICATION_MDL_ROLE_QLFR_ID, NOTIFICATION_MODULE_ROLE_ID, QUALIFIER, OBJ_ID, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER)
	VALUES (SEQ_NTFCTN_MDL_ROLE_QLFR_ID.NEXTVAL, (select NOTIFICATION_MODULE_ROLE_ID from NOTIFICATION_MODULE_ROLE where MODULE_CODE = 3 and ROLE_NAME = 'KC-PD:Investigators'),
			'proposal', sys_guid(), 1, sysdate, 'admin');

insert into NOTIFICATION_MODULE_ROLE (NOTIFICATION_MODULE_ROLE_ID, MODULE_CODE, ROLE_NAME, OBJ_ID, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER)
	VALUES (SEQ_NTFCTN_MODULE_ROLE_ID.NEXTVAL, 3, 'KC-WKFLW:Unit Administrator', sys_guid(), 1, sysdate, 'admin');

insert into NOTIFICATION_MDL_ROLE_QLFR (NOTIFICATION_MDL_ROLE_QLFR_ID, NOTIFICATION_MODULE_ROLE_ID, QUALIFIER, OBJ_ID, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER)
	VALUES (SEQ_NTFCTN_MDL_ROLE_QLFR_ID.NEXTVAL, (select NOTIFICATION_MODULE_ROLE_ID from NOTIFICATION_MODULE_ROLE where MODULE_CODE = 3 and ROLE_NAME = 'KC-WKFLW:Unit Administrator'),
			'unitNumber', sys_guid(), 1, sysdate, 'admin');

insert into NOTIFICATION_MODULE_ROLE (NOTIFICATION_MODULE_ROLE_ID, MODULE_CODE, ROLE_NAME, OBJ_ID, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER)
	VALUES (SEQ_NTFCTN_MODULE_ROLE_ID.NEXTVAL, 3, 'KC-PD:All Unit Administrators', sys_guid(), 1, sysdate, 'admin');

insert into NOTIFICATION_MDL_ROLE_QLFR (NOTIFICATION_MDL_ROLE_QLFR_ID, NOTIFICATION_MODULE_ROLE_ID, QUALIFIER, OBJ_ID, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER)
	VALUES (SEQ_NTFCTN_MDL_ROLE_QLFR_ID.NEXTVAL, (select NOTIFICATION_MODULE_ROLE_ID from NOTIFICATION_MODULE_ROLE where MODULE_CODE = 3 and ROLE_NAME = 'KC-PD:All Unit Administrators'),
			'proposal', sys_guid(), 1, sysdate, 'admin');

insert into NOTIFICATION_MODULE_ROLE (NOTIFICATION_MODULE_ROLE_ID, MODULE_CODE, ROLE_NAME, OBJ_ID, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER)
	VALUES (SEQ_NTFCTN_MODULE_ROLE_ID.NEXTVAL, 3, 'KC-WKFLW:All Past Approvers', sys_guid(), 1, sysdate, 'admin');

insert into NOTIFICATION_MDL_ROLE_QLFR (NOTIFICATION_MDL_ROLE_QLFR_ID, NOTIFICATION_MODULE_ROLE_ID, QUALIFIER, OBJ_ID, VER_NBR, UPDATE_TIMESTAMP, UPDATE_USER)
	VALUES (SEQ_NTFCTN_MDL_ROLE_QLFR_ID.NEXTVAL, (select NOTIFICATION_MODULE_ROLE_ID from NOTIFICATION_MODULE_ROLE where MODULE_CODE = 3 and ROLE_NAME = 'KC-WKFLW:All Past Approvers'),
			'documentNumber', sys_guid(), 1, sysdate, 'admin');

