/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class BidirectionalOwnerRegistry {
    private final Map<String, Collection<String>> manyToManyOwnerAssignment = new HashMap<String, Collection<String>>();
    private final Map<String, Collection<String>> manyToOneOwnerAssignment = new HashMap<String, Collection<String>>();

    private BidirectionalOwnerRegistry() {
    }

    public static BidirectionalOwnerRegistry getInstance() {
        return BidirectionalOwnerRegistryHolder.INSTANCE;
    }

    public boolean isOwnerThisClassManyToMany(String thisClass, String itemClass) {
        Collection<String> ownedByThisClass = this.manyToManyOwnerAssignment.get(thisClass);
        return ownedByThisClass != null && ownedByThisClass.contains(itemClass);
    }

    public boolean isOwnerItemClassManyToMany(String thisClass, String itemClass) {
        Collection<String> ownedByItemClass = this.manyToManyOwnerAssignment.get(itemClass);
        return ownedByItemClass != null && ownedByItemClass.contains(thisClass);
    }

    public void assignThisClassAsOwnerManyToMany(String thisClass, String itemClass) {
        Collection<String> ownedByThisClass = this.manyToManyOwnerAssignment.get(thisClass);
        if (ownedByThisClass == null) {
            ownedByThisClass = new ArrayList<String>();
        }
        ownedByThisClass.add(itemClass);
        this.manyToManyOwnerAssignment.put(thisClass, ownedByThisClass);
    }

    public boolean isOwnerThisClassManyToOne(String thisClass, String itemClass) {
        Collection<String> ownedByThisClass = this.manyToOneOwnerAssignment.get(thisClass);
        return ownedByThisClass != null && ownedByThisClass.contains(itemClass);
    }

    public boolean isOwnerItemClassManyToOne(String thisClass, String itemClass) {
        Collection<String> ownedByItemClass = this.manyToOneOwnerAssignment.get(itemClass);
        return ownedByItemClass != null && ownedByItemClass.contains(thisClass);
    }

    public void assignItemClassAsOwnerManyToOne(String thisClass, String itemClass) {
        Collection<String> ownedByItemClass = this.manyToOneOwnerAssignment.get(itemClass);
        if (ownedByItemClass == null) {
            ownedByItemClass = new ArrayList<String>();
        }
        ownedByItemClass.add(thisClass);
        this.manyToOneOwnerAssignment.put(itemClass, ownedByItemClass);
    }

    private static class BidirectionalOwnerRegistryHolder {
        static final BidirectionalOwnerRegistry INSTANCE = new BidirectionalOwnerRegistry();

        private BidirectionalOwnerRegistryHolder() {
        }
    }
}

