/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver;

import japa.parser.ast.CompilationUnit;
import japa.parser.ast.ImportDeclaration;
import japa.parser.ast.Node;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.FieldDeclaration;
import japa.parser.ast.body.MethodDeclaration;
import japa.parser.ast.body.Parameter;
import japa.parser.ast.body.TypeDeclaration;
import japa.parser.ast.body.VariableDeclarator;
import japa.parser.ast.body.VariableDeclaratorId;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.AssignExpr;
import japa.parser.ast.expr.BinaryExpr;
import japa.parser.ast.expr.BooleanLiteralExpr;
import japa.parser.ast.expr.CastExpr;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.expr.FieldAccessExpr;
import japa.parser.ast.expr.IntegerLiteralExpr;
import japa.parser.ast.expr.MarkerAnnotationExpr;
import japa.parser.ast.expr.MethodCallExpr;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.expr.NullLiteralExpr;
import japa.parser.ast.expr.ObjectCreationExpr;
import japa.parser.ast.expr.QualifiedNameExpr;
import japa.parser.ast.expr.SingleMemberAnnotationExpr;
import japa.parser.ast.expr.StringLiteralExpr;
import japa.parser.ast.expr.ThisExpr;
import japa.parser.ast.expr.VariableDeclarationExpr;
import japa.parser.ast.stmt.BlockStmt;
import japa.parser.ast.stmt.ExpressionStmt;
import japa.parser.ast.stmt.IfStmt;
import japa.parser.ast.stmt.ReturnStmt;
import japa.parser.ast.stmt.Statement;
import japa.parser.ast.type.ClassOrInterfaceType;
import japa.parser.ast.type.PrimitiveType;
import japa.parser.ast.type.Type;
import japa.parser.ast.type.VoidType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.kuali.rice.devtools.jpa.eclipselink.conv.ojb.OjbUtil;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.ParserUtil;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.AnnotationResolver;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.Level;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.NodeData;
import org.kuali.rice.devtools.jpa.eclipselink.conv.parser.helper.resolver.ResolverUtil;

public class IdClassResolver
implements AnnotationResolver {
    private static final Log LOG = LogFactory.getLog(IdClassResolver.class);
    public static final String PACKAGE = "javax.persistence";
    public static final String SIMPLE_NAME = "IdClass";
    private final Collection<DescriptorRepository> descriptorRepositories;

    public IdClassResolver(Collection<DescriptorRepository> descriptorRepositories) {
        this.descriptorRepositories = descriptorRepositories;
    }

    @Override
    public String getFullyQualifiedName() {
        return "javax.persistence.IdClass";
    }

    @Override
    public Level getLevel() {
        return Level.CLASS;
    }

    @Override
    public NodeData resolve(Node node, String mappedClass) {
        if (!(node instanceof ClassOrInterfaceDeclaration)) {
            throw new IllegalArgumentException("this annotation belongs only on ClassOrInterfaceDeclaration");
        }
        TypeDeclaration dclr = (TypeDeclaration)node;
        if (!(dclr.getParentNode() instanceof CompilationUnit)) {
            return null;
        }
        String name = dclr.getName();
        Collection<FieldDescriptor> primaryKeyDescriptors = this.getPrimaryKeyDescriptors(mappedClass);
        if (primaryKeyDescriptors != null && primaryKeyDescriptors.size() > 1 && this.nodeContainsPkFields(dclr, primaryKeyDescriptors)) {
            NodeAndImports<ClassOrInterfaceDeclaration> primaryKeyClass = this.createPrimaryKeyClass(name, primaryKeyDescriptors);
            String pkClassName = ((ClassOrInterfaceDeclaration)primaryKeyClass.node).getName();
            return new NodeData((AnnotationExpr)new SingleMemberAnnotationExpr(new NameExpr(SIMPLE_NAME), (Expression)new NameExpr(name + "." + pkClassName + ".class")), new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr(PACKAGE), SIMPLE_NAME), false, false), primaryKeyClass.imprts, (ClassOrInterfaceDeclaration)primaryKeyClass.node);
        }
        return null;
    }

    private boolean nodeContainsPkFields(TypeDeclaration dclr, Collection<FieldDescriptor> pks) {
        for (FieldDescriptor pk : pks) {
            boolean contains = false;
            for (FieldDeclaration field : ParserUtil.getFieldMembers(dclr.getMembers())) {
                if (!((VariableDeclarator)field.getVariables().get(0)).getId().getName().equals(pk.getAttributeName())) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            return false;
        }
        return true;
    }

    private Collection<FieldDescriptor> getPrimaryKeyDescriptors(String clazz) {
        ArrayList<FieldDescriptor> pks = new ArrayList<FieldDescriptor>();
        ClassDescriptor cd = OjbUtil.findClassDescriptor(clazz, this.descriptorRepositories);
        if (cd != null) {
            boolean i = false;
            FieldDescriptor[] fds = cd.getFieldDescriptions();
            if (fds != null) {
                for (FieldDescriptor fd : fds) {
                    if (!fd.isPrimaryKey()) continue;
                    pks.add(fd);
                }
            }
        }
        return pks;
    }

    private NodeAndImports<ClassOrInterfaceDeclaration> createPrimaryKeyClass(String parentName, Collection<FieldDescriptor> primaryKeyDescriptors) {
        String attrName;
        String simpleTypeName;
        String newName = parentName + "Id";
        ArrayList<ImportDeclaration> requiredImports = new ArrayList<ImportDeclaration>();
        ClassOrInterfaceDeclaration dclr = new ClassOrInterfaceDeclaration(25, false, newName);
        dclr.setInterface(false);
        ArrayList<ClassOrInterfaceType> implmnts = new ArrayList<ClassOrInterfaceType>();
        implmnts.add(new ClassOrInterfaceType("Serializable"));
        ClassOrInterfaceType comparableImplmnts = new ClassOrInterfaceType("Comparable");
        comparableImplmnts.setTypeArgs(Collections.singletonList(new ClassOrInterfaceType(newName)));
        implmnts.add(comparableImplmnts);
        dclr.setImplements(implmnts);
        requiredImports.add(new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr("java.io"), "Serializable"), false, false));
        ArrayList<Object> members = new ArrayList<Object>();
        for (FieldDescriptor fd : primaryKeyDescriptors) {
            simpleTypeName = ResolverUtil.getType(fd.getClassDescriptor().getClassNameOfObject(), fd.getAttributeName()).getSimpleName();
            attrName = fd.getAttributeName();
            members.add(new FieldDeclaration(2, (Type)new ClassOrInterfaceType(simpleTypeName), new VariableDeclarator(new VariableDeclaratorId(attrName))));
        }
        for (FieldDescriptor fd : primaryKeyDescriptors) {
            simpleTypeName = ResolverUtil.getType(fd.getClassDescriptor().getClassNameOfObject(), fd.getAttributeName()).getSimpleName();
            attrName = fd.getAttributeName();
            MethodDeclaration getter = new MethodDeclaration(1, (Type)new ClassOrInterfaceType(simpleTypeName), "get" + attrName.substring(0, 1).toUpperCase() + attrName.substring(1));
            getter.setBody(new BlockStmt(Collections.singletonList(new ReturnStmt((Expression)new FieldAccessExpr((Expression)new ThisExpr(), attrName)))));
            members.add(getter);
            MethodDeclaration setter = new MethodDeclaration(1, (Type)new VoidType(), "set" + attrName.substring(0, 1).toUpperCase() + attrName.substring(1), Collections.singletonList(new Parameter((Type)new ClassOrInterfaceType(simpleTypeName), new VariableDeclaratorId(attrName))));
            setter.setBody(new BlockStmt(Collections.singletonList(new ExpressionStmt((Expression)new AssignExpr((Expression)new FieldAccessExpr((Expression)new ThisExpr(), attrName), (Expression)new NameExpr(attrName), AssignExpr.Operator.assign)))));
            members.add(setter);
        }
        NodeAndImports<MethodDeclaration> toString = this.createPrimaryKeyToString(primaryKeyDescriptors);
        NodeAndImports<MethodDeclaration> equals = this.createPrimaryKeyEquals(primaryKeyDescriptors, newName);
        NodeAndImports<MethodDeclaration> hashCode = this.createPrimaryKeyHashCode(primaryKeyDescriptors);
        NodeAndImports<MethodDeclaration> compareTo = this.createPrimaryKeyCompareTo(primaryKeyDescriptors, newName);
        members.add(toString.node);
        members.add(equals.node);
        members.add(hashCode.node);
        members.add(compareTo.node);
        if (toString.imprts != null) {
            requiredImports.addAll(toString.imprts);
        }
        if (equals.imprts != null) {
            requiredImports.addAll(equals.imprts);
        }
        if (hashCode.imprts != null) {
            requiredImports.addAll(hashCode.imprts);
        }
        if (compareTo.imprts != null) {
            requiredImports.addAll(compareTo.imprts);
        }
        dclr.setMembers(members);
        return new NodeAndImports(this, (Node)dclr, requiredImports);
    }

    private NodeAndImports<MethodDeclaration> createPrimaryKeyToString(Collection<FieldDescriptor> primaryKeyDescriptors) {
        MethodDeclaration toString = new MethodDeclaration(1, (Type)new ClassOrInterfaceType("String"), "toString");
        toString.setAnnotations(Collections.singletonList(new MarkerAnnotationExpr(new NameExpr("Override"))));
        ObjectCreationExpr toStringBuilderExpr = new ObjectCreationExpr(null, new ClassOrInterfaceType("ToStringBuilder"), Collections.singletonList(new ThisExpr()));
        for (FieldDescriptor f : primaryKeyDescriptors) {
            ArrayList<Object> args = new ArrayList<Object>();
            args.add(new StringLiteralExpr(f.getAttributeName()));
            args.add(new FieldAccessExpr((Expression)new ThisExpr(), f.getAttributeName()));
            toStringBuilderExpr = new MethodCallExpr((Expression)toStringBuilderExpr, "append", args);
        }
        toStringBuilderExpr = new MethodCallExpr((Expression)toStringBuilderExpr, "toString");
        BlockStmt toStringBody = new BlockStmt(Collections.singletonList(new ReturnStmt((Expression)toStringBuilderExpr)));
        toString.setBody(toStringBody);
        return new NodeAndImports(this, (Node)toString, Collections.singleton(new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr("org.apache.commons.lang.builder"), "ToStringBuilder"), false, false)));
    }

    private NodeAndImports<MethodDeclaration> createPrimaryKeyEquals(Collection<FieldDescriptor> primaryKeyDescriptors, String enclosingClassName) {
        MethodDeclaration equals = new MethodDeclaration(1, (Type)new PrimitiveType(PrimitiveType.Primitive.Boolean), "equals", Collections.singletonList(new Parameter((Type)new ClassOrInterfaceType("Object"), new VariableDeclaratorId("other"))));
        equals.setAnnotations(Collections.singletonList(new MarkerAnnotationExpr(new NameExpr("Override"))));
        IfStmt ifEqualNullStmt = new IfStmt((Expression)new BinaryExpr((Expression)new NameExpr("other"), (Expression)new NullLiteralExpr(), BinaryExpr.Operator.equals), (Statement)new ReturnStmt((Expression)new BooleanLiteralExpr(false)), null);
        IfStmt ifEqualThisStmt = new IfStmt((Expression)new BinaryExpr((Expression)new NameExpr("other"), (Expression)new ThisExpr(), BinaryExpr.Operator.equals), (Statement)new ReturnStmt((Expression)new BooleanLiteralExpr(true)), null);
        IfStmt ifEqualClassStmt = new IfStmt((Expression)new BinaryExpr((Expression)new MethodCallExpr((Expression)new NameExpr("other"), "getClass"), (Expression)new MethodCallExpr((Expression)new ThisExpr(), "getClass"), BinaryExpr.Operator.notEquals), (Statement)new ReturnStmt((Expression)new BooleanLiteralExpr(false)), null);
        ExpressionStmt rhsStmt = new ExpressionStmt((Expression)new VariableDeclarationExpr(16, (Type)new ClassOrInterfaceType(enclosingClassName), Collections.singletonList(new VariableDeclarator(new VariableDeclaratorId("rhs"), (Expression)new CastExpr((Type)new ClassOrInterfaceType(enclosingClassName), (Expression)new NameExpr("other"))))));
        ObjectCreationExpr equalsBuilderExpr = new ObjectCreationExpr(null, new ClassOrInterfaceType("EqualsBuilder"), Collections.emptyList());
        for (FieldDescriptor f : primaryKeyDescriptors) {
            ArrayList<FieldAccessExpr> args = new ArrayList<FieldAccessExpr>();
            args.add(new FieldAccessExpr((Expression)new ThisExpr(), f.getAttributeName()));
            args.add(new FieldAccessExpr((Expression)new NameExpr("rhs"), f.getAttributeName()));
            equalsBuilderExpr = new MethodCallExpr((Expression)equalsBuilderExpr, "append", args);
        }
        equalsBuilderExpr = new MethodCallExpr((Expression)equalsBuilderExpr, "isEquals");
        ArrayList<Object> statements = new ArrayList<Object>();
        statements.add(ifEqualNullStmt);
        statements.add(ifEqualThisStmt);
        statements.add(ifEqualClassStmt);
        statements.add(rhsStmt);
        statements.add(new ReturnStmt((Expression)equalsBuilderExpr));
        BlockStmt equalsBody = new BlockStmt(statements);
        equals.setBody(equalsBody);
        return new NodeAndImports(this, (Node)equals, Collections.singleton(new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr("org.apache.commons.lang.builder"), "EqualsBuilder"), false, false)));
    }

    private NodeAndImports<MethodDeclaration> createPrimaryKeyHashCode(Collection<FieldDescriptor> primaryKeyDescriptors) {
        MethodDeclaration hashCode = new MethodDeclaration(1, (Type)new PrimitiveType(PrimitiveType.Primitive.Int), "hashCode");
        hashCode.setAnnotations(Collections.singletonList(new MarkerAnnotationExpr(new NameExpr("Override"))));
        ArrayList<IntegerLiteralExpr> ctorArgs = new ArrayList<IntegerLiteralExpr>();
        ctorArgs.add(new IntegerLiteralExpr("17"));
        ctorArgs.add(new IntegerLiteralExpr("37"));
        ObjectCreationExpr hashCodeExpr = new ObjectCreationExpr(null, new ClassOrInterfaceType("HashCodeBuilder"), ctorArgs);
        for (FieldDescriptor f : primaryKeyDescriptors) {
            ArrayList<FieldAccessExpr> args = new ArrayList<FieldAccessExpr>();
            args.add(new FieldAccessExpr((Expression)new ThisExpr(), f.getAttributeName()));
            hashCodeExpr = new MethodCallExpr((Expression)hashCodeExpr, "append", args);
        }
        hashCodeExpr = new MethodCallExpr((Expression)hashCodeExpr, "toHashCode");
        BlockStmt equalsBody = new BlockStmt(Collections.singletonList(new ReturnStmt((Expression)hashCodeExpr)));
        hashCode.setBody(equalsBody);
        return new NodeAndImports(this, (Node)hashCode, Collections.singleton(new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr("org.apache.commons.lang.builder"), "HashCodeBuilder"), false, false)));
    }

    private NodeAndImports<MethodDeclaration> createPrimaryKeyCompareTo(Collection<FieldDescriptor> primaryKeyDescriptors, String enclosingClassName) {
        MethodDeclaration compareTo = new MethodDeclaration(1, (Type)new PrimitiveType(PrimitiveType.Primitive.Int), "compareTo", Collections.singletonList(new Parameter((Type)new ClassOrInterfaceType(enclosingClassName), new VariableDeclaratorId("other"))));
        compareTo.setAnnotations(Collections.singletonList(new MarkerAnnotationExpr(new NameExpr("Override"))));
        ObjectCreationExpr compareToBuilderExpr = new ObjectCreationExpr(null, new ClassOrInterfaceType("CompareToBuilder"), Collections.emptyList());
        for (FieldDescriptor f : primaryKeyDescriptors) {
            ArrayList<FieldAccessExpr> args = new ArrayList<FieldAccessExpr>();
            args.add(new FieldAccessExpr((Expression)new ThisExpr(), f.getAttributeName()));
            args.add(new FieldAccessExpr((Expression)new NameExpr("other"), f.getAttributeName()));
            compareToBuilderExpr = new MethodCallExpr((Expression)compareToBuilderExpr, "append", args);
        }
        compareToBuilderExpr = new MethodCallExpr((Expression)compareToBuilderExpr, "toComparison");
        ArrayList<ReturnStmt> statements = new ArrayList<ReturnStmt>();
        statements.add(new ReturnStmt((Expression)compareToBuilderExpr));
        BlockStmt equalsBody = new BlockStmt(statements);
        compareTo.setBody(equalsBody);
        return new NodeAndImports(this, (Node)compareTo, Collections.singleton(new ImportDeclaration((NameExpr)new QualifiedNameExpr(new NameExpr("org.apache.commons.lang.builder"), "CompareToBuilder"), false, false)));
    }

    private static class NodeAndImports<T extends Node> {
        T node;
        Collection<ImportDeclaration> imprts;
        final /* synthetic */ IdClassResolver this$0;

        NodeAndImports(T node, Collection<ImportDeclaration> imprts) {
            this.this$0 = var1_1;
            this.node = node;
            this.imprts = imprts;
        }
    }
}

