/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kcb.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.kuali.rice.kcb.bo.Message;
import org.kuali.rice.kcb.bo.MessageDelivery;
import org.kuali.rice.kcb.bo.MessageDeliveryStatus;
import org.kuali.rice.kcb.service.MessageDeliveryService;
import org.kuali.rice.kcb.service.impl.BusinessObjectServiceImpl;

public class MessageDeliveryServiceImpl
extends BusinessObjectServiceImpl
implements MessageDeliveryService {
    private static final Logger LOG = Logger.getLogger(MessageDeliveryServiceImpl.class);
    private int maxProcessAttempts;

    public void setMaxProcessAttempts(int maxProcessAttempts) {
        this.maxProcessAttempts = maxProcessAttempts;
    }

    @Override
    public void saveMessageDelivery(MessageDelivery delivery) {
        this.dao.save((Object)delivery);
    }

    @Override
    public void deleteMessageDelivery(MessageDelivery messageDelivery) {
        this.dao.delete((Object)messageDelivery);
    }

    @Override
    public Collection<MessageDelivery> getAllMessageDeliveries() {
        return this.dao.findAll(MessageDelivery.class);
    }

    @Override
    public MessageDelivery getMessageDelivery(Long id) {
        HashMap<String, Long> fields = new HashMap<String, Long>(1);
        fields.put("id", id);
        return (MessageDelivery)this.dao.findByPrimaryKey(MessageDelivery.class, fields);
    }

    @Override
    public MessageDelivery getMessageDeliveryByDelivererSystemId(Long id) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("delivererSystemId", (Object)id);
        Collection results = this.dao.findMatching(MessageDelivery.class, criteria);
        if (results == null || results.size() == 0) {
            return null;
        }
        if (results.size() > 1) {
            throw new RuntimeException("More than one message delivery found with the following delivery system id: " + id);
        }
        return (MessageDelivery)results.iterator().next();
    }

    @Override
    public Collection<MessageDelivery> getMessageDeliveries(Message message) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("message", (Object)message.getId());
        return this.dao.findMatching(MessageDelivery.class, criteria);
    }

    @Override
    public Collection<MessageDelivery> lockAndTakeMessageDeliveries(MessageDeliveryStatus[] statuses) {
        return this.lockAndTakeMessageDeliveries(null, statuses);
    }

    @Override
    public Collection<MessageDelivery> lockAndTakeMessageDeliveries(Long messageId, MessageDeliveryStatus[] statuses) {
        LOG.debug((Object)("========>> ENTERING LockAndTakeMessageDeliveries: " + Thread.currentThread()));
        Criteria criteria = new Criteria();
        criteria.addIsNull("lockedDate");
        if (messageId != null) {
            criteria.addEqualTo("message", (Object)messageId);
        }
        criteria.addLessThan((Object)"processCount", (Object)this.maxProcessAttempts);
        ArrayList<String> statusCollection = new ArrayList<String>(statuses.length);
        for (MessageDeliveryStatus status : statuses) {
            statusCollection.add(status.name());
        }
        criteria.addIn("deliveryStatus", statusCollection);
        Collection messageDeliveries = this.dao.findMatching(MessageDelivery.class, criteria, true, 0L);
        for (MessageDelivery delivery : messageDeliveries) {
            LOG.debug((Object)("Took: " + delivery));
            delivery.setLockedDate(new Timestamp(System.currentTimeMillis()));
            this.dao.save((Object)delivery);
        }
        LOG.debug((Object)("<<=======  LEAVING LockAndTakeMessageDeliveries: " + Thread.currentThread()));
        return messageDeliveries;
    }
}

