/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.bo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.kuali.rice.ken.api.notification.NotificationChannel;
import org.kuali.rice.ken.api.notification.NotificationChannelContract;
import org.kuali.rice.ken.api.notification.NotificationChannelReviewer;
import org.kuali.rice.ken.api.notification.NotificationListRecipient;
import org.kuali.rice.ken.api.notification.NotificationProducer;
import org.kuali.rice.ken.api.notification.UserChannelSubscription;
import org.kuali.rice.ken.bo.NotificationChannelReviewerBo;
import org.kuali.rice.ken.bo.NotificationProducerBo;
import org.kuali.rice.ken.bo.NotificationRecipientListBo;
import org.kuali.rice.ken.bo.UserChannelSubscriptionBo;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;

@Entity
@Table(name="KREN_CHNL_T")
public class NotificationChannelBo
extends PersistableBusinessObjectBase
implements NotificationChannelContract {
    @Id
    @GeneratedValue(generator="KREN_CHNL_S")
    @GenericGenerator(name="KREN_CHNL_S", strategy="org.hibernate.id.enhanced.SequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KREN_CHNL_S"), @Parameter(name="value_column", value="id")})
    @Column(name="CHNL_ID")
    private Long id;
    @Column(name="NM", nullable=false)
    private String name;
    @Column(name="DESC_TXT", nullable=false)
    private String description;
    @Column(name="SUBSCRB_IND", nullable=false)
    private boolean subscribable;
    @OneToMany(cascade={CascadeType.REFRESH, CascadeType.DETACH, CascadeType.REMOVE, CascadeType.MERGE, CascadeType.PERSIST}, targetEntity=NotificationRecipientListBo.class, mappedBy="channel")
    @OrderBy(value="id ASC")
    private List<NotificationRecipientListBo> recipientLists;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH, CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST})
    @JoinTable(name="KREN_CHNL_PRODCR_T", joinColumns={@JoinColumn(name="CHNL_ID")}, inverseJoinColumns={@JoinColumn(name="PRODCR_ID")})
    @OrderBy(value="id ASC")
    private List<NotificationProducerBo> producers;
    @OneToMany(cascade={CascadeType.REFRESH, CascadeType.DETACH, CascadeType.REMOVE, CascadeType.MERGE, CascadeType.PERSIST}, targetEntity=NotificationChannelReviewerBo.class, mappedBy="channel")
    @OrderBy(value="id ASC")
    private List<NotificationChannelReviewerBo> reviewers = new ArrayList<NotificationChannelReviewerBo>();
    @OneToMany(cascade={CascadeType.REFRESH, CascadeType.DETACH, CascadeType.REMOVE, CascadeType.MERGE, CascadeType.PERSIST}, targetEntity=UserChannelSubscriptionBo.class, mappedBy="channel")
    @OrderBy(value="id ASC")
    private List<UserChannelSubscriptionBo> subscriptions = new ArrayList<UserChannelSubscriptionBo>();

    public NotificationChannelBo() {
        this.recipientLists = new ArrayList<NotificationRecipientListBo>();
        this.producers = new ArrayList<NotificationProducerBo>();
    }

    public List<NotificationRecipientListBo> getRecipientLists() {
        return this.recipientLists;
    }

    public void setRecipientLists(List<NotificationRecipientListBo> recipientLists) {
        this.recipientLists = recipientLists;
    }

    public void addRecipientList(NotificationRecipientListBo recipientList) {
        this.recipientLists.add(recipientList);
    }

    public void removeRecipientList(NotificationRecipientListBo recipientList) {
        this.recipientLists.remove((Object)recipientList);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isSubscribable() {
        return this.subscribable;
    }

    public void setSubscribable(boolean subscribable) {
        this.subscribable = subscribable;
    }

    public List<NotificationProducerBo> getProducers() {
        return this.producers;
    }

    public void setProducers(List<NotificationProducerBo> producers) {
        this.producers = producers;
    }

    public List<NotificationChannelReviewerBo> getReviewers() {
        return this.reviewers;
    }

    public void setReviewers(List<NotificationChannelReviewerBo> reviewers) {
        this.reviewers = reviewers;
    }

    public List<UserChannelSubscriptionBo> getSubscriptions() {
        return this.subscriptions;
    }

    public void setSubscriptions(List<UserChannelSubscriptionBo> subscriptions) {
        this.subscriptions = subscriptions;
    }

    public boolean equals(Object obj) {
        NotificationChannelBo channelToCompare = (NotificationChannelBo)((Object)obj);
        return this.getId().equals(channelToCompare.getId());
    }

    public static NotificationChannel to(NotificationChannelBo bo) {
        if (bo == null) {
            return null;
        }
        return NotificationChannel.Builder.create((NotificationChannelContract)bo).build();
    }

    public static NotificationChannelBo from(NotificationChannel im) {
        if (im == null) {
            return null;
        }
        NotificationChannelBo bo = new NotificationChannelBo();
        bo.setId(im.getId());
        bo.setVersionNumber(im.getVersionNumber());
        bo.setObjectId(im.getObjectId());
        bo.setName(im.getName());
        bo.setDescription(im.getDescription());
        bo.setSubscribable(im.isSubscribable());
        ArrayList<NotificationRecipientListBo> tempRecipientLists = new ArrayList<NotificationRecipientListBo>();
        if (CollectionUtils.isNotEmpty((Collection)im.getRecipientLists())) {
            for (Object listRecipient : im.getRecipientLists()) {
                tempRecipientLists.add(NotificationRecipientListBo.from((NotificationListRecipient)listRecipient));
            }
            bo.setRecipientLists(tempRecipientLists);
        }
        ArrayList<NotificationProducerBo> tempProducers = new ArrayList<NotificationProducerBo>();
        if (CollectionUtils.isNotEmpty((Collection)im.getProducers())) {
            for (Object producer : im.getProducers()) {
                tempProducers.add(NotificationProducerBo.from((NotificationProducer)producer));
            }
            bo.setProducers(tempProducers);
        }
        ArrayList<NotificationChannelReviewerBo> tempReviewers = new ArrayList<NotificationChannelReviewerBo>();
        if (CollectionUtils.isNotEmpty((Collection)im.getReviewers())) {
            for (NotificationChannelReviewer reviewer : im.getReviewers()) {
                tempReviewers.add(NotificationChannelReviewerBo.from(reviewer));
            }
            bo.setReviewers(tempReviewers);
        }
        ArrayList<UserChannelSubscriptionBo> tempSubscriptions = new ArrayList<UserChannelSubscriptionBo>();
        if (CollectionUtils.isNotEmpty((Collection)im.getSubscriptions())) {
            for (UserChannelSubscription subscription : im.getSubscriptions()) {
                tempSubscriptions.add(UserChannelSubscriptionBo.from(subscription));
            }
            bo.setSubscriptions(tempSubscriptions);
        }
        return bo;
    }
}

