/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.service.impl;

import java.util.Collection;
import java.util.HashMap;
import org.kuali.rice.core.framework.persistence.dao.GenericDao;
import org.kuali.rice.ken.bo.NotificationBo;
import org.kuali.rice.ken.bo.NotificationContentTypeBo;
import org.kuali.rice.ken.service.NotificationContentTypeService;

public class NotificationContentTypeServiceImpl
implements NotificationContentTypeService {
    private GenericDao businessObjectDao;

    public NotificationContentTypeServiceImpl(GenericDao businessObjectDao) {
        this.businessObjectDao = businessObjectDao;
    }

    @Override
    public NotificationContentTypeBo getNotificationContentType(String name) {
        HashMap<String, Object> c = new HashMap<String, Object>();
        c.put("name", name);
        c.put("current", new Boolean(true));
        Collection coll = this.businessObjectDao.findMatching(NotificationContentTypeBo.class, c);
        if (coll.size() == 0) {
            return null;
        }
        return (NotificationContentTypeBo)((Object)coll.iterator().next());
    }

    protected int findHighestContentTypeVersion(String name) {
        HashMap<String, String> fields = new HashMap<String, String>(2);
        fields.put("name", name);
        Collection types = this.businessObjectDao.findMatchingOrderBy(NotificationContentTypeBo.class, fields, "version", false);
        if (types.size() > 0) {
            return ((NotificationContentTypeBo)((Object)types.iterator().next())).getVersion();
        }
        return -1;
    }

    @Override
    public void saveNotificationContentType(NotificationContentTypeBo contentType) {
        NotificationContentTypeBo next;
        NotificationContentTypeBo previous = this.getNotificationContentType(contentType.getName());
        if (previous != null) {
            previous.setCurrent(false);
            this.businessObjectDao.save((Object)previous);
        }
        int lastVersion = this.findHighestContentTypeVersion(contentType.getName());
        if (contentType.getId() == null) {
            next = contentType;
        } else {
            next = new NotificationContentTypeBo();
            next.setName(contentType.getName());
            next.setDescription(contentType.getDescription());
            next.setNamespace(contentType.getNamespace());
            next.setXsd(contentType.getXsd());
            next.setXsl(contentType.getXsl());
        }
        next.setVersion(lastVersion + 1);
        next.setCurrent(true);
        this.businessObjectDao.save((Object)next);
        if (previous != null) {
            Collection<NotificationBo> ns = this.getNotificationsOfContentType(previous);
            for (NotificationBo n : ns) {
                n.setContentType(next);
                this.businessObjectDao.save((Object)n);
            }
        }
    }

    protected Collection<NotificationBo> getNotificationsOfContentType(NotificationContentTypeBo ct) {
        HashMap<String, Long> fields = new HashMap<String, Long>(1);
        fields.put("contentType", ct.getId());
        return this.businessObjectDao.findMatching(NotificationBo.class, fields);
    }

    @Override
    public Collection<NotificationContentTypeBo> getAllCurrentContentTypes() {
        HashMap<String, Boolean> c = new HashMap<String, Boolean>();
        c.put("current", new Boolean(true));
        return this.businessObjectDao.findMatching(NotificationContentTypeBo.class, c);
    }

    @Override
    public Collection<NotificationContentTypeBo> getAllContentTypes() {
        return this.businessObjectDao.findAll(NotificationContentTypeBo.class);
    }
}

