/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actionitem.dao.impl;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionitem.OutboxItemActionListExtension;
import org.kuali.rice.kew.actionitem.dao.ActionItemDAO;
import org.kuali.rice.kew.actionrequest.KimGroupRecipient;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.util.WebFriendlyRecipient;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.springmodules.orm.ojb.support.PersistenceBrokerDaoSupport;

public class ActionItemDAOOjbImpl
extends PersistenceBrokerDaoSupport
implements ActionItemDAO {
    private static final Logger LOG = Logger.getLogger(ActionItemDAOOjbImpl.class);

    @Override
    public ActionItem findByActionItemId(String actionItemId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("id", (Object)actionItemId);
        return (ActionItem)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)new QueryByCriteria(ActionItem.class, crit));
    }

    public void deleteActionItems(Long actionRequestId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("actionRequestId", (Object)actionRequestId);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)new QueryByCriteria(ActionItem.class, crit));
    }

    @Override
    public void deleteActionItem(ActionItem actionItem) {
        this.getPersistenceBrokerTemplate().delete((Object)actionItem);
    }

    @Override
    public void deleteByDocumentIdWorkflowUserId(String documentId, String workflowUserId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        crit.addEqualTo("principalId", (Object)workflowUserId);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)new QueryByCriteria(ActionItem.class, crit));
    }

    @Override
    public void deleteByDocumentId(String documentId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)new QueryByCriteria(ActionItem.class, crit));
    }

    @Override
    public Collection<ActionItem> findByWorkflowUserDocumentId(String workflowId, String documentId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("principalId", (Object)workflowId);
        crit.addEqualTo("documentId", (Object)documentId);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(ActionItem.class, crit));
    }

    @Override
    public Collection<ActionItem> findByDocumentId(String documentId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(ActionItem.class, crit));
    }

    @Override
    public Collection<ActionItem> findByActionRequestId(String actionRequestId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("actionRequestId", (Object)actionRequestId);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(ActionItem.class, crit));
    }

    @Override
    public Collection<ActionItem> findByDocumentTypeName(String documentTypeName) {
        return this.getItemsByDocumentType(ActionItem.class, documentTypeName);
    }

    @Override
    public Collection<OutboxItemActionListExtension> getOutboxItemsByDocumentType(String documentTypeName) {
        return this.getItemsByDocumentType(OutboxItemActionListExtension.class, documentTypeName);
    }

    private <T extends ActionItem> Collection<T> getItemsByDocumentType(Class<T> objectClass, String documentTypeName) {
        Criteria crit = new Criteria();
        crit.addEqualTo("docName", (Object)documentTypeName);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(objectClass, crit));
    }

    @Override
    public void saveActionItem(ActionItem actionItem) {
        if (actionItem.getDateAssigned() == null) {
            actionItem.setDateAssigned(new Timestamp(new Date().getTime()));
        }
        this.getPersistenceBrokerTemplate().store((Object)actionItem);
    }

    @Override
    public Collection<Recipient> findSecondaryDelegators(String principalId) {
        Criteria notNullWorkflowCriteria = new Criteria();
        notNullWorkflowCriteria.addNotNull("delegatorPrincipalId");
        Criteria notNullWorkgroupCriteria = new Criteria();
        notNullWorkgroupCriteria.addNotNull("delegatorGroupId");
        Criteria orCriteria = new Criteria();
        orCriteria.addOrCriteria(notNullWorkflowCriteria);
        orCriteria.addOrCriteria(notNullWorkgroupCriteria);
        Criteria criteria = new Criteria();
        criteria.addEqualTo("principalId", (Object)principalId);
        criteria.addEqualTo("delegationType", (Object)DelegationType.SECONDARY.getCode());
        criteria.addAndCriteria(orCriteria);
        ReportQueryByCriteria query = QueryFactory.newReportQuery(ActionItem.class, (Criteria)criteria);
        query.setAttributes(new String[]{"delegatorPrincipalId", "delegatorGroupId"});
        HashMap<String, Recipient> delegators = new HashMap<String, Recipient>();
        Iterator iterator = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        while (iterator.hasNext()) {
            String workgroupId;
            Object[] ids = (Object[])iterator.next();
            if (ids[0] != null && !delegators.containsKey((String)ids[0])) {
                WebFriendlyRecipient rec = new WebFriendlyRecipient(KimApiServiceLocator.getPersonService().getPerson((String)ids[0]));
                delegators.put((String)ids[0], rec);
                continue;
            }
            if (ids[1] == null || delegators.containsKey(workgroupId = ids[1].toString())) continue;
            delegators.put(workgroupId, new KimGroupRecipient(KimApiServiceLocator.getGroupService().getGroup(workgroupId)));
        }
        return delegators.values();
    }

    @Override
    public Collection<Recipient> findPrimaryDelegationRecipients(String principalId) {
        List workgroupIds = KimApiServiceLocator.getGroupService().getGroupIdsByPrincipalId(principalId);
        Criteria orCriteria = new Criteria();
        Criteria delegatorPrincipalIdCriteria = new Criteria();
        delegatorPrincipalIdCriteria.addEqualTo("delegatorPrincipalId", (Object)principalId);
        if (CollectionUtils.isNotEmpty((Collection)workgroupIds)) {
            Criteria delegatorWorkgroupCriteria = new Criteria();
            delegatorWorkgroupCriteria.addIn("delegatorGroupId", (Collection)workgroupIds);
            orCriteria.addOrCriteria(delegatorWorkgroupCriteria);
            orCriteria.addOrCriteria(delegatorPrincipalIdCriteria);
        } else {
            orCriteria.addAndCriteria(delegatorPrincipalIdCriteria);
        }
        Criteria criteria = new Criteria();
        criteria.addEqualTo("delegationType", (Object)DelegationType.PRIMARY.getCode());
        criteria.addAndCriteria(orCriteria);
        ReportQueryByCriteria query = QueryFactory.newReportQuery(ActionItem.class, (Criteria)criteria, (boolean)true);
        query.setAttributes(new String[]{"principalId"});
        HashMap<String, WebFriendlyRecipient> delegators = new HashMap<String, WebFriendlyRecipient>();
        Iterator iterator = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        while (iterator.hasNext()) {
            Object[] ids = (Object[])iterator.next();
            if (ids[0] == null || delegators.containsKey((String)ids[0])) continue;
            Person person = KimApiServiceLocator.getPersonService().getPerson((String)ids[0]);
            if (person != null) {
                WebFriendlyRecipient rec = new WebFriendlyRecipient(person);
                delegators.put((String)ids[0], rec);
                continue;
            }
            LOG.warn((Object)("The name for " + (String)ids[0] + " was not added to the primary delegate drop down list because the delegate does not exist."));
        }
        return delegators.values();
    }

    @Override
    public Collection<ActionItem> findByPrincipalId(String principalId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("principalId", (Object)principalId);
        QueryByCriteria query = new QueryByCriteria(ActionItem.class, crit);
        query.addOrderByAscending("documentId");
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }
}

