/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actionrequest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.KimGroupRecipient;
import org.kuali.rice.kew.actionrequest.KimPrincipalRecipient;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.actionrequest.service.ActionRequestService;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.action.ActionRequestPolicy;
import org.kuali.rice.kew.api.action.ActionRequestStatus;
import org.kuali.rice.kew.api.action.RecipientType;
import org.kuali.rice.kew.api.identity.Id;
import org.kuali.rice.kew.api.user.UserId;
import org.kuali.rice.kew.api.util.CodeTranslator;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.identity.service.IdentityHelperService;
import org.kuali.rice.kew.role.KimRoleRecipient;
import org.kuali.rice.kew.role.KimRoleResponsibilityRecipient;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.rule.ResolvedQualifiedRole;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.user.RoleRecipient;
import org.kuali.rice.kew.util.Utilities;
import org.kuali.rice.kew.workgroup.GroupId;
import org.kuali.rice.kim.api.common.delegate.DelegateMember;
import org.kuali.rice.kim.api.common.delegate.DelegateType;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.kim.api.responsibility.ResponsibilityAction;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.util.ObjectUtils;

public class ActionRequestFactory {
    private static final Logger LOG = Logger.getLogger(ActionRequestFactory.class);
    private static RoleService roleService;
    private static IdentityHelperService identityHelperService;
    private static IdentityService identityService;
    private static GroupService groupService;
    private static ActionRequestService actionRequestService;
    private DocumentRouteHeaderValue document;
    private RouteNodeInstance routeNode;
    private List<ActionRequestValue> requestGraphs = new ArrayList<ActionRequestValue>();

    public ActionRequestFactory() {
    }

    public ActionRequestFactory(DocumentRouteHeaderValue document) {
        this.document = document;
    }

    public ActionRequestFactory(DocumentRouteHeaderValue document, RouteNodeInstance routeNode) {
        this.document = document;
        this.routeNode = routeNode;
    }

    public ActionRequestFactory(RouteContext routeContext) {
        this(routeContext.getDocument(), routeContext.getNodeInstance());
    }

    public ActionRequestValue createActionRequest(String actionRequested, Recipient recipient, String description, Boolean forceAction, String annotation) {
        return this.createActionRequest(actionRequested, new Integer(0), recipient, description, "0", forceAction, annotation);
    }

    public ActionRequestValue createActionRequest(String actionRequested, Integer priority, Recipient recipient, String description, String responsibilityId, Boolean forceAction, String annotation) {
        return this.createActionRequest(actionRequested, priority, recipient, description, responsibilityId, forceAction, null, null, annotation);
    }

    public ActionRequestValue createActionRequest(String actionRequested, Integer priority, Recipient recipient, String description, String responsibilityId, Boolean forceAction, String approvePolicy, String ruleId, String annotation) {
        return this.createActionRequest(actionRequested, priority, recipient, description, responsibilityId, forceAction, approvePolicy, ruleId, annotation, null);
    }

    public ActionRequestValue createActionRequest(String actionRequested, Integer priority, Recipient recipient, String description, String responsibilityId, Boolean forceAction, String approvePolicy, String ruleId, String annotation, String requestLabel) {
        ActionRequestValue actionRequest = new ActionRequestValue();
        actionRequest.setActionRequested(actionRequested);
        actionRequest.setDocVersion(this.document.getDocVersion());
        actionRequest.setPriority(priority);
        actionRequest.setRouteHeader(this.document);
        actionRequest.setDocumentId(this.document.getDocumentId());
        actionRequest.setRouteLevel(this.document.getDocRouteLevel());
        actionRequest.setNodeInstance(this.routeNode);
        actionRequest.setResponsibilityId(responsibilityId);
        actionRequest.setResponsibilityDesc(description);
        actionRequest.setApprovePolicy(approvePolicy);
        actionRequest.setForceAction(forceAction);
        actionRequest.setRuleBaseValuesId(ruleId);
        actionRequest.setAnnotation(annotation);
        actionRequest.setRequestLabel(requestLabel);
        this.setDefaultProperties(actionRequest);
        ActionRequestFactory.resolveRecipient(actionRequest, recipient);
        return actionRequest;
    }

    public ActionRequestValue createBlankActionRequest() {
        ActionRequestValue request = new ActionRequestValue();
        request.setRouteHeader(this.document);
        if (this.document != null) {
            request.setDocumentId(this.document.getDocumentId());
        }
        request.setNodeInstance(this.routeNode);
        return request;
    }

    public ActionRequestValue createNotificationRequest(String actionRequestCode, PrincipalContract principal, String reasonActionCode, PrincipalContract reasonActionUser, String responsibilityDesc) {
        ActionRequestValue request = this.createActionRequest(actionRequestCode, new KimPrincipalRecipient(principal), responsibilityDesc, Boolean.TRUE, null);
        String annotation = this.generateNotificationAnnotation(reasonActionUser, actionRequestCode, reasonActionCode, request);
        request.setAnnotation(annotation);
        return request;
    }

    public List<ActionRequestValue> generateNotifications(List requests, PrincipalContract principal, Recipient delegator, String notificationRequestCode, String actionTakenCode) {
        String groupName = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-WKFLW", "Notification", "NOTIFY_GROUPS");
        Group notifyExclusionWorkgroup = null;
        if (!StringUtils.isBlank((String)groupName)) {
            notifyExclusionWorkgroup = ActionRequestFactory.getGroupService().getGroupByNamespaceCodeAndName(Utilities.parseGroupNamespaceCode(groupName), Utilities.parseGroupName(groupName));
        }
        return this.generateNotifications(null, ActionRequestFactory.getActionRequestService().getRootRequests(requests), principal, delegator, notificationRequestCode, actionTakenCode, notifyExclusionWorkgroup);
    }

    private List<ActionRequestValue> generateNotifications(ActionRequestValue parentRequest, List requests, PrincipalContract principal, Recipient delegator, String notificationRequestCode, String actionTakenCode, Group notifyExclusionWorkgroup) {
        ArrayList<ActionRequestValue> notificationRequests = new ArrayList<ActionRequestValue>();
        for (ActionRequestValue actionRequest : requests) {
            if (actionRequest.isRecipientRoutedRequest(principal.getPrincipalId()) || actionRequest.isRecipientRoutedRequest(delegator) || notifyExclusionWorkgroup != null && this.isRecipientInGroup(notifyExclusionWorkgroup, actionRequest.getRecipient())) continue;
            ActionRequestValue notificationRequest = this.createNotificationRequest(actionRequest, principal, notificationRequestCode, actionTakenCode);
            notificationRequests.add(notificationRequest);
            if (parentRequest != null) {
                notificationRequest.setParentActionRequest(parentRequest);
                parentRequest.getChildrenRequests().add(notificationRequest);
            }
            notificationRequests.addAll(this.generateNotifications(notificationRequest, actionRequest.getChildrenRequests(), principal, delegator, notificationRequestCode, actionTakenCode, notifyExclusionWorkgroup));
        }
        return notificationRequests;
    }

    private boolean isRecipientInGroup(Group group, Recipient recipient) {
        boolean isMember = false;
        if (recipient instanceof KimPrincipalRecipient) {
            String principalId = ((KimPrincipalRecipient)recipient).getPrincipalId();
            String groupId = group.getId();
            isMember = ActionRequestFactory.getGroupService().isMemberOfGroup(principalId, groupId);
        } else if (recipient instanceof KimGroupRecipient) {
            String kimRecipientId = ((KimGroupRecipient)recipient).getGroup().getId();
            isMember = ActionRequestFactory.getGroupService().isGroupMemberOfGroup(kimRecipientId, group.getId());
        }
        return isMember;
    }

    private ActionRequestValue createNotificationRequest(ActionRequestValue actionRequest, PrincipalContract reasonPrincipal, String notificationRequestCode, String actionTakenCode) {
        String annotation = this.generateNotificationAnnotation(reasonPrincipal, notificationRequestCode, actionTakenCode, actionRequest);
        ActionRequestValue request = this.createActionRequest(notificationRequestCode, actionRequest.getPriority(), actionRequest.getRecipient(), actionRequest.getResponsibilityDesc(), "0", Boolean.TRUE, annotation);
        request.setDocVersion(actionRequest.getDocVersion());
        request.setApprovePolicy(actionRequest.getApprovePolicy());
        request.setRoleName(actionRequest.getRoleName());
        request.setQualifiedRoleName(actionRequest.getQualifiedRoleName());
        request.setQualifiedRoleNameLabel(actionRequest.getQualifiedRoleNameLabel());
        request.setDelegationType(actionRequest.getDelegationType());
        return request;
    }

    private void setDefaultProperties(ActionRequestValue actionRequest) {
        if (actionRequest.getApprovePolicy() == null) {
            actionRequest.setApprovePolicy(ActionRequestPolicy.FIRST.getCode());
        }
        actionRequest.setCreateDate(new Timestamp(System.currentTimeMillis()));
        actionRequest.setCurrentIndicator(Boolean.TRUE);
        if (actionRequest.getForceAction() == null) {
            actionRequest.setForceAction(Boolean.FALSE);
        }
        if (this.routeNode != null) {
            actionRequest.setNodeInstance(this.routeNode);
        }
        actionRequest.setJrfVerNbr(new Integer(0));
        actionRequest.setStatus(ActionRequestStatus.INITIALIZED.getCode());
        actionRequest.setRouteHeader(this.document);
        actionRequest.setDocumentId(this.document.getDocumentId());
    }

    private static void resolveRecipient(ActionRequestValue actionRequest, Recipient recipient) {
        if (recipient instanceof KimPrincipalRecipient) {
            actionRequest.setRecipientTypeCd(RecipientType.PRINCIPAL.getCode());
            actionRequest.setPrincipalId(((KimPrincipalRecipient)recipient).getPrincipal().getPrincipalId());
        } else if (recipient instanceof KimGroupRecipient) {
            KimGroupRecipient kimGroupRecipient = (KimGroupRecipient)recipient;
            actionRequest.setRecipientTypeCd(RecipientType.GROUP.getCode());
            actionRequest.setGroupId(kimGroupRecipient.getGroup().getId());
        } else if (recipient instanceof RoleRecipient) {
            RoleRecipient role = (RoleRecipient)recipient;
            actionRequest.setRecipientTypeCd(RecipientType.ROLE.getCode());
            actionRequest.setRoleName(role.getRoleName());
            actionRequest.setQualifiedRoleName(role.getQualifiedRoleName());
            ResolvedQualifiedRole qualifiedRole = role.getResolvedQualifiedRole();
            if (qualifiedRole != null) {
                actionRequest.setAnnotation(qualifiedRole.getAnnotation() == null ? "" : qualifiedRole.getAnnotation());
                actionRequest.setQualifiedRoleNameLabel(qualifiedRole.getQualifiedRoleLabel());
            }
            Recipient targetRecipient = role.getTarget();
            if (role.getTarget() != null) {
                if (targetRecipient instanceof RoleRecipient) {
                    throw new WorkflowRuntimeException("Role Cannot Target a role problem activating request for document " + actionRequest.getDocumentId());
                }
                ActionRequestFactory.resolveRecipient(actionRequest, role.getTarget());
            }
        } else if (recipient instanceof KimRoleResponsibilityRecipient) {
            KimRoleResponsibilityRecipient roleResponsibilityRecipient = (KimRoleResponsibilityRecipient)recipient;
            actionRequest.setRecipientTypeCd(RecipientType.ROLE.getCode());
            actionRequest.setRoleName(roleResponsibilityRecipient.getResponsibilities().get(0).getRoleId());
            actionRequest.setQualifiedRoleName(roleResponsibilityRecipient.getResponsibilities().get(0).getResponsibilityName());
            Recipient targetRecipient = roleResponsibilityRecipient.getTarget();
            if (targetRecipient != null) {
                if (targetRecipient instanceof RoleRecipient) {
                    throw new WorkflowRuntimeException("Role Cannot Target a role problem activating request for document " + actionRequest.getDocumentId());
                }
                ActionRequestFactory.resolveRecipient(actionRequest, roleResponsibilityRecipient.getTarget());
            }
        } else if (recipient instanceof KimRoleRecipient) {
            KimRoleRecipient roleRecipient = (KimRoleRecipient)recipient;
            actionRequest.setRecipientTypeCd(RecipientType.ROLE.getCode());
            Role role = roleRecipient.getRole();
            actionRequest.setRoleName(role.getId());
            actionRequest.setQualifiedRoleNameLabel(role.getName());
            Recipient targetRecipient = roleRecipient.getTarget();
            if (targetRecipient != null) {
                if (targetRecipient instanceof RoleRecipient) {
                    throw new WorkflowRuntimeException("Role Cannot Target a role problem activating request for document " + actionRequest.getDocumentId());
                }
                ActionRequestFactory.resolveRecipient(actionRequest, targetRecipient);
            }
        }
    }

    public ActionRequestValue addRoleRequest(RoleRecipient role, String actionRequested, String approvePolicy, Integer priority, String responsibilityId, Boolean forceAction, String description, String ruleId) {
        ActionRequestValue requestGraph = this.createActionRequest(actionRequested, priority, role, description, responsibilityId, forceAction, approvePolicy, ruleId, null);
        if (role != null && role.getResolvedQualifiedRole() != null && role.getResolvedQualifiedRole().getRecipients() != null) {
            int legitimateTargets = 0;
            for (Id recipientId : role.getResolvedQualifiedRole().getRecipients()) {
                if (recipientId.isEmpty()) {
                    throw new WorkflowRuntimeException("Failed to resolve id of type " + recipientId.getClass().getName() + " returned from role '" + role.getRoleName() + "'.  Id returned contained a null or empty value.");
                }
                if (recipientId instanceof UserId) {
                    Principal principal = ActionRequestFactory.getIdentityHelperService().getPrincipal((UserId)recipientId);
                    if (ObjectUtils.isNotNull((Object)principal)) {
                        role.setTarget(new KimPrincipalRecipient((PrincipalContract)principal));
                    }
                } else if (recipientId instanceof GroupId) {
                    role.setTarget(new KimGroupRecipient(ActionRequestFactory.getIdentityHelperService().getGroup((GroupId)recipientId)));
                } else {
                    throw new WorkflowRuntimeException("Could not process the given type of id: " + recipientId.getClass());
                }
                if (role.getTarget() == null) continue;
                ++legitimateTargets;
                ActionRequestValue request = this.createActionRequest(actionRequested, priority, role, description, responsibilityId, forceAction, null, ruleId, null);
                request.setParentActionRequest(requestGraph);
                requestGraph.getChildrenRequests().add(request);
            }
            if (legitimateTargets == 0) {
                LOG.warn((Object)"Role did not yield any legitimate recipients");
            }
        } else {
            LOG.warn((Object)("Didn't create action requests for action request description '" + description + "' because of null role or null part of role object graph."));
        }
        this.requestGraphs.add(requestGraph);
        return requestGraph;
    }

    public void addRoleResponsibilityRequest(List<ResponsibilityAction> responsibilities, String approvePolicy) {
        if (responsibilities == null || responsibilities.isEmpty()) {
            LOG.warn((Object)"Didn't create action requests for action request description because no responsibilities were defined.");
            return;
        }
        String actionTypeCode = responsibilities.get(0).getActionTypeCode();
        Integer priority = responsibilities.get(0).getPriorityNumber();
        boolean forceAction = responsibilities.get(0).isForceAction();
        KimRoleResponsibilityRecipient roleResponsibilityRecipient = new KimRoleResponsibilityRecipient(responsibilities);
        ActionRequestValue requestGraph = null;
        StringBuffer parentAnnotation = null;
        HashSet<String> uniqueChildAnnotations = null;
        if (responsibilities.size() > 1) {
            requestGraph = this.createActionRequest(actionTypeCode, priority, roleResponsibilityRecipient, "", "0", forceAction, approvePolicy, null, null);
            this.requestGraphs.add(requestGraph);
            parentAnnotation = new StringBuffer();
            uniqueChildAnnotations = new HashSet<String>(responsibilities.size());
        }
        StringBuffer annotation = new StringBuffer();
        for (ResponsibilityAction responsibility : responsibilities) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Processing Responsibility for action request: " + responsibility));
            }
            annotation.setLength(0);
            Role role = ActionRequestFactory.getRoleService().getRole(responsibility.getRoleId());
            annotation.append(role.getNamespaceCode()).append(' ').append(role.getName()).append(' ');
            Map qualifier = responsibility.getQualifier();
            if (qualifier != null) {
                for (String key : qualifier.keySet()) {
                    annotation.append((String)qualifier.get(key)).append(' ');
                }
            }
            if (responsibility.getPrincipalId() != null) {
                roleResponsibilityRecipient.setTarget(new KimPrincipalRecipient(responsibility.getPrincipalId()));
            } else if (responsibility.getGroupId() != null) {
                roleResponsibilityRecipient.setTarget(new KimGroupRecipient(responsibility.getGroupId()));
            } else {
                throw new RiceRuntimeException("Failed to identify a group or principal on the given ResponsibilityResolutionInfo:" + responsibility);
            }
            String annotationStr = annotation.toString();
            ActionRequestValue request = this.createActionRequest(responsibility.getActionTypeCode(), responsibility.getPriorityNumber(), roleResponsibilityRecipient, responsibility.getParallelRoutingGroupingCode(), responsibility.getResponsibilityId(), responsibility.isForceAction(), responsibilities.size() == 1 ? ActionRequestPolicy.FIRST.getCode() : approvePolicy, null, annotationStr);
            if (responsibilities.size() > 1) {
                request.setParentActionRequest(requestGraph);
                requestGraph.getChildrenRequests().add(request);
                if (!uniqueChildAnnotations.contains(annotationStr)) {
                    parentAnnotation.append(annotationStr).append(" -- ");
                    uniqueChildAnnotations.add(annotationStr);
                }
            } else {
                this.requestGraphs.add(request);
            }
            this.generateKimRoleDelegationRequests(responsibility.getDelegates(), request);
        }
        if (responsibilities.size() > 1) {
            requestGraph.setAnnotation(StringUtils.chomp((String)parentAnnotation.toString(), (String)" -- "));
        }
    }

    private String generateRoleResponsibilityDelegateAnnotation(DelegateMember member, boolean isPrincipal, boolean isGroup, ActionRequestValue parentRequest) {
        StringBuffer annotation = new StringBuffer("Delegation of: ");
        annotation.append(parentRequest.getAnnotation());
        annotation.append(" to ");
        if (isPrincipal) {
            annotation.append("principal ");
            Principal principal = ActionRequestFactory.getIdentityService().getPrincipal(member.getMemberId());
            if (principal != null) {
                annotation.append(principal.getPrincipalName());
            } else {
                annotation.append(member.getMemberId());
            }
        } else if (isGroup) {
            annotation.append("group ");
            Group group = ActionRequestFactory.getGroupService().getGroup(member.getMemberId());
            if (group != null) {
                annotation.append(group.getNamespaceCode()).append('/').append(group.getName());
            } else {
                annotation.append(member.getMemberId());
            }
        } else {
            annotation.append("?????? '");
            annotation.append(member.getMemberId());
            annotation.append("'");
        }
        return annotation.toString();
    }

    public ActionRequestValue addDelegationRoleRequest(ActionRequestValue parentRequest, String approvePolicy, RoleRecipient role, String responsibilityId, Boolean forceAction, DelegationType delegationType, String description, String ruleId) {
        Recipient parentRecipient = parentRequest.getRecipient();
        if (parentRecipient instanceof RoleRecipient) {
            throw new WorkflowRuntimeException("Cannot delegate on Role Request.  It must be a request to a person or workgroup, although that request may be in a role");
        }
        if (!this.relatedToRoot(parentRequest)) {
            throw new WorkflowRuntimeException("The parent request is not related to any request managed by this factory");
        }
        ActionRequestValue delegationRoleRequest = this.createActionRequest(parentRequest.getActionRequested(), parentRequest.getPriority(), role, description, responsibilityId, forceAction, approvePolicy, ruleId, null);
        delegationRoleRequest.setDelegationType(delegationType);
        int count = 0;
        for (Id recipientId : role.getResolvedQualifiedRole().getRecipients()) {
            if (recipientId.isEmpty()) {
                throw new WorkflowRuntimeException("Failed to resolve id of type " + recipientId.getClass().getName() + " returned from role '" + role.getRoleName() + "'.  Id returned contained a null or empty value.");
            }
            if (recipientId instanceof UserId) {
                role.setTarget(new KimPrincipalRecipient((PrincipalContract)ActionRequestFactory.getIdentityHelperService().getPrincipal((UserId)recipientId)));
            } else if (recipientId instanceof GroupId) {
                role.setTarget(new KimGroupRecipient(ActionRequestFactory.getIdentityHelperService().getGroup((GroupId)recipientId)));
            } else {
                throw new WorkflowRuntimeException("Could not process the given type of id: " + recipientId.getClass());
            }
            ActionRequestValue request = this.createActionRequest(parentRequest.getActionRequested(), parentRequest.getPriority(), role, description, responsibilityId, forceAction, null, ruleId, null);
            request.setDelegationType(delegationType);
            request.setParentActionRequest(delegationRoleRequest);
            delegationRoleRequest.getChildrenRequests().add(request);
            ++count;
        }
        if (count > 0) {
            parentRequest.getChildrenRequests().add(delegationRoleRequest);
            delegationRoleRequest.setParentActionRequest(parentRequest);
        }
        return delegationRoleRequest;
    }

    public ActionRequestValue addDelegationRequest(ActionRequestValue parentRequest, Recipient recipient, String responsibilityId, Boolean forceAction, DelegationType delegationType, String annotation, String ruleId) {
        if (!this.relatedToRoot(parentRequest)) {
            throw new WorkflowRuntimeException("The parent request is not related to any request managed by this factory");
        }
        ActionRequestValue delegationRequest = this.createActionRequest(parentRequest.getActionRequested(), parentRequest.getPriority(), recipient, parentRequest.getResponsibilityDesc(), responsibilityId, forceAction, null, ruleId, annotation);
        delegationRequest.setDelegationType(delegationType);
        parentRequest.getChildrenRequests().add(delegationRequest);
        delegationRequest.setParentActionRequest(parentRequest);
        return delegationRequest;
    }

    public ActionRequestValue addRootActionRequest(String actionRequested, Integer priority, Recipient recipient, String description, String responsibilityId, Boolean forceAction, String approvePolicy, String ruleId) {
        ActionRequestValue requestGraph = this.createActionRequest(actionRequested, priority, recipient, description, responsibilityId, forceAction, approvePolicy, ruleId, null);
        this.requestGraphs.add(requestGraph);
        return requestGraph;
    }

    public void addKimRoleRequest(String actionRequestedCode, Integer priority, Role role, List<RoleMembership> memberships, String description, String responsibilityId, boolean forceAction, String actionRequestPolicyCode, String requestLabel) {
        if (CollectionUtils.isEmpty(memberships)) {
            LOG.warn((Object)("Didn't create action requests for action request description because no role members were defined for role id " + role.getId()));
            return;
        }
        KimRoleRecipient roleRecipient = new KimRoleRecipient(role);
        ActionRequestValue requestGraph = null;
        if (memberships.size() > 1) {
            requestGraph = this.createActionRequest(actionRequestedCode, priority, roleRecipient, "", responsibilityId, forceAction, actionRequestPolicyCode, null, null);
            this.requestGraphs.add(requestGraph);
        }
        for (RoleMembership membership : memberships) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Processing RoleMembership for action request: " + membership));
            }
            if (MemberType.PRINCIPAL.equals((Object)membership.getType())) {
                roleRecipient.setTarget(new KimPrincipalRecipient(membership.getMemberId()));
            } else if (MemberType.GROUP.equals((Object)membership.getType())) {
                roleRecipient.setTarget(new KimGroupRecipient(membership.getMemberId()));
            } else {
                throw new RiceRuntimeException("Failed to identify a group or principal on the given RoleMembership:" + membership);
            }
            ActionRequestValue request = this.createActionRequest(actionRequestedCode, priority, roleRecipient, "", responsibilityId, forceAction, memberships.size() == 1 ? ActionRequestPolicy.FIRST.getCode() : actionRequestPolicyCode, null, null);
            if (memberships.size() > 1) {
                request.setParentActionRequest(requestGraph);
                requestGraph.getChildrenRequests().add(request);
            } else {
                this.requestGraphs.add(request);
            }
            this.generateKimRoleDelegationRequests(membership.getDelegates(), request);
        }
    }

    private void generateKimRoleDelegationRequests(List<DelegateType> delegates, ActionRequestValue parentRequest) {
        for (DelegateType delegate : delegates) {
            for (DelegateMember member : delegate.getMembers()) {
                Recipient recipient;
                boolean isPrincipal = MemberType.PRINCIPAL.equals((Object)member.getType());
                boolean isGroup = MemberType.GROUP.equals((Object)member.getType());
                if (isPrincipal) {
                    recipient = new KimPrincipalRecipient(member.getMemberId());
                } else if (isGroup) {
                    recipient = new KimGroupRecipient(member.getMemberId());
                } else {
                    throw new RiceRuntimeException("Invalid DelegateInfo memberTypeCode encountered, was '" + member.getType() + "'");
                }
                String delegationAnnotation = this.generateRoleResponsibilityDelegateAnnotation(member, isPrincipal, isGroup, parentRequest);
                this.addDelegationRequest(parentRequest, recipient, delegate.getDelegationId(), parentRequest.getForceAction(), delegate.getDelegationType(), delegationAnnotation, null);
            }
        }
    }

    public boolean relatedToRoot(ActionRequestValue request) {
        int i = 0;
        while (i < 3) {
            if (this.requestGraphs.contains(request)) {
                return true;
            }
            if (request == null) {
                return false;
            }
            ++i;
            request = request.getParentActionRequest();
        }
        return false;
    }

    public List<ActionRequestValue> getRequestGraphs() {
        this.requestGraphs.removeAll(this.cleanUpChildren(this.requestGraphs));
        return this.requestGraphs;
    }

    private Collection<ActionRequestValue> cleanUpChildren(Collection<ActionRequestValue> children) {
        ArrayList<ActionRequestValue> requestsToRemove = new ArrayList<ActionRequestValue>();
        for (ActionRequestValue aChildren : children) {
            if (!aChildren.isRoleRequest()) continue;
            if (aChildren.getChildrenRequests().isEmpty()) {
                requestsToRemove.add(aChildren);
                continue;
            }
            Collection<ActionRequestValue> childRequestsToRemove = this.cleanUpChildren(aChildren.getChildrenRequests());
            aChildren.getChildrenRequests().removeAll(childRequestsToRemove);
        }
        return requestsToRemove;
    }

    private String generateNotificationAnnotation(PrincipalContract principal, String notificationRequestCode, String actionTakenCode, ActionRequestValue request) {
        String notification = "Action " + CodeTranslator.getActionRequestLabel((String)notificationRequestCode) + " generated by Workflow because " + principal.getPrincipalName() + " took action " + CodeTranslator.getActionTakenLabel((String)actionTakenCode);
        if (request.getResponsibilityId() != null && !"0".equals(request.getResponsibilityId())) {
            notification = notification + " Responsibility " + request.getResponsibilityId();
        }
        if (request.getRuleBaseValuesId() != null) {
            notification = notification + " Rule Id " + request.getRuleBaseValuesId();
        }
        if (request.getAnnotation() != null && request.getAnnotation().length() != 0) {
            notification = notification + " " + request.getAnnotation();
        }
        return notification;
    }

    protected static ActionRequestService getActionRequestService() {
        if (actionRequestService == null) {
            actionRequestService = KEWServiceLocator.getActionRequestService();
        }
        return actionRequestService;
    }

    protected static RoleService getRoleService() {
        if (roleService == null) {
            roleService = KimApiServiceLocator.getRoleService();
        }
        return roleService;
    }

    protected static IdentityHelperService getIdentityHelperService() {
        if (identityHelperService == null) {
            identityHelperService = KEWServiceLocator.getIdentityHelperService();
        }
        return identityHelperService;
    }

    protected static IdentityService getIdentityService() {
        if (identityService == null) {
            identityService = KimApiServiceLocator.getIdentityService();
        }
        return identityService;
    }

    protected static GroupService getGroupService() {
        if (groupService == null) {
            groupService = KimApiServiceLocator.getGroupService();
        }
        return groupService;
    }
}

