/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.kew.actionrequest.ActionRequestFactory;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.KimGroupRecipient;
import org.kuali.rice.kew.actionrequest.KimPrincipalRecipient;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.actionrequest.service.ActionRequestService;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.doctype.DocumentTypePolicy;
import org.kuali.rice.kew.api.document.DocumentProcessingOptions;
import org.kuali.rice.kew.api.document.DocumentProcessingQueue;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeIndexingQueue;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kew.framework.postprocessor.PostProcessor;
import org.kuali.rice.kew.framework.postprocessor.ProcessDocReport;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.util.Utilities;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public abstract class ActionTakenEvent {
    protected static final boolean DEFAULT_QUEUE_DOCUMENT_AFTER_ACTION = true;
    protected static final boolean DEFAULT_RUN_POSTPROCESSOR_LOGIC = true;
    protected static final String DEFAULT_ANNOTATION = null;
    private static final Logger LOG = Logger.getLogger(ActionTakenEvent.class);
    private String actionTakenCode;
    protected final String annotation;
    protected DocumentRouteHeaderValue routeHeader;
    private final PrincipalContract principal;
    private final boolean runPostProcessorLogic;
    private final boolean queueDocumentAfterAction;
    private transient List<String> groupIdsForPrincipal;

    public ActionTakenEvent(String actionTakenCode, DocumentRouteHeaderValue routeHeader, PrincipalContract principal) {
        this(actionTakenCode, routeHeader, principal, DEFAULT_ANNOTATION, true, true);
    }

    public ActionTakenEvent(String actionTakenCode, DocumentRouteHeaderValue routeHeader, PrincipalContract principal, String annotation) {
        this(actionTakenCode, routeHeader, principal, annotation, true, true);
    }

    public ActionTakenEvent(String actionTakenCode, DocumentRouteHeaderValue routeHeader, PrincipalContract principal, String annotation, boolean runPostProcessorLogic) {
        this(actionTakenCode, routeHeader, principal, annotation, runPostProcessorLogic, true);
    }

    public ActionTakenEvent(String actionTakenCode, DocumentRouteHeaderValue routeHeader, PrincipalContract principal, String annotation, boolean runPostProcessorLogic, boolean queueDocumentAfterAction) {
        this.actionTakenCode = actionTakenCode;
        this.routeHeader = routeHeader;
        this.principal = principal;
        this.annotation = annotation == null ? "" : annotation;
        this.runPostProcessorLogic = runPostProcessorLogic;
        this.queueDocumentAfterAction = queueDocumentAfterAction;
    }

    public ActionRequestService getActionRequestService() {
        return (ActionRequestService)KEWServiceLocator.getService("enActionRequestService");
    }

    protected DocumentRouteHeaderValue getRouteHeader() {
        return this.routeHeader;
    }

    protected void setRouteHeader(DocumentRouteHeaderValue routeHeader) {
        this.routeHeader = routeHeader;
    }

    protected PrincipalContract getPrincipal() {
        return this.principal;
    }

    protected String getActionPerformedCode() {
        return this.getActionTakenCode();
    }

    protected boolean isActionValid() {
        return StringUtils.isEmpty((String)this.validateActionRules());
    }

    protected static boolean isPolicySet(DocumentType docType, DocumentTypePolicy policy, boolean deflt) {
        return docType.getPolicyByName(policy.name(), deflt).getPolicyValue();
    }

    protected static boolean isPolicySet(DocumentType docType, DocumentTypePolicy policy) {
        return ActionTakenEvent.isPolicySet(docType, policy, false);
    }

    public abstract String validateActionRules();

    protected abstract String validateActionRules(List<ActionRequestValue> var1);

    protected List<ActionRequestValue> filterActionRequestsByCode(List<ActionRequestValue> actionRequests, String requestCode) {
        return this.getActionRequestService().filterActionRequestsByCode(actionRequests, this.getPrincipal().getPrincipalId(), this.getGroupIdsForPrincipal(), requestCode);
    }

    protected boolean isActionCompatibleRequest(List<ActionRequestValue> requests) {
        LOG.debug((Object)"isActionCompatibleRequest() Default method = returning true");
        return true;
    }

    public void performAction() throws InvalidActionTakenException {
        try {
            this.recordAction();
        }
        catch (InvalidActionTakenException e) {
            if (this.routeHeader.getDocumentType().getEnrouteErrorSuppression().getPolicyValue().booleanValue()) {
                LOG.error((Object)"Invalid Action Taken Exception was thrown, but swallowed due to ENROUTE_ERROR_SUPPRESSION document type policy!");
                return;
            }
            throw e;
        }
        if (this.queueDocumentAfterAction) {
            this.queueDocumentProcessing();
        }
    }

    protected abstract void recordAction() throws InvalidActionTakenException;

    protected void updateSearchableAttributesIfPossible() {
        RouteContext routeContext = RouteContext.getCurrentRouteContext();
        if (this.routeHeader.getDocumentType().hasSearchableAttributes() && !routeContext.isSearchIndexingRequestedForContext()) {
            routeContext.requestSearchIndexingForContext();
            DocumentAttributeIndexingQueue queue = KewApiServiceLocator.getDocumentAttributeIndexingQueue((String)this.routeHeader.getDocumentType().getApplicationId());
            queue.indexDocument(this.getDocumentId());
        }
    }

    protected void invokePostProcessor(String message, Callable<ProcessDocReport> invocation) {
        if (!this.isRunPostProcessorLogic()) {
            return;
        }
        LOG.debug((Object)message);
        try {
            ProcessDocReport report = invocation.call();
            if (!report.isSuccess()) {
                LOG.warn((Object)report.getMessage(), (Throwable)report.getProcessException());
                throw new InvalidActionTakenException(report.getMessage());
            }
        }
        catch (Exception ex) {
            this.processPostProcessorException(ex);
        }
    }

    protected void notifyActionTaken(final ActionTakenValue actionTaken) {
        this.invokePostProcessor("Notifying post processor of action taken", new Callable<ProcessDocReport>(){

            @Override
            public ProcessDocReport call() throws Exception {
                PostProcessor postProcessor = ActionTakenEvent.this.routeHeader.getDocumentType().getPostProcessor();
                return postProcessor.doActionTaken(new org.kuali.rice.kew.framework.postprocessor.ActionTakenEvent(ActionTakenEvent.this.routeHeader.getDocumentId(), ActionTakenEvent.this.routeHeader.getAppDocId(), ActionTakenValue.to(actionTaken)));
            }
        });
    }

    protected void notifyAfterActionTaken(final ActionTakenValue actionTaken) {
        this.invokePostProcessor("Notifying post processor after action taken", new Callable<ProcessDocReport>(){

            @Override
            public ProcessDocReport call() throws Exception {
                PostProcessor postProcessor = ActionTakenEvent.this.routeHeader.getDocumentType().getPostProcessor();
                return postProcessor.afterActionTaken(ActionType.fromCode((String)ActionTakenEvent.this.getActionPerformedCode()), new org.kuali.rice.kew.framework.postprocessor.ActionTakenEvent(ActionTakenEvent.this.routeHeader.getDocumentId(), ActionTakenEvent.this.routeHeader.getAppDocId(), ActionTakenValue.to(actionTaken)));
            }
        });
    }

    protected void notifyStatusChange(final String newStatusCode, final String oldStatusCode) throws InvalidActionTakenException {
        this.invokePostProcessor("Notifying post processor of status change " + oldStatusCode + "->" + newStatusCode, new Callable<ProcessDocReport>(){

            @Override
            public ProcessDocReport call() throws Exception {
                DocumentRouteStatusChange statusChangeEvent = new DocumentRouteStatusChange(ActionTakenEvent.this.routeHeader.getDocumentId(), ActionTakenEvent.this.routeHeader.getAppDocId(), oldStatusCode, newStatusCode);
                PostProcessor postProcessor = ActionTakenEvent.this.routeHeader.getDocumentType().getPostProcessor();
                return postProcessor.doRouteStatusChange(statusChangeEvent);
            }
        });
    }

    protected void queueDocumentProcessing() {
        DocumentRouteHeaderValue document = this.getRouteHeader();
        String applicationId = document.getDocumentType().getApplicationId();
        DocumentProcessingQueue documentProcessingQueue = KewApiServiceLocator.getDocumentProcessingQueue((String)document.getDocumentId(), (String)applicationId);
        DocumentProcessingOptions options = DocumentProcessingOptions.create((boolean)this.isRunPostProcessorLogic(), (boolean)RouteContext.getCurrentRouteContext().isSearchIndexingRequestedForContext());
        documentProcessingQueue.processWithOptions(this.getDocumentId(), options);
    }

    protected ActionTakenValue saveActionTaken() {
        return this.saveActionTaken(Boolean.TRUE);
    }

    protected ActionTakenValue saveActionTaken(Boolean currentInd) {
        return this.saveActionTaken(currentInd, null);
    }

    protected ActionTakenValue saveActionTaken(Recipient delegator) {
        return this.saveActionTaken(Boolean.TRUE, delegator);
    }

    protected ActionTakenValue saveActionTaken(Boolean currentInd, Recipient delegator) {
        ActionTakenValue val = new ActionTakenValue();
        val.setActionTaken(this.getActionTakenCode());
        val.setAnnotation(this.annotation);
        val.setDocVersion(this.routeHeader.getDocVersion());
        val.setDocumentId(this.routeHeader.getDocumentId());
        val.setPrincipalId(this.principal.getPrincipalId());
        if (delegator instanceof KimPrincipalRecipient) {
            val.setDelegatorPrincipalId(((KimPrincipalRecipient)delegator).getPrincipalId());
        } else if (delegator instanceof KimGroupRecipient) {
            val.setDelegatorGroupId(((KimGroupRecipient)delegator).getGroupId());
        }
        val.setCurrentIndicator(currentInd);
        KEWServiceLocator.getActionTakenService().saveActionTaken(val);
        return val;
    }

    protected Recipient findDelegatorForActionRequests(List actionRequests) {
        return this.getActionRequestService().findDelegator(actionRequests);
    }

    public String getActionTakenCode() {
        return this.actionTakenCode;
    }

    protected void setActionTakenCode(String string) {
        this.actionTakenCode = string;
    }

    protected String getDocumentId() {
        return this.routeHeader.getDocumentId();
    }

    protected boolean isRunPostProcessorLogic() {
        return this.runPostProcessorLogic;
    }

    protected List<String> getGroupIdsForPrincipal() {
        if (this.groupIdsForPrincipal == null) {
            this.groupIdsForPrincipal = KimApiServiceLocator.getGroupService().getGroupIdsByPrincipalId(this.getPrincipal().getPrincipalId());
        }
        return this.groupIdsForPrincipal;
    }

    private void processPostProcessorException(Exception e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new WorkflowRuntimeException((Throwable)e);
    }

    protected void generateAcknowledgementsToPreviousActionTakers(RouteNodeInstance notificationNodeInstance) {
        String groupName = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-WKFLW", "Notification", "NOTIFY_GROUPS");
        HashSet<String> systemPrincipalIds = new HashSet<String>();
        if (!StringUtils.isBlank((String)groupName)) {
            Group systemUserWorkgroup = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName(Utilities.parseGroupNamespaceCode(groupName), Utilities.parseGroupName(groupName));
            List principalIds = KimApiServiceLocator.getGroupService().getMemberPrincipalIds(systemUserWorkgroup.getId());
            if (systemUserWorkgroup != null) {
                for (String id : principalIds) {
                    systemPrincipalIds.add(id);
                }
            }
        }
        ActionRequestFactory arFactory = new ActionRequestFactory(this.getRouteHeader(), notificationNodeInstance);
        Collection<ActionTakenValue> actions = KEWServiceLocator.getActionTakenService().findByDocumentId(this.getDocumentId());
        HashSet<String> usersNotified = new HashSet<String>();
        for (ActionTakenValue action : actions) {
            if (!action.isApproval() && !action.isCompletion() || usersNotified.contains(action.getPrincipalId()) || systemPrincipalIds.contains(action.getPrincipalId())) continue;
            ActionRequestValue request = arFactory.createNotificationRequest("K", (PrincipalContract)action.getPrincipal(), this.getActionTakenCode(), this.getPrincipal(), this.getActionTakenCode());
            KEWServiceLocator.getActionRequestService().activateRequest(request);
            usersNotified.add(request.getPrincipalId());
        }
    }
}

