/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actiontaken.dao.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.actiontaken.dao.ActionTakenDAO;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.action.ActionType;
import org.springmodules.orm.ojb.PersistenceBrokerCallback;
import org.springmodules.orm.ojb.support.PersistenceBrokerDaoSupport;

public class ActionTakenDAOOjbImpl
extends PersistenceBrokerDaoSupport
implements ActionTakenDAO {
    private static final Logger LOG = Logger.getLogger(ActionTakenDAOOjbImpl.class);
    private static final String LAST_ACTION_TAKEN_DATE_QUERY = "select max(ACTN_DT) from KREW_ACTN_TKN_T where DOC_HDR_ID=? and ACTN_CD=?";

    @Override
    public ActionTakenValue load(String id) {
        LOG.debug((Object)("Loading Action Taken for the given id " + id));
        Criteria crit = new Criteria();
        crit.addEqualTo("actionTakenId", (Object)id);
        return (ActionTakenValue)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)new QueryByCriteria(ActionTakenValue.class, crit));
    }

    @Override
    public void deleteActionTaken(ActionTakenValue actionTaken) {
        LOG.debug((Object)("deleting ActionTaken " + actionTaken.getActionTakenId()));
        this.getPersistenceBrokerTemplate().delete((Object)actionTaken);
    }

    @Override
    public ActionTakenValue findByActionTakenId(String actionTakenId) {
        LOG.debug((Object)("finding Action Taken by actionTakenId " + actionTakenId));
        Criteria crit = new Criteria();
        crit.addEqualTo("actionTakenId", (Object)actionTakenId);
        crit.addEqualTo("currentIndicator", (Object)Boolean.TRUE);
        return (ActionTakenValue)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)new QueryByCriteria(ActionTakenValue.class, crit));
    }

    @Override
    public Collection<ActionTakenValue> findByDocIdAndAction(String documentId, String action) {
        LOG.debug((Object)("finding Action Taken by documentId " + documentId + " and action " + action));
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        crit.addEqualTo("actionTaken", (Object)action);
        crit.addEqualTo("currentIndicator", (Object)Boolean.TRUE);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(ActionTakenValue.class, crit));
    }

    @Override
    public Collection<ActionTakenValue> findByDocumentId(String documentId) {
        LOG.debug((Object)("finding Action Takens by documentId " + documentId));
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        crit.addEqualTo("currentIndicator", (Object)Boolean.TRUE);
        QueryByCriteria qByCrit = new QueryByCriteria(ActionTakenValue.class, crit);
        qByCrit.addOrderByAscending("actionDate");
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)qByCrit);
    }

    @Override
    public List<ActionTakenValue> findByDocumentIdWorkflowId(String documentId, String principalId) {
        LOG.debug((Object)("finding Action Takens by documentId " + documentId + " and principalId" + principalId));
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        crit.addEqualTo("principalId", (Object)principalId);
        crit.addEqualTo("currentIndicator", (Object)Boolean.TRUE);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(ActionTakenValue.class, crit));
    }

    @Override
    public List findByDocumentIdIgnoreCurrentInd(String documentId) {
        LOG.debug((Object)("finding ActionsTaken ignoring currentInd by documentId:" + documentId));
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        QueryByCriteria qByCrit = new QueryByCriteria(ActionTakenValue.class, crit);
        qByCrit.addOrderByAscending("actionDate");
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)qByCrit);
    }

    @Override
    public void saveActionTaken(ActionTakenValue actionTaken) {
        LOG.debug((Object)"saving ActionTaken");
        this.checkNull(actionTaken.getDocumentId(), "Document ID");
        this.checkNull(actionTaken.getActionTaken(), "action taken code");
        this.checkNull(actionTaken.getDocVersion(), "doc version");
        this.checkNull(actionTaken.getPrincipal(), "user principalId");
        if (actionTaken.getActionDate() == null) {
            actionTaken.setActionDate(new Timestamp(System.currentTimeMillis()));
        }
        if (actionTaken.getCurrentIndicator() == null) {
            actionTaken.setCurrentIndicator(Boolean.TRUE);
        }
        LOG.debug((Object)("saving ActionTaken: routeHeader " + actionTaken.getDocumentId() + ", actionTaken " + actionTaken.getActionTaken() + ", principalId " + actionTaken.getPrincipalId()));
        this.getPersistenceBrokerTemplate().store((Object)actionTaken);
    }

    private void checkNull(Object value, String valueName) throws RuntimeException {
        if (value == null) {
            throw new RuntimeException("Null value for " + valueName);
        }
    }

    @Override
    public void deleteByDocumentId(String documentId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)new QueryByCriteria(ActionRequestValue.class, crit));
    }

    @Override
    public boolean hasUserTakenAction(String principalId, String documentId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        crit.addEqualTo("principalId", (Object)principalId);
        crit.addEqualTo("currentIndicator", (Object)Boolean.TRUE);
        int count = this.getPersistenceBrokerTemplate().getCount((Query)new QueryByCriteria(ActionTakenValue.class, crit));
        return count > 0;
    }

    @Override
    public Timestamp getLastActionTakenDate(final String documentId, final ActionType actionType) {
        return (Timestamp)this.getPersistenceBrokerTemplate().execute(new PersistenceBrokerCallback(){

            public Object doInPersistenceBroker(PersistenceBroker broker) {
                Timestamp timestamp;
                Statement statement = null;
                ResultSet resultSet = null;
                try {
                    Connection connection = broker.serviceConnectionManager().getConnection();
                    statement = connection.prepareStatement(ActionTakenDAOOjbImpl.LAST_ACTION_TAKEN_DATE_QUERY);
                    statement.setString(1, documentId);
                    statement.setString(2, actionType.getCode());
                    resultSet = statement.executeQuery();
                    if (!resultSet.next()) {
                        Object var5_6 = null;
                        return var5_6;
                    }
                    timestamp = resultSet.getTimestamp(1);
                }
                catch (Exception e) {
                    throw new WorkflowRuntimeException("Error determining Last Action Taken Date.", (Throwable)e);
                }
                finally {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                return timestamp;
            }
        });
    }
}

