/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.doctype.service.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.kuali.rice.core.api.impex.ExportDataSet;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.dao.DocumentTypeDAO;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.exception.WorkflowServiceErrorException;
import org.kuali.rice.kew.exception.WorkflowServiceErrorImpl;
import org.kuali.rice.kew.xml.DocumentTypeXmlParser;
import org.kuali.rice.kew.xml.export.DocumentTypeXmlExporter;
import org.kuali.rice.krad.util.ObjectUtils;

public class DocumentTypeServiceImpl
implements DocumentTypeService {
    private static final Logger LOG = Logger.getLogger(DocumentTypeServiceImpl.class);
    protected static final String XML_FILE_PARSE_ERROR = "general.error.parsexml";
    private DocumentTypeDAO documentTypeDAO;

    @Override
    public Collection<DocumentType> find(DocumentType documentType, String docTypeParentName, boolean climbHierarchy) {
        DocumentType docTypeParent = this.findByName(docTypeParentName);
        return this.getDocumentTypeDAO().find(documentType, docTypeParent, climbHierarchy);
    }

    @Override
    public DocumentType findById(String documentTypeId) {
        if (documentTypeId == null) {
            return null;
        }
        return this.getDocumentTypeDAO().findById(documentTypeId);
    }

    @Override
    public DocumentType findByDocumentId(String documentId) {
        if (documentId == null) {
            return null;
        }
        String documentTypeId = this.getDocumentTypeDAO().findDocumentTypeIdByDocumentId(documentId);
        return this.findById(documentTypeId);
    }

    @Override
    public DocumentType findByName(String name) {
        return this.findByName(name, true);
    }

    @Override
    public DocumentType findByNameCaseInsensitive(String name) {
        return this.findByName(name, false);
    }

    private DocumentType findByName(String name, boolean caseSensitive) {
        if (name == null) {
            return null;
        }
        return this.getDocumentTypeDAO().findByName(name, caseSensitive);
    }

    @Override
    public void versionAndSave(DocumentType documentType) {
        if (documentType.getDocumentTypeId() != null && documentType.getVersionNumber() != null) {
            throw new RuntimeException("DocumentType configured for update and not versioning which we support");
        }
        DocumentType oldDocumentType = this.findByName(documentType.getName());
        String existingDocTypeId = null;
        if (oldDocumentType != null) {
            existingDocTypeId = oldDocumentType.getDocumentTypeId();
            Integer maxVersionNumber = this.documentTypeDAO.getMaxVersionNumber(documentType.getName());
            documentType.setVersion(maxVersionNumber != null ? new Integer(maxVersionNumber + 1) : new Integer(0));
            oldDocumentType.setCurrentInd(Boolean.FALSE);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Saving old document type Id " + oldDocumentType.getDocumentTypeId() + " name '" + oldDocumentType.getName() + "' (current = " + oldDocumentType.getCurrentInd() + ")"));
            }
            this.save(oldDocumentType);
        }
        if (!CollectionUtils.isEmpty((Collection)this.documentTypeDAO.findAllCurrentByName(documentType.getName()))) {
            String errorMsg = "Found invalid 'current' document with name '" + documentType.getName() + "'.  None should exist.";
            LOG.error((Object)errorMsg);
            throw new RuntimeException(errorMsg);
        }
        documentType.setPreviousVersionId(existingDocTypeId);
        documentType.setCurrentInd(Boolean.TRUE);
        this.save(documentType);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Saved current document type Id " + documentType.getDocumentTypeId() + " name '" + documentType.getName() + "' (current = " + documentType.getCurrentInd() + ")"));
        }
        if (ObjectUtils.isNotNull((Object)existingDocTypeId)) {
            for (DocumentType child : this.getChildDocumentTypes(existingDocTypeId)) {
                child.setDocTypeParentId(documentType.getDocumentTypeId());
                this.save(child);
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)("Saved child document type Id " + child.getDocumentTypeId() + " name '" + child.getName() + "' (parent = " + child.getDocTypeParentId() + ", current = " + child.getCurrentInd() + ")"));
            }
        }
        if (documentType.getDocTypeParentId() != null) {
            DocumentType parent = this.getDocumentTypeDAO().findById(documentType.getDocTypeParentId());
            this.save(parent);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Saved parent document type Id " + parent.getDocumentTypeId() + " name '" + parent.getName() + "' (current = " + parent.getCurrentInd() + ")"));
            }
        }
    }

    @Override
    public void save(DocumentType documentType) {
        this.getDocumentTypeDAO().save(documentType);
    }

    public DocumentTypeDAO getDocumentTypeDAO() {
        return this.documentTypeDAO;
    }

    public void setDocumentTypeDAO(DocumentTypeDAO documentTypeDAO) {
        this.documentTypeDAO = documentTypeDAO;
    }

    public synchronized List findAllCurrentRootDocuments() {
        return this.getDocumentTypeDAO().findAllCurrentRootDocuments();
    }

    public List findAllCurrent() {
        return this.getDocumentTypeDAO().findAllCurrent();
    }

    @Override
    public List<DocumentType> findPreviousInstances(String documentTypeName) {
        return this.getDocumentTypeDAO().findPreviousInstances(documentTypeName);
    }

    @Override
    public DocumentType findRootDocumentType(DocumentType docType) {
        if (docType.getParentDocType() != null) {
            return this.findRootDocumentType(docType.getParentDocType());
        }
        return docType;
    }

    public void loadXml(InputStream inputStream, String principalId) {
        DocumentTypeXmlParser parser = new DocumentTypeXmlParser();
        try {
            parser.parseDocumentTypes(inputStream);
        }
        catch (Exception e) {
            WorkflowServiceErrorException wsee = new WorkflowServiceErrorException("Error parsing documentType XML file", new WorkflowServiceErrorImpl("Error parsing documentType XML file", XML_FILE_PARSE_ERROR));
            wsee.initCause(e);
            throw wsee;
        }
    }

    public Element export(ExportDataSet dataSet) {
        DocumentTypeXmlExporter exporter = new DocumentTypeXmlExporter();
        return exporter.export(dataSet);
    }

    public boolean supportPrettyPrint() {
        return true;
    }

    public List getChildDocumentTypes(String documentTypeId) {
        ArrayList<DocumentType> childDocumentTypes = new ArrayList<DocumentType>();
        List<String> childIds = this.getDocumentTypeDAO().getChildDocumentTypeIds(documentTypeId);
        for (String childDocumentTypeId : childIds) {
            childDocumentTypes.add(this.findById(childDocumentTypeId));
        }
        return childDocumentTypes;
    }
}

