/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.kew.api.doctype.RouteNodeConfigurationParameterContract;
import org.kuali.rice.kew.api.doctype.RouteNodeContract;
import org.kuali.rice.kew.api.exception.ResourceUnavailableException;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.node.ActivationTypeEnum;
import org.kuali.rice.kew.engine.node.BranchPrototype;
import org.kuali.rice.kew.engine.node.NodeType;
import org.kuali.rice.kew.engine.node.RequestsNode;
import org.kuali.rice.kew.engine.node.RouteNodeConfigParam;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.rule.service.RuleTemplateService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.util.Utilities;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

@Entity
@Table(name="KREW_RTE_NODE_T")
@NamedQueries(value={@NamedQuery(name="RouteNode.FindByRouteNodeId", query="select r from RouteNode as r where r.routeNodeId = :routeNodeId"), @NamedQuery(name="RouteNode.FindRouteNodeByName", query="select r from RouteNode as r where r.routeNodeName = :routeNodeName and r.documentTypeId = :documentTypeId"), @NamedQuery(name="RouteNode.FindApprovalRouteNodes", query="select r from RouteNode as r where r.documentTypeId = :documentTypeId and r.finalApprovalInd = :finalApprovalInd")})
public class RouteNode
implements Serializable,
RouteNodeContract {
    private static final long serialVersionUID = 4891233177051752726L;
    public static final String CONTENT_FRAGMENT_CFG_KEY = "contentFragment";
    public static final String RULE_SELECTOR_CFG_KEY = "ruleSelector";
    @Id
    @GeneratedValue(generator="KREW_RTE_NODE_S")
    @GenericGenerator(name="KREW_RTE_NODE_S", strategy="org.hibernate.id.enhanced.SequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KREW_RTE_NODE_S"), @Parameter(name="value_column", value="id")})
    @Column(name="RTE_NODE_ID")
    private String routeNodeId;
    @Column(name="DOC_TYP_ID", insertable=false, updatable=false)
    private String documentTypeId;
    @Column(name="NM")
    private String routeNodeName;
    @Column(name="RTE_MTHD_NM")
    private String routeMethodName;
    @Column(name="FNL_APRVR_IND")
    private Boolean finalApprovalInd;
    @Column(name="MNDTRY_RTE_IND")
    private Boolean mandatoryRouteInd;
    @Column(name="GRP_ID")
    private String exceptionWorkgroupId;
    @Column(name="RTE_MTHD_CD")
    private String routeMethodCode;
    @Column(name="ACTVN_TYP")
    private String activationType = ActivationTypeEnum.PARALLEL.getCode();
    @Column(name="NEXT_DOC_STAT")
    private String nextDocStatus;
    @Version
    @Column(name="VER_NBR")
    private Integer lockVerNbr;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="DOC_TYP_ID")
    private DocumentType documentType;
    @Transient
    private String exceptionWorkgroupName;
    @Transient
    private RuleTemplateBo ruleTemplate;
    @Column(name="TYP")
    private String nodeType = RequestsNode.class.getName();
    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST}, mappedBy="nextNodes")
    @Fetch(value=FetchMode.SELECT)
    private List<RouteNode> previousNodes = new ArrayList<RouteNode>();
    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST})
    @Fetch(value=FetchMode.SELECT)
    @JoinTable(name="KREW_RTE_NODE_LNK_T", joinColumns={@JoinColumn(name="FROM_RTE_NODE_ID")}, inverseJoinColumns={@JoinColumn(name="TO_RTE_NODE_ID")})
    private List<RouteNode> nextNodes = new ArrayList<RouteNode>();
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="BRCH_PROTO_ID")
    private BranchPrototype branch;
    @OneToMany(fetch=FetchType.EAGER, mappedBy="routeNode", cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE})
    @Fetch(value=FetchMode.SELECT)
    private List<RouteNodeConfigParam> configParams = new ArrayList<RouteNodeConfigParam>(0);

    protected RouteNodeConfigParam getConfigParam(String key) {
        Map<String, RouteNodeConfigParam> configParamMap = Utilities.getKeyValueCollectionAsLookupTable(this.configParams);
        return configParamMap.get(key);
    }

    protected void setConfigParam(String key, String value) {
        Map<String, RouteNodeConfigParam> configParamMap = Utilities.getKeyValueCollectionAsLookupTable(this.configParams);
        RouteNodeConfigParam cfCfgParam = configParamMap.get(key);
        if (cfCfgParam == null) {
            cfCfgParam = new RouteNodeConfigParam(this, key, value);
            this.configParams.add(cfCfgParam);
        } else {
            cfCfgParam.setValue(value);
        }
    }

    public List<RouteNodeConfigParam> getConfigParams() {
        return this.configParams;
    }

    public void setConfigParams(List<RouteNodeConfigParam> configParams) {
        this.configParams = configParams;
    }

    public String getContentFragment() {
        RouteNodeConfigParam cfCfgParam = this.getConfigParam(CONTENT_FRAGMENT_CFG_KEY);
        if (cfCfgParam == null) {
            return null;
        }
        return cfCfgParam.getValue();
    }

    public void setContentFragment(String contentFragment) {
        this.setConfigParam(CONTENT_FRAGMENT_CFG_KEY, contentFragment);
    }

    public String getActivationType() {
        return this.activationType;
    }

    public void setActivationType(String activationType) {
        ActivationTypeEnum at = ActivationTypeEnum.lookupCode(activationType);
        this.activationType = at.getCode();
    }

    public Group getExceptionWorkgroup() {
        if (!StringUtils.isBlank((String)this.exceptionWorkgroupId)) {
            return KimApiServiceLocator.getGroupService().getGroup(this.exceptionWorkgroupId);
        }
        return null;
    }

    public boolean isExceptionGroupDefined() {
        return this.getExceptionWorkgroupId() != null;
    }

    public String getExceptionWorkgroupId() {
        return this.exceptionWorkgroupId;
    }

    public void setExceptionWorkgroupId(String workgroupId) {
        this.exceptionWorkgroupId = workgroupId;
    }

    public void setFinalApprovalInd(Boolean finalApprovalInd) {
        this.finalApprovalInd = finalApprovalInd;
    }

    public void setMandatoryRouteInd(Boolean mandatoryRouteInd) {
        this.mandatoryRouteInd = mandatoryRouteInd;
    }

    public String getRouteMethodName() {
        return this.routeMethodName;
    }

    public void setRouteMethodName(String routeMethodName) {
        this.routeMethodName = routeMethodName;
    }

    public String getDocumentTypeId() {
        return this.documentTypeId;
    }

    public void setDocumentTypeId(String documentTypeId) {
        this.documentTypeId = documentTypeId;
    }

    public String getRouteNodeId() {
        return this.routeNodeId;
    }

    public void setRouteNodeId(String routeNodeId) {
        this.routeNodeId = routeNodeId;
    }

    public String getRouteNodeName() {
        return this.routeNodeName;
    }

    public void setRouteNodeName(String routeLevelName) {
        this.routeNodeName = routeLevelName;
    }

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(DocumentType documentType) {
        this.documentType = documentType;
    }

    public String getRouteMethodCode() {
        return this.routeMethodCode;
    }

    public void setRouteMethodCode(String routeMethodCode) {
        this.routeMethodCode = routeMethodCode;
    }

    public void setNextDocStatus(String nextDocStatus) {
        this.nextDocStatus = nextDocStatus;
    }

    public String getNextDocStatus() {
        return this.nextDocStatus;
    }

    public String getExceptionWorkgroupName() {
        Group exceptionGroup = this.getExceptionWorkgroup();
        if ((this.exceptionWorkgroupName == null || this.exceptionWorkgroupName.equals("")) && exceptionGroup != null) {
            return exceptionGroup.getName();
        }
        return this.exceptionWorkgroupName;
    }

    public void setExceptionWorkgroupName(String exceptionWorkgroupName) {
        this.exceptionWorkgroupName = exceptionWorkgroupName;
    }

    public Integer getLockVerNbr() {
        return this.lockVerNbr;
    }

    public void setLockVerNbr(Integer lockVerNbr) {
        this.lockVerNbr = lockVerNbr;
    }

    public boolean isFlexRM() {
        return this.routeMethodCode != null && this.routeMethodCode.equals("FR");
    }

    public boolean isRulesEngineNode() {
        return StringUtils.equals((String)this.routeMethodCode, (String)"RE");
    }

    public boolean isPeopleFlowNode() {
        return StringUtils.equals((String)this.routeMethodCode, (String)"PF");
    }

    public boolean isRoleNode() {
        try {
            return this.nodeType != null && NodeType.fromNode(this).isTypeOf(NodeType.ROLE);
        }
        catch (ResourceUnavailableException ex) {
            Logger.getLogger(RouteNode.class).info((Object)("isRoleNode(): Unable to determine node type: " + ex.getMessage()));
            return false;
        }
    }

    public Boolean getFinalApprovalInd() {
        return this.finalApprovalInd;
    }

    public Boolean getMandatoryRouteInd() {
        return this.mandatoryRouteInd;
    }

    public void addNextNode(RouteNode nextNode) {
        this.getNextNodes().add(nextNode);
        nextNode.getPreviousNodes().add(this);
    }

    public List<RouteNode> getNextNodes() {
        return this.nextNodes;
    }

    public void setNextNodes(List<RouteNode> nextNodes) {
        this.nextNodes = nextNodes;
    }

    public List<RouteNode> getPreviousNodes() {
        return this.previousNodes;
    }

    public void setPreviousNodes(List<RouteNode> parentNodes) {
        this.previousNodes = parentNodes;
    }

    public RuleTemplateBo getRuleTemplate() {
        if (this.ruleTemplate == null) {
            RuleTemplateService ruleTemplateService = (RuleTemplateService)KEWServiceLocator.getService("enRuleTemplateService");
            this.ruleTemplate = ruleTemplateService.findByRuleTemplateName(this.getRouteMethodName());
        }
        return this.ruleTemplate;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public BranchPrototype getBranch() {
        return this.branch;
    }

    public void setBranch(BranchPrototype branch) {
        this.branch = branch;
    }

    public void beforeInsert() {
        OrmUtils.populateAutoIncValue((Object)this, (EntityManager)KEWServiceLocator.getEntityManagerFactory().createEntityManager());
    }

    public String toString() {
        return "RouteNode[routeNodeName=" + this.routeNodeName + ", nodeType=" + this.nodeType + ", activationType=" + this.activationType + "]";
    }

    public Long getVersionNumber() {
        if (this.lockVerNbr == null) {
            return null;
        }
        return this.lockVerNbr.longValue();
    }

    public String getId() {
        if (this.routeNodeId == null) {
            return null;
        }
        return this.routeNodeId.toString();
    }

    public String getName() {
        return this.getRouteNodeName();
    }

    public boolean isFinalApproval() {
        if (this.finalApprovalInd == null) {
            return false;
        }
        return this.finalApprovalInd;
    }

    public boolean isMandatory() {
        if (this.mandatoryRouteInd == null) {
            return false;
        }
        return this.mandatoryRouteInd;
    }

    public String getExceptionGroupId() {
        return this.exceptionWorkgroupId;
    }

    public String getType() {
        return this.nodeType;
    }

    public String getBranchName() {
        if (this.branch == null) {
            return null;
        }
        return this.branch.getName();
    }

    public String getNextDocumentStatus() {
        return this.nextDocStatus;
    }

    public List<? extends RouteNodeConfigurationParameterContract> getConfigurationParameters() {
        return this.configParams;
    }

    public List<String> getPreviousNodeIds() {
        ArrayList<String> previousNodeIds = new ArrayList<String>();
        if (this.previousNodes != null) {
            for (RouteNode previousNode : this.previousNodes) {
                previousNodeIds.add(previousNode.getRouteNodeId().toString());
            }
        }
        return previousNodeIds;
    }

    public List<String> getNextNodeIds() {
        ArrayList<String> nextNodeIds = new ArrayList<String>();
        if (nextNodeIds != null) {
            for (RouteNode nextNode : this.nextNodes) {
                nextNodeIds.add(nextNode.getRouteNodeId().toString());
            }
        }
        return nextNodeIds;
    }
}

