/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.document;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.uif.RemotableAttributeErrorContract;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.action.ActionTaken;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.action.AdHocRevoke;
import org.kuali.rice.kew.api.action.AdHocToGroup;
import org.kuali.rice.kew.api.action.AdHocToPrincipal;
import org.kuali.rice.kew.api.action.DocumentActionParameters;
import org.kuali.rice.kew.api.action.DocumentActionResult;
import org.kuali.rice.kew.api.action.MovePoint;
import org.kuali.rice.kew.api.action.RequestedActions;
import org.kuali.rice.kew.api.action.ReturnPoint;
import org.kuali.rice.kew.api.action.ValidActions;
import org.kuali.rice.kew.api.action.WorkflowDocumentActionsService;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.document.DocumentContent;
import org.kuali.rice.kew.api.document.DocumentContentContract;
import org.kuali.rice.kew.api.document.DocumentContentUpdate;
import org.kuali.rice.kew.api.document.DocumentContract;
import org.kuali.rice.kew.api.document.DocumentDetail;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.document.DocumentUpdate;
import org.kuali.rice.kew.api.document.WorkflowDocumentService;
import org.kuali.rice.kew.api.document.attribute.WorkflowAttributeDefinition;
import org.kuali.rice.kew.api.document.node.RouteNodeInstance;
import org.kuali.rice.kew.impl.document.WorkflowDocumentPrototype;

public class WorkflowDocumentImpl
implements Serializable,
WorkflowDocumentPrototype {
    private static final long serialVersionUID = -3672966990721719088L;
    private String principalId;
    private ModifiableDocument modifiableDocument;
    private ModifiableDocumentContent modifiableDocumentContent;
    private ValidActions validActions;
    private RequestedActions requestedActions;
    private boolean documentDeleted = false;
    private transient WorkflowDocumentActionsService workflowDocumentActionsService;
    private transient WorkflowDocumentService workflowDocumentService;

    @Override
    public void init(String principalId, Document document) {
        if (StringUtils.isBlank((String)"principalId")) {
            throw new IllegalArgumentException("principalId was null or blank");
        }
        if (document == null) {
            throw new IllegalArgumentException("document was null");
        }
        this.principalId = principalId;
        this.modifiableDocument = new ModifiableDocument(document);
        this.modifiableDocumentContent = null;
        this.validActions = null;
        this.requestedActions = null;
    }

    public WorkflowDocumentActionsService getWorkflowDocumentActionsService() {
        if (this.workflowDocumentActionsService == null) {
            this.workflowDocumentActionsService = KewApiServiceLocator.getWorkflowDocumentActionsService();
        }
        return this.workflowDocumentActionsService;
    }

    public void setWorkflowDocumentActionsService(WorkflowDocumentActionsService workflowDocumentActionsService) {
        this.workflowDocumentActionsService = workflowDocumentActionsService;
    }

    public WorkflowDocumentService getWorkflowDocumentService() {
        if (this.workflowDocumentService == null) {
            this.workflowDocumentService = KewApiServiceLocator.getWorkflowDocumentService();
        }
        return this.workflowDocumentService;
    }

    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }

    protected ModifiableDocument getModifiableDocument() {
        return this.modifiableDocument;
    }

    protected ModifiableDocumentContent getModifiableDocumentContent() {
        if (this.modifiableDocumentContent == null) {
            DocumentContent documentContent = this.getWorkflowDocumentService().getDocumentContent(this.getDocumentId());
            if (documentContent == null) {
                throw new IllegalStateException("Failed to load document content for documentId: " + this.getDocumentId());
            }
            this.modifiableDocumentContent = new ModifiableDocumentContent(documentContent);
        }
        return this.modifiableDocumentContent;
    }

    public String getDocumentId() {
        if (this.documentDeleted) {
            throw new IllegalStateException("Document has been deleted.");
        }
        return this.getModifiableDocument().getDocumentId();
    }

    public Document getDocument() {
        return this.getModifiableDocument().getDocument();
    }

    public DocumentContent getDocumentContent() {
        return this.getModifiableDocumentContent().getDocumentContent();
    }

    public String getApplicationContent() {
        return this.getDocumentContent().getApplicationContent();
    }

    public void setApplicationContent(String applicationContent) {
        this.getModifiableDocumentContent().setApplicationContent(applicationContent);
    }

    public void setAttributeContent(String attributeContent) {
        this.getModifiableDocumentContent().setAttributeContent(attributeContent);
    }

    public void clearAttributeContent() {
        this.getModifiableDocumentContent().setAttributeContent("");
    }

    public String getAttributeContent() {
        return this.getDocumentContent().getAttributeContent();
    }

    public void addAttributeDefinition(WorkflowAttributeDefinition attributeDefinition) {
        this.getModifiableDocumentContent().addAttributeDefinition(attributeDefinition);
    }

    public void removeAttributeDefinition(WorkflowAttributeDefinition attributeDefinition) {
        this.getModifiableDocumentContent().removeAttributeDefinition(attributeDefinition);
    }

    public void clearAttributeDefinitions() {
        this.getAttributeDefinitions().clear();
    }

    public List<WorkflowAttributeDefinition> getAttributeDefinitions() {
        return this.getModifiableDocumentContent().getAttributeDefinitions();
    }

    public void setSearchableContent(String searchableContent) {
        this.getModifiableDocumentContent().setSearchableContent(searchableContent);
    }

    public void addSearchableDefinition(WorkflowAttributeDefinition searchableDefinition) {
        this.getModifiableDocumentContent().addSearchableDefinition(searchableDefinition);
    }

    public void removeSearchableDefinition(WorkflowAttributeDefinition searchableDefinition) {
        this.getModifiableDocumentContent().removeSearchableDefinition(searchableDefinition);
    }

    public void clearSearchableDefinitions() {
        this.getSearchableDefinitions().clear();
    }

    public void clearSearchableContent() {
        this.getModifiableDocumentContent().setSearchableContent("");
    }

    public List<WorkflowAttributeDefinition> getSearchableDefinitions() {
        return this.getModifiableDocumentContent().getSearchableDefinitions();
    }

    public List<? extends RemotableAttributeErrorContract> validateAttributeDefinition(WorkflowAttributeDefinition attributeDefinition) {
        return this.getWorkflowDocumentActionsService().validateWorkflowAttributeDefinition(attributeDefinition);
    }

    public List<ActionRequest> getRootActionRequests() {
        return this.getWorkflowDocumentService().getRootActionRequests(this.getDocumentId());
    }

    public List<ActionTaken> getActionsTaken() {
        return this.getWorkflowDocumentService().getActionsTaken(this.getDocumentId());
    }

    public void setApplicationDocumentId(String applicationDocumentId) {
        this.getModifiableDocument().setApplicationDocumentId(applicationDocumentId);
    }

    public String getApplicationDocumentId() {
        return this.getModifiableDocument().getApplicationDocumentId();
    }

    public DateTime getDateCreated() {
        return this.getModifiableDocument().getDateCreated();
    }

    public String getTitle() {
        return this.getModifiableDocument().getTitle();
    }

    public ValidActions getValidActions() {
        if (this.validActions == null) {
            this.validActions = this.getWorkflowDocumentActionsService().determineValidActions(this.getDocumentId(), this.getPrincipalId());
        }
        return this.validActions;
    }

    public RequestedActions getRequestedActions() {
        if (this.requestedActions == null) {
            this.requestedActions = this.getWorkflowDocumentActionsService().determineRequestedActions(this.getDocumentId(), this.getPrincipalId());
        }
        return this.requestedActions;
    }

    protected DocumentUpdate getDocumentUpdateIfDirty() {
        if (this.getModifiableDocument().isDirty()) {
            return this.getModifiableDocument().build();
        }
        return null;
    }

    protected DocumentContentUpdate getDocumentContentUpdateIfDirty() {
        if (this.getModifiableDocumentContent().isDirty()) {
            return this.getModifiableDocumentContent().build();
        }
        return null;
    }

    protected void resetStateAfterAction(DocumentActionResult response) {
        this.modifiableDocument = new ModifiableDocument(response.getDocument());
        this.validActions = null;
        if (response.getValidActions() != null) {
            this.validActions = response.getValidActions();
        }
        this.requestedActions = null;
        if (response.getRequestedActions() != null) {
            this.requestedActions = response.getRequestedActions();
        }
        this.modifiableDocumentContent = null;
    }

    public void saveDocument(String annotation) {
        DocumentActionResult result = this.getWorkflowDocumentActionsService().save(this.constructDocumentActionParameters(annotation));
        this.resetStateAfterAction(result);
    }

    public void route(String annotation) {
        DocumentActionResult result = this.getWorkflowDocumentActionsService().route(this.constructDocumentActionParameters(annotation));
        this.resetStateAfterAction(result);
    }

    public void disapprove(String annotation) {
        DocumentActionResult result = this.getWorkflowDocumentActionsService().disapprove(this.constructDocumentActionParameters(annotation));
        this.resetStateAfterAction(result);
    }

    public void approve(String annotation) {
        DocumentActionResult result = this.getWorkflowDocumentActionsService().approve(this.constructDocumentActionParameters(annotation));
        this.resetStateAfterAction(result);
    }

    public void cancel(String annotation) {
        DocumentActionResult result = this.getWorkflowDocumentActionsService().cancel(this.constructDocumentActionParameters(annotation));
        this.resetStateAfterAction(result);
    }

    public void recall(String annotation, boolean cancel) {
        DocumentActionResult result = this.getWorkflowDocumentActionsService().recall(this.constructDocumentActionParameters(annotation), cancel);
        this.resetStateAfterAction(result);
    }

    public void blanketApprove(String annotation) {
        DocumentActionResult result = this.getWorkflowDocumentActionsService().blanketApprove(this.constructDocumentActionParameters(annotation));
        this.resetStateAfterAction(result);
    }

    public void blanketApprove(String annotation, String ... nodeNames) {
        if (nodeNames == null) {
            throw new IllegalArgumentException("nodeNames was null");
        }
        HashSet<String> nodeNamesSet = new HashSet<String>(Arrays.asList(nodeNames));
        DocumentActionResult result = this.getWorkflowDocumentActionsService().blanketApproveToNodes(this.constructDocumentActionParameters(annotation), nodeNamesSet);
        this.resetStateAfterAction(result);
    }

    public void saveDocumentData() {
        DocumentActionResult result = this.getWorkflowDocumentActionsService().saveDocumentData(this.constructDocumentActionParameters(null));
        this.resetStateAfterAction(result);
    }

    public void setApplicationDocumentStatus(String applicationDocumentStatus) {
        this.getModifiableDocument().setApplicationDocumentStatus(applicationDocumentStatus);
    }

    public void acknowledge(String annotation) {
        DocumentActionResult result = this.getWorkflowDocumentActionsService().acknowledge(this.constructDocumentActionParameters(annotation));
        this.resetStateAfterAction(result);
    }

    public void fyi(String annotation) {
        DocumentActionResult result = this.getWorkflowDocumentActionsService().clearFyi(this.constructDocumentActionParameters(annotation));
        this.resetStateAfterAction(result);
    }

    public void fyi() {
        this.fyi("");
    }

    public void delete() {
        this.getWorkflowDocumentActionsService().delete(this.getDocumentId(), this.principalId);
        this.documentDeleted = true;
    }

    public void refresh() {
        Document document = this.getWorkflowDocumentService().getDocument(this.getDocumentId());
        this.modifiableDocument = new ModifiableDocument(document);
        this.validActions = null;
        this.requestedActions = null;
        this.modifiableDocumentContent = null;
    }

    public void adHocToPrincipal(ActionRequestType actionRequested, String annotation, String targetPrincipalId, String responsibilityDescription, boolean forceAction) {
        this.adHocToPrincipal(actionRequested, null, annotation, targetPrincipalId, responsibilityDescription, forceAction);
    }

    public void adHocToPrincipal(ActionRequestType actionRequested, String nodeName, String annotation, String targetPrincipalId, String responsibilityDescription, boolean forceAction) {
        this.adHocToPrincipal(actionRequested, nodeName, annotation, targetPrincipalId, responsibilityDescription, forceAction, null);
    }

    public void adHocToPrincipal(ActionRequestType actionRequested, String nodeName, String annotation, String targetPrincipalId, String responsibilityDescription, boolean forceAction, String requestLabel) {
        AdHocToPrincipal.Builder builder = AdHocToPrincipal.Builder.create((ActionRequestType)actionRequested, (String)nodeName, (String)targetPrincipalId);
        builder.setResponsibilityDescription(responsibilityDescription);
        builder.setForceAction(forceAction);
        builder.setRequestLabel(requestLabel);
        DocumentActionResult result = this.getWorkflowDocumentActionsService().adHocToPrincipal(this.constructDocumentActionParameters(annotation), builder.build());
        this.resetStateAfterAction(result);
    }

    public void adHocToPrincipal(AdHocToPrincipal adHocToPrincipal, String annotation) {
        DocumentActionResult result = this.getWorkflowDocumentActionsService().adHocToPrincipal(this.constructDocumentActionParameters(annotation), adHocToPrincipal);
        this.resetStateAfterAction(result);
    }

    public void adHocToGroup(ActionRequestType actionRequested, String annotation, String targetGroupId, String responsibilityDescription, boolean forceAction) {
        this.adHocToGroup(actionRequested, null, annotation, targetGroupId, responsibilityDescription, forceAction);
    }

    public void adHocToGroup(ActionRequestType actionRequested, String nodeName, String annotation, String targetGroupId, String responsibilityDescription, boolean forceAction) {
        this.adHocToGroup(actionRequested, nodeName, annotation, targetGroupId, responsibilityDescription, forceAction, null);
    }

    public void adHocToGroup(ActionRequestType actionRequested, String nodeName, String annotation, String targetGroupId, String responsibilityDescription, boolean forceAction, String requestLabel) {
        AdHocToGroup.Builder builder = AdHocToGroup.Builder.create((ActionRequestType)actionRequested, (String)nodeName, (String)targetGroupId);
        builder.setResponsibilityDescription(responsibilityDescription);
        builder.setForceAction(forceAction);
        builder.setRequestLabel(requestLabel);
        DocumentActionResult result = this.getWorkflowDocumentActionsService().adHocToGroup(this.constructDocumentActionParameters(annotation), builder.build());
        this.resetStateAfterAction(result);
    }

    public void adHocToGroup(AdHocToGroup adHocToGroup, String annotation) {
        DocumentActionResult result = this.getWorkflowDocumentActionsService().adHocToGroup(this.constructDocumentActionParameters(annotation), adHocToGroup);
        this.resetStateAfterAction(result);
    }

    public void revokeAdHocRequestById(String actionRequestId, String annotation) {
        if (StringUtils.isBlank((String)actionRequestId)) {
            throw new IllegalArgumentException("actionRequestId was null or blank");
        }
        DocumentActionResult result = this.getWorkflowDocumentActionsService().revokeAdHocRequestById(this.constructDocumentActionParameters(annotation), actionRequestId);
        this.resetStateAfterAction(result);
    }

    public void revokeAdHocRequests(AdHocRevoke revoke, String annotation) {
        if (revoke == null) {
            throw new IllegalArgumentException("revokeFromPrincipal was null");
        }
        DocumentActionResult result = this.getWorkflowDocumentActionsService().revokeAdHocRequests(this.constructDocumentActionParameters(annotation), revoke);
        this.resetStateAfterAction(result);
    }

    public void revokeAllAdHocRequests(String annotation) {
        DocumentActionResult result = this.getWorkflowDocumentActionsService().revokeAllAdHocRequests(this.constructDocumentActionParameters(annotation));
        this.resetStateAfterAction(result);
    }

    public void setTitle(String title) {
        this.getModifiableDocument().setTitle(title);
    }

    public String getDocumentTypeName() {
        return this.getDocument().getDocumentTypeName();
    }

    public boolean isCompletionRequested() {
        return this.getRequestedActions().isCompleteRequested();
    }

    public boolean isApprovalRequested() {
        return this.getRequestedActions().isApproveRequested();
    }

    public boolean isAcknowledgeRequested() {
        return this.getRequestedActions().isAcknowledgeRequested();
    }

    public boolean isFYIRequested() {
        return this.getRequestedActions().isFyiRequested();
    }

    public boolean isBlanketApproveCapable() {
        return this.isValidAction(ActionType.BLANKET_APPROVE) && (this.isCompletionRequested() || this.isApprovalRequested() || this.isInitiated());
    }

    public boolean isRouteCapable() {
        return this.isValidAction(ActionType.ROUTE);
    }

    public boolean isValidAction(ActionType actionType) {
        if (actionType == null) {
            throw new IllegalArgumentException("actionType was null");
        }
        return this.getValidActions().getValidActions().contains(actionType);
    }

    public void superUserBlanketApprove(String annotation) {
        DocumentActionResult result = this.getWorkflowDocumentActionsService().superUserBlanketApprove(this.constructDocumentActionParameters(annotation), true);
        this.resetStateAfterAction(result);
    }

    public void superUserNodeApprove(String nodeName, String annotation) {
        DocumentActionResult result = this.getWorkflowDocumentActionsService().superUserNodeApprove(this.constructDocumentActionParameters(annotation), true, nodeName);
        this.resetStateAfterAction(result);
    }

    public void superUserTakeRequestedAction(String actionRequestId, String annotation) {
        DocumentActionResult result = this.getWorkflowDocumentActionsService().superUserTakeRequestedAction(this.constructDocumentActionParameters(annotation), true, actionRequestId);
        this.resetStateAfterAction(result);
    }

    public void superUserDisapprove(String annotation) {
        DocumentActionResult result = this.getWorkflowDocumentActionsService().superUserDisapprove(this.constructDocumentActionParameters(annotation), true);
        this.resetStateAfterAction(result);
    }

    public void superUserCancel(String annotation) {
        DocumentActionResult result = this.getWorkflowDocumentActionsService().superUserCancel(this.constructDocumentActionParameters(annotation), true);
        this.resetStateAfterAction(result);
    }

    public void superUserReturnToPreviousNode(ReturnPoint returnPoint, String annotation) {
        DocumentActionResult result = this.getWorkflowDocumentActionsService().superUserReturnToPreviousNode(this.constructDocumentActionParameters(annotation), true, returnPoint);
        this.resetStateAfterAction(result);
    }

    public void complete(String annotation) {
        DocumentActionResult result = this.getWorkflowDocumentActionsService().complete(this.constructDocumentActionParameters(annotation));
        this.resetStateAfterAction(result);
    }

    public void logAnnotation(String annotation) {
        this.getWorkflowDocumentActionsService().logAnnotation(this.getDocumentId(), this.principalId, annotation);
    }

    public DocumentStatus getStatus() {
        return this.getDocument().getStatus();
    }

    public boolean checkStatus(DocumentStatus status) {
        if (status == null) {
            throw new IllegalArgumentException("status was null");
        }
        return status == this.getStatus();
    }

    public boolean isInitiated() {
        return this.checkStatus(DocumentStatus.INITIATED);
    }

    public boolean isSaved() {
        return this.checkStatus(DocumentStatus.SAVED);
    }

    public boolean isEnroute() {
        return this.checkStatus(DocumentStatus.ENROUTE);
    }

    public boolean isException() {
        return this.checkStatus(DocumentStatus.EXCEPTION);
    }

    public boolean isCanceled() {
        return this.checkStatus(DocumentStatus.CANCELED);
    }

    public boolean isRecalled() {
        return this.checkStatus(DocumentStatus.RECALLED);
    }

    public boolean isDisapproved() {
        return this.checkStatus(DocumentStatus.DISAPPROVED);
    }

    public boolean isApproved() {
        return this.isProcessed() || this.isFinal();
    }

    public boolean isProcessed() {
        return this.checkStatus(DocumentStatus.PROCESSED);
    }

    public boolean isFinal() {
        return this.checkStatus(DocumentStatus.FINAL);
    }

    public String getPrincipalId() {
        return this.principalId;
    }

    public void switchPrincipal(String principalId) {
        if (StringUtils.isBlank((String)this.principalId)) {
            throw new IllegalArgumentException("principalId was null or blank");
        }
        this.principalId = principalId;
        this.validActions = null;
        this.requestedActions = null;
    }

    public void takeGroupAuthority(String annotation, String groupId) {
        DocumentActionResult result = this.getWorkflowDocumentActionsService().takeGroupAuthority(this.constructDocumentActionParameters(annotation), groupId);
        this.resetStateAfterAction(result);
    }

    public void releaseGroupAuthority(String annotation, String groupId) {
        DocumentActionResult result = this.getWorkflowDocumentActionsService().releaseGroupAuthority(this.constructDocumentActionParameters(annotation), groupId);
        this.resetStateAfterAction(result);
    }

    public Set<String> getNodeNames() {
        List names = this.getWorkflowDocumentService().getActiveRouteNodeNames(this.getDocumentId());
        return Collections.unmodifiableSet(new HashSet(names));
    }

    public Set<String> getCurrentNodeNames() {
        List names = this.getWorkflowDocumentService().getCurrentRouteNodeNames(this.getDocumentId());
        return Collections.unmodifiableSet(new HashSet(names));
    }

    public void returnToPreviousNode(String annotation, String nodeName) {
        if (nodeName == null) {
            throw new IllegalArgumentException("nodeName was null");
        }
        this.returnToPreviousNode(annotation, ReturnPoint.create((String)nodeName));
    }

    public void returnToPreviousNode(String annotation, ReturnPoint returnPoint) {
        if (returnPoint == null) {
            throw new IllegalArgumentException("returnPoint was null");
        }
        DocumentActionResult result = this.getWorkflowDocumentActionsService().returnToPreviousNode(this.constructDocumentActionParameters(annotation), returnPoint);
        this.resetStateAfterAction(result);
    }

    public void move(MovePoint movePoint, String annotation) {
        if (movePoint == null) {
            throw new IllegalArgumentException("movePoint was null");
        }
        DocumentActionResult result = this.getWorkflowDocumentActionsService().move(this.constructDocumentActionParameters(annotation), movePoint);
        this.resetStateAfterAction(result);
    }

    public List<RouteNodeInstance> getActiveRouteNodeInstances() {
        return this.getWorkflowDocumentService().getActiveRouteNodeInstances(this.getDocumentId());
    }

    public List<RouteNodeInstance> getCurrentRouteNodeInstances() {
        return this.getWorkflowDocumentService().getCurrentRouteNodeInstances(this.getDocumentId());
    }

    public List<RouteNodeInstance> getRouteNodeInstances() {
        return this.getWorkflowDocumentService().getRouteNodeInstances(this.getDocumentId());
    }

    public List<String> getPreviousNodeNames() {
        return this.getWorkflowDocumentService().getPreviousRouteNodeNames(this.getDocumentId());
    }

    public DocumentDetail getDocumentDetail() {
        return this.getWorkflowDocumentService().getDocumentDetail(this.getDocumentId());
    }

    public void updateDocumentContent(DocumentContentUpdate documentContentUpdate) {
        if (documentContentUpdate == null) {
            throw new IllegalArgumentException("documentContentUpdate was null.");
        }
        this.getModifiableDocumentContent().setDocumentContentUpdate(documentContentUpdate);
    }

    public void placeInExceptionRouting(String annotation) {
        DocumentActionResult result = this.getWorkflowDocumentActionsService().placeInExceptionRouting(this.constructDocumentActionParameters(annotation));
        this.resetStateAfterAction(result);
    }

    public void setVariable(String name, String value) {
        this.getModifiableDocument().setVariable(name, value);
    }

    public String getVariableValue(String name) {
        return this.getModifiableDocument().getVariableValue(name);
    }

    public void setReceiveFutureRequests() {
        this.setVariable(this.getFutureRequestsKey(this.principalId), this.getReceiveFutureRequestsValue());
    }

    public void setDoNotReceiveFutureRequests() {
        this.setVariable(this.getFutureRequestsKey(this.principalId), this.getDoNotReceiveFutureRequestsValue());
    }

    public void setClearFutureRequests() {
        this.setVariable(this.getFutureRequestsKey(this.principalId), this.getClearFutureRequestsValue());
    }

    protected String getFutureRequestsKey(String principalId) {
        return "_receive_future_requests," + principalId + "," + new Date().toString() + ", " + Math.random();
    }

    public String getReceiveFutureRequestsValue() {
        return "YES";
    }

    public String getDoNotReceiveFutureRequestsValue() {
        return "NO";
    }

    public String getClearFutureRequestsValue() {
        return "CLEAR";
    }

    protected DocumentActionParameters constructDocumentActionParameters(String annotation) {
        DocumentActionParameters.Builder builder = DocumentActionParameters.Builder.create((String)this.getDocumentId(), (String)this.getPrincipalId());
        builder.setAnnotation(annotation);
        builder.setDocumentUpdate(this.getDocumentUpdateIfDirty());
        builder.setDocumentContentUpdate(this.getDocumentContentUpdateIfDirty());
        return builder.build();
    }

    public DateTime getDateLastModified() {
        return this.getDocument().getDateLastModified();
    }

    public DateTime getDateApproved() {
        return this.getDocument().getDateApproved();
    }

    public DateTime getDateFinalized() {
        return this.getDocument().getDateFinalized();
    }

    public String getInitiatorPrincipalId() {
        return this.getDocument().getInitiatorPrincipalId();
    }

    public String getRoutedByPrincipalId() {
        return this.getDocument().getRoutedByPrincipalId();
    }

    public String getDocumentTypeId() {
        return this.getDocument().getDocumentTypeId();
    }

    public String getDocumentHandlerUrl() {
        return this.getDocument().getDocumentHandlerUrl();
    }

    public String getApplicationDocumentStatus() {
        return this.getDocument().getApplicationDocumentStatus();
    }

    public DateTime getApplicationDocumentStatusDate() {
        return this.getDocument().getApplicationDocumentStatusDate();
    }

    public Map<String, String> getVariables() {
        return this.getDocument().getVariables();
    }

    protected static class ModifiableDocument
    implements Serializable {
        private static final long serialVersionUID = -3234793238863410378L;
        private boolean dirty = false;
        private Document originalDocument;
        private DocumentUpdate.Builder builder;

        protected ModifiableDocument(Document document) {
            this.originalDocument = document;
            this.builder = DocumentUpdate.Builder.create((Document)document);
        }

        protected Document getDocument() {
            if (!this.dirty) {
                return this.originalDocument;
            }
            Document.Builder documentBuilder = Document.Builder.create((DocumentContract)this.originalDocument);
            documentBuilder.setApplicationDocumentId(this.builder.getApplicationDocumentId());
            documentBuilder.setTitle(this.builder.getTitle());
            documentBuilder.setApplicationDocumentStatus(this.builder.getApplicationDocumentStatus());
            documentBuilder.setVariables(this.builder.getVariables());
            return documentBuilder.build();
        }

        protected DocumentUpdate build() {
            return this.builder.build();
        }

        protected String getDocumentId() {
            return this.originalDocument.getDocumentId();
        }

        protected DateTime getDateCreated() {
            return this.originalDocument.getDateCreated();
        }

        protected String getApplicationDocumentId() {
            return this.builder.getApplicationDocumentId();
        }

        protected void setApplicationDocumentId(String applicationDocumentId) {
            this.builder.setApplicationDocumentId(applicationDocumentId);
            this.dirty = true;
        }

        protected String getTitle() {
            return this.builder.getTitle();
        }

        protected void setTitle(String title) {
            this.builder.setTitle(title);
            this.dirty = true;
        }

        protected String getApplicationDocumentStatus() {
            return this.builder.getApplicationDocumentStatus();
        }

        protected void setApplicationDocumentStatus(String applicationDocumentStatus) {
            this.builder.setApplicationDocumentStatus(applicationDocumentStatus);
            this.dirty = true;
        }

        protected void setVariable(String name, String value) {
            this.builder.setVariable(name, value);
            this.dirty = true;
        }

        protected String getVariableValue(String name) {
            return this.builder.getVariableValue(name);
        }

        boolean isDirty() {
            return this.dirty;
        }
    }

    protected static class ModifiableDocumentContent
    implements Serializable {
        private static final long serialVersionUID = -4458431160327214042L;
        private boolean dirty = false;
        private DocumentContent originalDocumentContent;
        private DocumentContentUpdate.Builder builder;

        protected ModifiableDocumentContent(DocumentContent documentContent) {
            this.originalDocumentContent = documentContent;
            this.builder = DocumentContentUpdate.Builder.create((DocumentContent)documentContent);
        }

        protected DocumentContent getDocumentContent() {
            if (!this.dirty) {
                return this.originalDocumentContent;
            }
            DocumentContent.Builder documentContentBuilder = DocumentContent.Builder.create((DocumentContentContract)this.originalDocumentContent);
            documentContentBuilder.setApplicationContent(this.builder.getApplicationContent());
            documentContentBuilder.setAttributeContent(this.builder.getAttributeContent());
            documentContentBuilder.setSearchableContent(this.builder.getSearchableContent());
            return documentContentBuilder.build();
        }

        protected DocumentContentUpdate build() {
            return this.builder.build();
        }

        protected void setDocumentContentUpdate(DocumentContentUpdate update) {
            this.builder = DocumentContentUpdate.Builder.create((DocumentContentUpdate)update);
            this.dirty = true;
        }

        protected void addAttributeDefinition(WorkflowAttributeDefinition definition) {
            this.builder.getAttributeDefinitions().add(definition);
            this.dirty = true;
        }

        protected void removeAttributeDefinition(WorkflowAttributeDefinition definition) {
            this.builder.getAttributeDefinitions().remove(definition);
            this.dirty = true;
        }

        protected List<WorkflowAttributeDefinition> getAttributeDefinitions() {
            return this.builder.getAttributeDefinitions();
        }

        protected void addSearchableDefinition(WorkflowAttributeDefinition definition) {
            this.builder.getSearchableDefinitions().add(definition);
            this.dirty = true;
        }

        protected void removeSearchableDefinition(WorkflowAttributeDefinition definition) {
            this.builder.getSearchableDefinitions().remove(definition);
            this.dirty = true;
        }

        protected List<WorkflowAttributeDefinition> getSearchableDefinitions() {
            return this.builder.getAttributeDefinitions();
        }

        protected void setApplicationContent(String applicationContent) {
            this.builder.setApplicationContent(applicationContent);
            this.dirty = true;
        }

        protected void setAttributeContent(String attributeContent) {
            this.builder.setAttributeContent(attributeContent);
            this.dirty = true;
        }

        public void setAttributeDefinitions(List<WorkflowAttributeDefinition> attributeDefinitions) {
            this.builder.setAttributeDefinitions(attributeDefinitions);
            this.dirty = true;
        }

        public void setSearchableContent(String searchableContent) {
            this.builder.setSearchableContent(searchableContent);
            this.dirty = true;
        }

        public void setSearchableDefinitions(List<WorkflowAttributeDefinition> searchableDefinitions) {
            this.builder.setSearchableDefinitions(searchableDefinitions);
            this.dirty = true;
        }

        boolean isDirty() {
            return this.dirty;
        }
    }
}

