/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.messaging.exceptionhandling;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionrequest.ActionRequestFactory;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.KimGroupRecipient;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.action.ActionRequestStatus;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.exception.RouteManagerException;
import org.kuali.rice.kew.exception.WorkflowDocumentExceptionRoutingService;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kew.framework.postprocessor.PostProcessor;
import org.kuali.rice.kew.framework.postprocessor.ProcessDocReport;
import org.kuali.rice.kew.role.RoleRouteModule;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.util.PerformanceLogger;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.service.KSBServiceLocator;

public class ExceptionRoutingServiceImpl
implements WorkflowDocumentExceptionRoutingService {
    private static final Logger LOG = Logger.getLogger(ExceptionRoutingServiceImpl.class);

    @Override
    public void placeInExceptionRouting(String errorMessage, PersistedMessageBO persistedMessage, String documentId) throws Exception {
        RouteNodeInstance nodeInstance = null;
        KEWServiceLocator.getRouteHeaderService().lockRouteHeader(documentId, true);
        DocumentRouteHeaderValue document = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId);
        RouteContext routeContext = this.establishRouteContext(document, null);
        List<RouteNodeInstance> activeNodeInstances = KEWServiceLocator.getRouteNodeService().getActiveNodeInstances(documentId);
        if (!activeNodeInstances.isEmpty()) {
            nodeInstance = activeNodeInstances.get(0);
        }
        this.placeInExceptionRouting(errorMessage, nodeInstance, persistedMessage, routeContext, document, true);
    }

    @Override
    public void placeInExceptionRouting(Throwable throwable, PersistedMessageBO persistedMessage, String documentId) throws Exception {
        this.placeInExceptionRouting(throwable, persistedMessage, documentId, true);
    }

    @Override
    public void placeInExceptionRoutingLastDitchEffort(Throwable throwable, PersistedMessageBO persistedMessage, String documentId) throws Exception {
        this.placeInExceptionRouting(throwable, persistedMessage, documentId, false);
    }

    protected void placeInExceptionRouting(Throwable throwable, PersistedMessageBO persistedMessage, String documentId, boolean invokePostProcessor) throws Exception {
        KEWServiceLocator.getRouteHeaderService().lockRouteHeader(documentId, true);
        DocumentRouteHeaderValue document = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId);
        throwable = this.unwrapRouteManagerExceptionIfPossible(throwable);
        RouteContext routeContext = this.establishRouteContext(document, throwable);
        RouteNodeInstance nodeInstance = routeContext.getNodeInstance();
        Throwable cause = this.determineActualCause(throwable, 0);
        String errorMessage = cause != null && cause.getMessage() != null ? cause.getMessage() : "";
        this.placeInExceptionRouting(errorMessage, nodeInstance, persistedMessage, routeContext, document, invokePostProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void placeInExceptionRouting(String errorMessage, RouteNodeInstance nodeInstance, PersistedMessageBO persistedMessage, RouteContext routeContext, DocumentRouteHeaderValue document, boolean invokePostProcessor) throws Exception {
        String documentId = document.getDocumentId();
        MDC.put((String)"docId", (Object)documentId);
        PerformanceLogger performanceLogger = new PerformanceLogger(documentId);
        try {
            List<ActionRequestValue> actionRequests = KEWServiceLocator.getActionRequestService().findPendingByDoc(documentId);
            for (ActionRequestValue actionRequest : actionRequests) {
                if (!actionRequest.isActive()) continue;
                actionRequest.setStatus(ActionRequestStatus.INITIALIZED.getCode());
                for (ActionItem actionItem : actionRequest.getActionItems()) {
                    KEWServiceLocator.getActionListService().deleteActionItem(actionItem);
                }
                KEWServiceLocator.getActionRequestService().saveActionRequest(actionRequest);
            }
            LOG.debug((Object)("Generating exception request for doc : " + documentId));
            if (errorMessage == null) {
                errorMessage = "";
            }
            if (errorMessage.length() > 2000) {
                errorMessage = errorMessage.substring(0, 2000);
            }
            List<Object> exceptionRequests = new ArrayList();
            exceptionRequests = nodeInstance.getRouteNode().isExceptionGroupDefined() ? this.generateExceptionGroupRequests(routeContext) : this.generateKimExceptionRequests(routeContext);
            if (exceptionRequests.isEmpty()) {
                LOG.warn((Object)"Failed to generate exception requests for exception routing!");
            }
            this.activateExceptionRequests(routeContext, exceptionRequests, errorMessage, invokePostProcessor);
            if (persistedMessage == null) {
                LOG.warn((Object)"Attempting to delete null persisted message.");
            } else {
                KSBServiceLocator.getMessageQueueService().delete(persistedMessage);
            }
        }
        finally {
            performanceLogger.log("Time to generate exception request.");
            MDC.remove((String)"docId");
        }
    }

    protected void notifyStatusChange(DocumentRouteHeaderValue routeHeader, String newStatusCode, String oldStatusCode) throws InvalidActionTakenException {
        DocumentRouteStatusChange statusChangeEvent = new DocumentRouteStatusChange(routeHeader.getDocumentId(), routeHeader.getAppDocId(), oldStatusCode, newStatusCode);
        try {
            LOG.debug((Object)("Notifying post processor of status change " + oldStatusCode + "->" + newStatusCode));
            PostProcessor postProcessor = routeHeader.getDocumentType().getPostProcessor();
            ProcessDocReport report = postProcessor.doRouteStatusChange(statusChangeEvent);
            if (!report.isSuccess()) {
                LOG.warn((Object)report.getMessage(), (Throwable)report.getProcessException());
                throw new InvalidActionTakenException(report.getMessage());
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)ex, (Throwable)ex);
            throw new WorkflowRuntimeException((Throwable)ex);
        }
    }

    protected List<ActionRequestValue> generateExceptionGroupRequests(RouteContext routeContext) {
        RouteNodeInstance nodeInstance = routeContext.getNodeInstance();
        ActionRequestFactory arFactory = new ActionRequestFactory(routeContext.getDocument(), null);
        ActionRequestValue exceptionRequest = arFactory.createActionRequest("C", new Integer(0), new KimGroupRecipient(nodeInstance.getRouteNode().getExceptionWorkgroup()), "Exception Workgroup for route node " + nodeInstance.getName(), "-2", Boolean.TRUE, "");
        return Collections.singletonList(exceptionRequest);
    }

    protected List<ActionRequestValue> generateKimExceptionRequests(RouteContext routeContext) throws Exception {
        RoleRouteModule roleRouteModule = new RoleRouteModule();
        roleRouteModule.setNamespace("KR-WKFLW");
        roleRouteModule.setResponsibilityTemplateName("Resolve Exception");
        List<ActionRequestValue> requests = roleRouteModule.findActionRequests(routeContext);
        this.processExceptionRequests(requests);
        return requests;
    }

    protected void processExceptionRequests(List<ActionRequestValue> exceptionRequests) {
        if (exceptionRequests != null) {
            for (ActionRequestValue actionRequest : exceptionRequests) {
                this.processExceptionRequest(actionRequest);
            }
        }
    }

    protected void processExceptionRequest(ActionRequestValue actionRequest) {
        actionRequest.setForceAction(true);
        actionRequest.setNodeInstance(null);
        this.processExceptionRequests(actionRequest.getChildrenRequests());
    }

    protected void activateExceptionRequests(RouteContext routeContext, List<ActionRequestValue> exceptionRequests, String exceptionMessage, boolean invokePostProcessor) throws Exception {
        this.setExceptionAnnotations(exceptionRequests, exceptionMessage);
        DocumentRouteHeaderValue rh = KEWServiceLocator.getRouteHeaderService().getRouteHeader(routeContext.getDocument().getDocumentId());
        String oldStatus = rh.getDocRouteStatus();
        rh.setDocRouteStatus("E");
        if (invokePostProcessor) {
            this.notifyStatusChange(rh, "E", oldStatus);
        }
        KEWServiceLocator.getRouteHeaderService().saveRouteHeader(rh);
        KEWServiceLocator.getActionRequestService().activateRequests(exceptionRequests);
    }

    protected void setExceptionAnnotations(List<ActionRequestValue> actionRequests, String exceptionMessage) {
        for (ActionRequestValue actionRequest : actionRequests) {
            actionRequest.setAnnotation(exceptionMessage);
        }
    }

    private Throwable unwrapRouteManagerExceptionIfPossible(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            throwable = throwable.getCause();
        }
        if (throwable != null && !(throwable instanceof RouteManagerException) && throwable.getCause() instanceof RouteManagerException) {
            throwable = throwable.getCause();
        }
        return throwable;
    }

    protected Throwable determineActualCause(Throwable throwable, int depth) {
        if (depth >= 10) {
            return throwable;
        }
        if ((throwable instanceof InvocationTargetException || throwable instanceof RouteManagerException) && throwable.getCause() != null) {
            return this.determineActualCause(throwable.getCause(), ++depth);
        }
        return throwable;
    }

    protected RouteContext establishRouteContext(DocumentRouteHeaderValue document, Throwable throwable) {
        RouteContext routeContext = new RouteContext();
        if (throwable instanceof RouteManagerException) {
            RouteManagerException rmException = (RouteManagerException)((Object)throwable);
            routeContext = rmException.getRouteContext();
        } else {
            routeContext.setDocument(document);
            List<RouteNodeInstance> activeNodeInstances = KEWServiceLocator.getRouteNodeService().getActiveNodeInstances(document.getDocumentId());
            if (!activeNodeInstances.isEmpty()) {
                RouteNodeInstance nodeInstance = activeNodeInstances.get(0);
                routeContext.setNodeInstance(nodeInstance);
            }
        }
        if (routeContext.getNodeInstance() == null) {
            routeContext.setNodeInstance(document.getInitialRouteNodeInstances().get(0));
        }
        return routeContext;
    }
}

