/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.notes.dao.impl;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.kuali.rice.core.framework.persistence.jpa.OrmUtils;
import org.kuali.rice.kew.notes.Attachment;
import org.kuali.rice.kew.notes.Note;
import org.kuali.rice.kew.notes.dao.NoteDAO;

public class NoteDAOJpaImpl
implements NoteDAO {
    @PersistenceContext(unitName="kew-unit")
    EntityManager entityManager;

    @Override
    public Note getNoteByNoteId(String noteId) {
        Query query = this.entityManager.createNamedQuery("KewNote.FindNoteByNoteId");
        query.setParameter("noteId", (Object)noteId);
        return (Note)query.getSingleResult();
    }

    public List getNotesByDocumentId(String documentId) {
        Query query = this.entityManager.createNamedQuery("KewNote.FindNoteByDocumentId");
        query.setParameter("documentId", (Object)documentId);
        return query.getResultList();
    }

    @Override
    public void saveNote(Note note) {
        if (note.getNoteId() == null) {
            this.entityManager.persist((Object)note);
        } else {
            this.entityManager.merge((Object)note);
        }
    }

    @Override
    public void deleteNote(Note note) {
        Note n = this.getNoteByNoteId(note.getNoteId());
        OrmUtils.merge((EntityManager)this.entityManager, (Object)n);
        this.entityManager.remove((Object)n);
    }

    @Override
    public void deleteAttachment(Attachment attachment) {
        Attachment a = this.findAttachment(attachment.getAttachmentId());
        this.entityManager.remove((Object)a);
    }

    @Override
    public Attachment findAttachment(String attachmentId) {
        Query query = this.entityManager.createNamedQuery("Attachment.FindAttachmentById");
        query.setParameter("attachmentId", (Object)attachmentId);
        return (Attachment)query.getSingleResult();
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

