/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.plugin;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.Callable;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.config.CoreConfigHelper;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.core.api.util.ContextClassLoaderBinder;
import org.kuali.rice.core.api.util.xml.XmlException;
import org.kuali.rice.kew.plugin.Plugin;
import org.kuali.rice.kew.plugin.PluginClassLoader;
import org.kuali.rice.kew.plugin.PluginConfig;
import org.kuali.rice.kew.plugin.PluginConfigParser;
import org.kuali.rice.kew.plugin.PluginException;
import org.kuali.rice.kew.plugin.PluginLoader;
import org.kuali.rice.kew.plugin.PluginUtils;

public abstract class BasePluginLoader
implements PluginLoader {
    private static final Logger LOG = Logger.getLogger(BasePluginLoader.class);
    private static final String META_INF_PATH = "META-INF";
    private static final String PLUGIN_CONFIG_PATH = "META-INF/workflow.xml";
    protected final String simplePluginName;
    protected String logPrefix;
    protected final ClassLoader parentClassLoader;
    protected final Config parentConfig;
    protected final File sharedPluginDirectory;
    protected String pluginConfigPath = "META-INF/workflow.xml";

    public BasePluginLoader(String simplePluginName, File sharedPluginDirectory, ClassLoader parentClassLoader, Config parentConfig) {
        this.sharedPluginDirectory = sharedPluginDirectory;
        if (parentClassLoader == null) {
            parentClassLoader = ClassLoaderUtils.getDefaultClassLoader();
        }
        this.parentClassLoader = parentClassLoader;
        this.parentConfig = parentConfig;
        this.simplePluginName = simplePluginName;
        this.logPrefix = simplePluginName;
    }

    protected String getLogPrefix() {
        return this.logPrefix;
    }

    @Override
    public String getPluginName() {
        return this.simplePluginName;
    }

    @Override
    public void setPluginConfigPath(String pluginConfigPath) {
        this.pluginConfigPath = pluginConfigPath;
    }

    protected String getSimplePluginName() {
        return this.simplePluginName;
    }

    protected abstract PluginClassLoader createPluginClassLoader() throws IOException;

    protected abstract URL getPluginConfigURL() throws PluginException, IOException;

    @Override
    public Plugin load() throws Exception {
        final PluginClassLoader classLoader = this.createPluginClassLoader();
        LOG.info((Object)("Created plugin ClassLoader: " + classLoader));
        return (Plugin)((Object)ContextClassLoaderBinder.doInContextClassLoader((ClassLoader)classLoader, (Callable)new Callable<Plugin>(){

            @Override
            public Plugin call() throws IOException {
                return BasePluginLoader.this.loadWithinContextClassLoader(classLoader);
            }
        }));
    }

    @Override
    public boolean isRemoved() {
        return false;
    }

    protected Plugin loadWithinContextClassLoader(PluginClassLoader classLoader) throws PluginException, IOException {
        URL url = this.getPluginConfigURL();
        PluginConfig pluginConfig = this.loadPluginConfig(url);
        QName qPluginName = this.getPluginName(pluginConfig);
        classLoader.setConfig(pluginConfig);
        ConfigContext.init((ClassLoader)classLoader, (Config)pluginConfig);
        this.configureExtraClasspath(classLoader, pluginConfig);
        this.logPrefix = PluginUtils.getLogPrefix(qPluginName).toString();
        LOG.info((Object)("Constructing plugin '" + this.simplePluginName + "' with classloader: " + classLoader));
        Plugin plugin = new Plugin(qPluginName, (Config)pluginConfig, classLoader);
        this.installResourceLoader(plugin);
        this.installPluginListeners(plugin);
        return plugin;
    }

    protected void installResourceLoader(Plugin plugin) {
        PluginUtils.installResourceLoader(plugin);
    }

    protected void installPluginListeners(Plugin plugin) {
        PluginUtils.installPluginListeners(plugin);
    }

    protected void configureExtraClasspath(PluginClassLoader classLoader, PluginConfig config) throws MalformedURLException {
        String extraLibDirs;
        String extraClassesDirs = config.getProperty("extra.classes.dir");
        if (!StringUtils.isEmpty((String)extraClassesDirs)) {
            String[] extraClasses = extraClassesDirs.split(",");
            for (int index = 0; index < extraClasses.length; ++index) {
                File extraClassesDir = new File(extraClasses[index]);
                if (!extraClassesDir.exists()) continue;
                classLoader.addClassesDirectory(extraClassesDir);
            }
        }
        if (!StringUtils.isEmpty((String)(extraLibDirs = config.getProperty("extra.lib.dir")))) {
            String[] extraLibs = extraLibDirs.split(",");
            for (int index = 0; index < extraLibs.length; ++index) {
                File extraLibDir = new File(extraLibs[index]);
                if (!extraLibDir.exists()) continue;
                classLoader.addLibDirectory(extraLibDir);
            }
        }
    }

    protected QName getPluginName(PluginConfig pluginConfig) {
        String applicationId = pluginConfig.getProperty("application.id");
        QName qPluginName = null;
        qPluginName = StringUtils.isBlank((String)applicationId) ? new QName(CoreConfigHelper.getApplicationId(), this.simplePluginName) : new QName(applicationId, this.simplePluginName);
        return qPluginName;
    }

    protected PluginConfig loadPluginConfig(URL url) {
        PluginConfigParser parser = new PluginConfigParser();
        try {
            PluginConfig pluginConfig = parser.parse(url, this.parentConfig);
            pluginConfig.parseConfig();
            return pluginConfig;
        }
        catch (FileNotFoundException e) {
            throw new PluginException(this.getLogPrefix() + " Could not locate the plugin config file at path " + url, e);
        }
        catch (IOException ioe) {
            throw new PluginException(this.getLogPrefix() + " Could not read the plugin config file", ioe);
        }
        catch (XmlException ixe) {
            throw new PluginException(this.getLogPrefix() + " Could not parse the plugin config file", ixe);
        }
    }
}

