/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.plugin;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.config.CoreConfigHelper;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.resourceloader.ResourceLoader;
import org.kuali.rice.core.framework.resourceloader.BaseResourceLoader;
import org.kuali.rice.core.impl.resourceloader.ResourceLoaderUtil;
import org.kuali.rice.kew.plugin.Plugin;
import org.kuali.rice.kew.plugin.PluginConfig;
import org.kuali.rice.kew.plugin.PluginException;
import org.kuali.rice.kew.plugin.PluginListener;
import org.kuali.rice.kew.plugin.PluginRegistry;

public final class PluginUtils {
    private static final Logger LOG = Logger.getLogger(PluginUtils.class);
    private static final String SHARED_DIR = "shared";
    public static final long INFINITE_MAX_WAIT = -1L;
    public static final long DEFAULT_MAX_WAIT = 90000L;
    public static final long DEFAULT_SAFE_TIME = 60000L;
    private static final FilenameFilter JAR_FILES_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.matches(".+\\.jar");
        }
    };
    private static final FileFilter SHARED_DIR_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() && file.getName().equals(PluginUtils.SHARED_DIR);
        }
    };

    private PluginUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static String getLogPrefix(Plugin plugin) {
        return PluginUtils.getLogPrefix(plugin.getName());
    }

    public static String getLogPrefix(QName pluginName) {
        return "[Plugin: " + pluginName + "]";
    }

    static File[] findJars(File libDir) {
        File[] jarFiles = new File[]{};
        if (libDir.isDirectory()) {
            jarFiles = libDir.listFiles(JAR_FILES_FILTER);
        }
        return jarFiles;
    }

    public static File findSharedDirectory(List pluginDirectories) {
        Iterator iterator = pluginDirectories.iterator();
        while (iterator.hasNext()) {
            File[] subDirs;
            File dir = new File((String)iterator.next());
            if (!dir.isDirectory() || (subDirs = dir.listFiles(SHARED_DIR_FILTER)).length <= 0) continue;
            return subDirs[0];
        }
        return null;
    }

    public static void validatePluginZipFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Given plugin file was 'null'");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("Given plugin file does not exist: " + file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("Given plugin file is not a valid file: " + file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException("Permission denied to read given plugin file: " + file.getAbsolutePath());
        }
        if (!file.getName().endsWith(".zip")) {
            throw new IllegalArgumentException("Given plugin file does not end in .zip extension: " + file.getAbsolutePath());
        }
        File pluginDirectory = file.getParentFile();
        PluginUtils.validatePluginDirectory(pluginDirectory);
        if (pluginDirectory == null) {
            throw new IllegalArgumentException("Given plugin directory was 'null'");
        }
        if (!pluginDirectory.canWrite()) {
            throw new IllegalArgumentException("Impossible to write to plugin directory so plugin cannot be expanded: " + pluginDirectory.getAbsolutePath());
        }
    }

    public static void validatePluginDirectory(File directory) {
        if (directory == null) {
            throw new IllegalArgumentException("Given directory was 'null'");
        }
        if (!directory.exists()) {
            throw new IllegalArgumentException("Given directory does not exist: " + directory.getAbsolutePath());
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Given plugin directory is not a valid directory: " + directory.getAbsolutePath());
        }
        if (!directory.canRead()) {
            throw new IllegalArgumentException("Permission denied to read given plugin directory: " + directory.getAbsolutePath());
        }
    }

    public static PluginRegistry getPluginRegistry() {
        return (PluginRegistry)GlobalResourceLoader.getResourceLoader((QName)new QName(CoreConfigHelper.getApplicationId(), "pluginRegistryResourceLoader"));
    }

    public static void installResourceLoader(Plugin plugin) {
        PluginConfig pluginConfig;
        if (plugin.getConfig() instanceof PluginConfig && !StringUtils.isEmpty((String)(pluginConfig = (PluginConfig)plugin.getConfig()).getResourceLoaderClassname())) {
            ResourceLoader resourceLoader = (ResourceLoader)ResourceLoaderUtil.createObject((String)pluginConfig.getResourceLoaderClassname(), (ClassLoader)plugin.getClassLoader());
            if (resourceLoader == null) {
                LOG.warn((Object)("Could not create resource loader from plugin resource loader class: " + pluginConfig.getResourceLoaderClassname()));
                resourceLoader = new BaseResourceLoader(plugin.getName());
            }
            plugin.addResourceLoader(resourceLoader);
        }
    }

    public static void installPluginListeners(Plugin plugin) {
        if (plugin.getConfig() instanceof PluginConfig) {
            PluginConfig pluginConfig = (PluginConfig)plugin.getConfig();
            for (String pluginListenerClassName : pluginConfig.getListeners()) {
                try {
                    Class<?> listenerClass = Class.forName(pluginListenerClassName, true, plugin.getClassLoader());
                    plugin.addPluginListener((PluginListener)listenerClass.newInstance());
                }
                catch (ClassNotFoundException e) {
                    throw new PluginException(PluginUtils.getLogPrefix(plugin) + " Error finding listener class '" + pluginListenerClassName + "'.", e);
                }
                catch (InstantiationException e) {
                    throw new PluginException(PluginUtils.getLogPrefix(plugin) + " Error creating an instance of listener class '" + pluginListenerClassName + "'.", e);
                }
                catch (IllegalAccessException e) {
                    throw new PluginException(PluginUtils.getLogPrefix(plugin) + " Error creating an instance of listener class '" + pluginListenerClassName + "'.", e);
                }
                catch (ClassCastException e) {
                    throw new PluginException(PluginUtils.getLogPrefix(plugin) + " Listener class '" + pluginListenerClassName + "' does not implement PluginListener.", e);
                }
            }
        }
    }

    public static class PluginZipFileFilter
    implements FileFilter {
        @Override
        public boolean accept(File file) {
            return file.isFile() && file.getName().endsWith(".zip");
        }
    }
}

