/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.rule.RuleExtension;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.service.DocumentTypeService;
import org.kuali.rice.kew.routeheader.DocumentContent;
import org.kuali.rice.kew.rule.RuleExtensionValue;
import org.kuali.rice.kew.rule.WorkflowRuleAttribute;
import org.kuali.rice.kew.rule.xmlrouting.XPathHelper;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;

public class RuleRoutingAttribute
implements WorkflowRuleAttribute {
    private static final long serialVersionUID = -8884711461398770563L;
    private static final String DOC_TYPE_NAME_PROPERTY = "docTypeFullName";
    private static final String DOC_TYPE_NAME_KEY = "docTypeFullName";
    private static final String LOOKUPABLE_CLASS = "org.kuali.rice.kew.doctype.bo.DocumentType";
    private static final String DOC_TYPE_NAME_LABEL = "Document type name";
    private static final String DOC_TYPE_NAME_XPATH = "//newMaintainableObject/businessObject/docTypeName";
    private static final String DOC_TYPE_NAME_DEL_XPATH = "//newMaintainableObject/businessObject/delegationRule/docTypeName";
    private String doctypeName;
    private List<Row> rows;
    private boolean required;

    public RuleRoutingAttribute(String docTypeName) {
        this();
        this.setDoctypeName(docTypeName);
    }

    public RuleRoutingAttribute() {
        this.buildRows();
    }

    private void buildRows() {
        this.rows = new ArrayList<Row>();
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field(DOC_TYPE_NAME_LABEL, "", "text", false, "docTypeFullName", "", false, false, null, LOOKUPABLE_CLASS));
        this.rows.add(new Row(fields));
    }

    @Override
    public boolean isMatch(DocumentContent docContent, List<RuleExtension> ruleExtensions) {
        this.setDoctypeName(this.getRuleDocumentTypeFromRuleExtensions(ruleExtensions));
        DocumentTypeService service = (DocumentTypeService)KEWServiceLocator.getService("enDocumentTypeService");
        try {
            String docTypeName = this.getDocTypNameFromXML(docContent);
            if (docTypeName.equals(this.getDoctypeName())) {
                return true;
            }
            DocumentType documentType = service.findByName(docTypeName);
            while (documentType != null && documentType.getParentDocType() != null) {
                if (!(documentType = documentType.getParentDocType()).getName().equals(this.getDoctypeName())) continue;
                return true;
            }
        }
        catch (XPathExpressionException e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
        return ruleExtensions.isEmpty();
    }

    protected String getRuleDocumentTypeFromRuleExtensions(List<RuleExtension> ruleExtensions) {
        for (RuleExtension extension : ruleExtensions) {
            if (!extension.getRuleTemplateAttribute().getRuleAttribute().getResourceDescriptor().equals(this.getClass().getName())) continue;
            for (Map.Entry extensionValue : extension.getExtensionValuesMap().entrySet()) {
                String key = (String)extensionValue.getKey();
                String value = (String)extensionValue.getValue();
                if (!key.equals("docTypeFullName")) continue;
                return value;
            }
        }
        return null;
    }

    public List getRuleRows() {
        return this.rows;
    }

    public List getRoutingDataRows() {
        return this.rows;
    }

    @Override
    public String getDocContent() {
        if (!StringUtils.isEmpty((String)this.getDoctypeName())) {
            return "<ruleRouting><doctype>" + this.getDoctypeName() + "</doctype></ruleRouting>";
        }
        return "";
    }

    private String getDocTypNameFromXML(DocumentContent docContent) throws XPathExpressionException {
        XPath xPath = XPathHelper.newXPath();
        String docTypeName = xPath.evaluate(DOC_TYPE_NAME_XPATH, docContent.getDocument());
        if (StringUtils.isBlank((String)docTypeName) && StringUtils.isBlank((String)(docTypeName = xPath.evaluate(DOC_TYPE_NAME_DEL_XPATH, docContent.getDocument())))) {
            throw new WorkflowRuntimeException("Could not locate Document Type Name on the document: " + docContent.getRouteContext().getDocument().getDocumentId());
        }
        return docTypeName;
    }

    public List<RuleRoutingAttribute> parseDocContent(DocumentContent docContent) {
        try {
            Document doc2 = XmlHelper.buildJDocument((Reader)new StringReader(docContent.getDocContent()));
            ArrayList<RuleRoutingAttribute> doctypeAttributes = new ArrayList<RuleRoutingAttribute>();
            Collection ruleRoutings = XmlHelper.findElements((Element)doc2.getRootElement(), (String)"docTypeName");
            ArrayList<String> usedDTs = new ArrayList<String>();
            Iterator iter = ruleRoutings.iterator();
            while (iter.hasNext()) {
                Element ruleRoutingElement;
                Element docTypeElement = ruleRoutingElement = (Element)iter.next();
                String elTxt = docTypeElement.getText();
                if (docTypeElement == null || usedDTs.contains(elTxt)) continue;
                usedDTs.add(elTxt);
                doctypeAttributes.add(new RuleRoutingAttribute(elTxt));
            }
            return doctypeAttributes;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List getRuleExtensionValues() {
        ArrayList<RuleExtensionValue> extensions = new ArrayList<RuleExtensionValue>();
        if (!StringUtils.isEmpty((String)this.getDoctypeName())) {
            RuleExtensionValue extension = new RuleExtensionValue();
            extension.setKey("docTypeFullName");
            extension.setValue(this.getDoctypeName());
            extensions.add(extension);
        }
        return extensions;
    }

    public List<RemotableAttributeError> validateRoutingData(Map paramMap) {
        DocumentTypeService service;
        DocumentType documentType;
        ArrayList<RemotableAttributeError> errors = new ArrayList<RemotableAttributeError>();
        this.setDoctypeName((String)paramMap.get("docTypeFullName"));
        if (this.isRequired() && StringUtils.isEmpty((String)this.getDoctypeName())) {
            errors.add(RemotableAttributeError.Builder.create((String)"routetemplate.ruleroutingattribute.doctype.invalid", (String[])new String[]{"doc type is not valid."}).build());
        }
        if (!StringUtils.isEmpty((String)this.getDoctypeName()) && (documentType = (service = (DocumentTypeService)KEWServiceLocator.getService("enDocumentTypeService")).findByName(this.getDoctypeName())) == null) {
            errors.add(RemotableAttributeError.Builder.create((String)"routetemplate.ruleroutingattribute.doctype.invalid", (String[])new String[]{"doc type is not valid"}).build());
        }
        return errors;
    }

    public List<RemotableAttributeError> validateRuleData(Map paramMap) {
        return this.validateRoutingData(paramMap);
    }

    public String getDoctypeName() {
        return this.doctypeName;
    }

    public void setDoctypeName(String docTypeName) {
        this.doctypeName = docTypeName;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }
}

