/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.bo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.api.extension.ExtensionDefinitionContract;
import org.kuali.rice.kew.rule.bo.RuleTemplateAttributeBo;
import org.kuali.rice.krad.bo.PersistableBusinessObjectBase;

@Entity
@Table(name="KREW_RULE_ATTR_T")
@NamedQueries(value={@NamedQuery(name="RuleAttribute.FindById", query="select ra from RuleAttribute ra where ra.ruleAttributeId = :ruleAttributeId"), @NamedQuery(name="RuleAttribute.FindByName", query="select ra from RuleAttribute ra where ra.name = :name"), @NamedQuery(name="RuleAttribute.FindByClassName", query="select ra from RuleAttribute ra where ra.className = :className"), @NamedQuery(name="RuleAttribute.GetAllRuleAttributes", query="select ra from RuleAttribute ra")})
public class RuleAttribute
extends PersistableBusinessObjectBase
implements ExtensionDefinitionContract {
    private static final long serialVersionUID = 1027673603158346349L;
    @Id
    @GeneratedValue(generator="KREW_RTE_TMPL_S")
    @GenericGenerator(name="KREW_RTE_TMPL_S", strategy="org.hibernate.id.enhanced.SequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KREW_RTE_TMPL_S"), @Parameter(name="value_column", value="id")})
    @Column(name="RULE_ATTR_ID")
    private String id;
    @Column(name="NM")
    private String name;
    @Column(name="LBL")
    private String label;
    @Column(name="RULE_ATTR_TYP_CD")
    private String type;
    @Column(name="CLS_NM")
    private String resourceDescriptor;
    @Column(name="DESC_TXT")
    private String description;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Column(name="XML")
    private String xmlConfigData;
    @Column(name="APPL_ID")
    private String applicationId;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.REMOVE, CascadeType.MERGE}, targetEntity=RuleTemplateAttributeBo.class, mappedBy="ruleAttribute")
    @Fetch(value=FetchMode.SELECT)
    private List ruleTemplateAttributes = new ArrayList();
    @Transient
    private List validValues = new ArrayList();
    @Transient
    private String returnUrl;

    public List getValidValues() {
        return this.validValues;
    }

    public void setValidValues(List ruleAttributeValidValues) {
        this.validValues = ruleAttributeValidValues;
    }

    public List getRuleTemplateAttributes() {
        return this.ruleTemplateAttributes;
    }

    public void setRuleTemplateAttributes(List ruleTemplateAttributes) {
        this.ruleTemplateAttributes = ruleTemplateAttributes;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getResourceDescriptor() {
        return this.resourceDescriptor;
    }

    public void setResourceDescriptor(String resourceDescriptor) {
        this.resourceDescriptor = resourceDescriptor;
    }

    public String getRuleAttributeActionsUrl() {
        return "<a href=\"RuleAttributeReport.do?id=" + this.id + "\" >report</a>";
    }

    public String getReturnUrl() {
        return this.returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public String getXmlConfigData() {
        return this.xmlConfigData;
    }

    public Map<String, String> getConfiguration() {
        HashMap<String, String> config = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)this.getXmlConfigData())) {
            config.put("xmlConfigData", this.getXmlConfigData());
        }
        return config;
    }

    public void setXmlConfigData(String xmlConfigData) {
        this.xmlConfigData = xmlConfigData;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public boolean isWorkflowAttribute() {
        return RuleAttribute.isWorkflowAttribute(this.getType());
    }

    public static boolean isWorkflowAttribute(String type) {
        return "RuleAttribute".equals(type) || "RuleXmlAttribute".equals(type);
    }

    public static ExtensionDefinition to(RuleAttribute ruleAttribute) {
        if (ruleAttribute == null) {
            return null;
        }
        return ExtensionDefinition.Builder.create((ExtensionDefinitionContract)ruleAttribute).build();
    }

    public static RuleAttribute from(ExtensionDefinition im) {
        if (im == null) {
            return null;
        }
        RuleAttribute bo = new RuleAttribute();
        bo.setApplicationId(im.getApplicationId());
        bo.setDescription(im.getDescription());
        bo.setResourceDescriptor(im.getResourceDescriptor());
        bo.setId(im.getId());
        bo.setLabel(im.getLabel());
        bo.setType(im.getType());
        bo.setVersionNumber(im.getVersionNumber());
        bo.setXmlConfigData((String)im.getConfiguration().get("xmlConfigData"));
        return bo;
    }
}

