/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.dao.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.RuleExtensionBo;
import org.kuali.rice.kew.rule.RuleResponsibilityBo;
import org.kuali.rice.kew.rule.dao.RuleDAO;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.springmodules.orm.ojb.PersistenceBrokerCallback;
import org.springmodules.orm.ojb.support.PersistenceBrokerDaoSupport;

public class RuleDAOOjbImpl
extends PersistenceBrokerDaoSupport
implements RuleDAO {
    private static final Logger LOG = Logger.getLogger(RuleDAOOjbImpl.class);
    private static final String OLD_DELEGATIONS_SQL = "select oldDel.dlgn_rule_id from krew_rule_rsp_t oldRsp, krew_dlgn_rsp_t oldDel where oldRsp.rule_id=? and oldRsp.rule_rsp_id=oldDel.rule_rsp_id and oldDel.dlgn_rule_base_val_id not in (select newDel.dlgn_rule_base_val_id from krew_rule_rsp_t newRsp, krew_dlgn_rsp_t newDel where newRsp.rule_id=? and newRsp.rule_rsp_id=newDel.rule_rsp_id)";

    @Override
    public void save(RuleBaseValues ruleBaseValues) {
        this.getPersistenceBrokerTemplate().store((Object)ruleBaseValues);
    }

    @Override
    public List<RuleBaseValues> fetchAllCurrentRulesForTemplateDocCombination(String ruleTemplateId, List documentTypes) {
        Criteria crit = new Criteria();
        crit.addIn("docTypeName", (Collection)documentTypes);
        crit.addEqualTo("ruleTemplateId", (Object)ruleTemplateId);
        crit.addEqualTo("currentInd", (Object)Boolean.TRUE);
        crit.addEqualTo("active", (Object)Boolean.TRUE);
        crit.addEqualTo("delegateRule", (Object)Boolean.FALSE);
        crit.addEqualTo("templateRuleInd", (Object)Boolean.FALSE);
        crit.addAndCriteria(this.generateFromToDateCriteria(new Date()));
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(RuleBaseValues.class, crit));
    }

    @Override
    public List<RuleBaseValues> fetchAllCurrentRulesForTemplateDocCombination(String ruleTemplateId, List documentTypes, Timestamp effectiveDate) {
        Criteria crit = new Criteria();
        crit.addIn("docTypeName", (Collection)documentTypes);
        crit.addEqualTo("ruleTemplateId", (Object)ruleTemplateId);
        crit.addEqualTo("active", (Object)Boolean.TRUE);
        crit.addEqualTo("delegateRule", (Object)Boolean.FALSE);
        crit.addEqualTo("templateRuleInd", (Object)Boolean.FALSE);
        if (effectiveDate != null) {
            crit.addLessOrEqualThan((Object)"activationDate", (Object)effectiveDate);
            crit.addGreaterThan((Object)"deactivationDate", (Object)effectiveDate);
        }
        crit.addAndCriteria(this.generateFromToDateCriteria(new Date()));
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(RuleBaseValues.class, crit));
    }

    public Criteria generateFromToDateCriteria(Date date) {
        Criteria crit = new Criteria();
        Criteria fromCrit = new Criteria();
        Criteria fromNullCrit = new Criteria();
        fromNullCrit.addIsNull("fromDateValue");
        Criteria fromLessOrEqualCrit = new Criteria();
        fromLessOrEqualCrit.addLessOrEqualThan((Object)"fromDateValue", (Object)new Timestamp(date.getTime()));
        fromCrit.addOrCriteria(fromNullCrit);
        fromCrit.addOrCriteria(fromLessOrEqualCrit);
        Criteria toCrit = new Criteria();
        Criteria toNullCrit = new Criteria();
        toNullCrit.addIsNull("toDateValue");
        Criteria toGreaterOrEqualCrit = new Criteria();
        toGreaterOrEqualCrit.addGreaterOrEqualThan((Object)"toDateValue", (Object)new Timestamp(date.getTime()));
        toCrit.addOrCriteria(toNullCrit);
        toCrit.addOrCriteria(toGreaterOrEqualCrit);
        crit.addAndCriteria(fromCrit);
        crit.addAndCriteria(toCrit);
        return crit;
    }

    @Override
    public List<RuleBaseValues> fetchAllRules(boolean currentRules) {
        Criteria crit = new Criteria();
        crit.addEqualTo("currentInd", (Object)new Boolean(currentRules));
        crit.addEqualTo("templateRuleInd", (Object)Boolean.FALSE);
        QueryByCriteria query = new QueryByCriteria(RuleBaseValues.class, crit);
        query.addOrderByDescending("activationDate");
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    @Override
    public void delete(String ruleBaseValuesId) {
        this.getPersistenceBrokerTemplate().delete((Object)this.findRuleBaseValuesById(ruleBaseValuesId));
    }

    @Override
    public List<RuleBaseValues> findByDocumentId(String documentId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("documentId", (Object)documentId);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(RuleBaseValues.class, crit));
    }

    @Override
    public RuleBaseValues findRuleBaseValuesByName(String name) {
        Criteria crit = new Criteria();
        crit.addEqualTo("name", (Object)name);
        crit.addEqualTo("currentInd", (Object)Boolean.TRUE);
        return (RuleBaseValues)((Object)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)new QueryByCriteria(RuleBaseValues.class, crit)));
    }

    @Override
    public RuleBaseValues findRuleBaseValuesById(String ruleBaseValuesId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("id", (Object)ruleBaseValuesId);
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("id", ruleBaseValuesId);
        return (RuleBaseValues)KRADServiceLocator.getBusinessObjectService().findByPrimaryKey(RuleBaseValues.class, criteria);
    }

    @Override
    public List<RuleBaseValues> findRuleBaseValuesByResponsibilityReviewer(String reviewerName, String type) {
        Criteria crit = new Criteria();
        crit.addEqualTo("ruleResponsibilityName", (Object)reviewerName);
        crit.addEqualTo("ruleResponsibilityType", (Object)type);
        List responsibilities = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(RuleResponsibilityBo.class, crit));
        ArrayList<RuleBaseValues> rules = new ArrayList<RuleBaseValues>();
        for (RuleResponsibilityBo responsibility : responsibilities) {
            RuleBaseValues rule = responsibility.getRuleBaseValues();
            if (rule == null || rule.getCurrentInd() == null || !rule.getCurrentInd().booleanValue()) continue;
            rules.add(rule);
        }
        return rules;
    }

    @Override
    public List<RuleBaseValues> findRuleBaseValuesByResponsibilityReviewerTemplateDoc(String ruleTemplateName, String documentType, String reviewerName, String type) {
        Criteria crit = new Criteria();
        crit.addEqualTo("ruleResponsibilityName", (Object)reviewerName);
        crit.addEqualTo("ruleResponsibilityType", (Object)type);
        crit.addEqualTo("ruleBaseValues.currentInd", (Object)Boolean.TRUE);
        if (!StringUtils.isBlank((String)ruleTemplateName)) {
            crit.addLike((Object)"ruleBaseValues.ruleTemplate.name", (Object)ruleTemplateName.replace("*", "%").concat("%"));
        }
        if (!StringUtils.isBlank((String)documentType)) {
            crit.addLike((Object)"ruleBaseValues.docTypeName", (Object)documentType.replace("*", "%").concat("%"));
        }
        List responsibilities = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(RuleResponsibilityBo.class, crit));
        ArrayList<RuleBaseValues> rules = new ArrayList<RuleBaseValues>();
        for (RuleResponsibilityBo responsibility : responsibilities) {
            RuleBaseValues rule = responsibility.getRuleBaseValues();
            if (rule == null || rule.getCurrentInd() == null || !rule.getCurrentInd().booleanValue()) continue;
            rules.add(rule);
        }
        return rules;
    }

    public List findRuleBaseValuesByObjectGraph(RuleBaseValues ruleBaseValues) {
        ruleBaseValues.setCurrentInd(Boolean.TRUE);
        ruleBaseValues.setTemplateRuleInd(Boolean.FALSE);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria((Object)ruleBaseValues));
    }

    @Override
    public RuleResponsibilityBo findRuleResponsibility(String responsibilityId) {
        Criteria subCrit = new Criteria();
        Criteria crit2 = new Criteria();
        subCrit.addLike((Object)"responsibilityId", (Object)responsibilityId);
        ReportQueryByCriteria subQuery = QueryFactory.newReportQuery(RuleResponsibilityBo.class, (Criteria)subCrit);
        subQuery.setAttributes(new String[]{"RULE_ID"});
        crit2.addIn((Object)"id", (Query)subQuery);
        crit2.addEqualTo("currentInd", (Object)1);
        QueryByCriteria outerQuery = QueryFactory.newQuery(RuleBaseValues.class, (Criteria)crit2);
        RuleBaseValues rbv = (RuleBaseValues)((Object)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)outerQuery));
        Criteria finalCrit = new Criteria();
        finalCrit.addEqualTo("responsibilityId", (Object)responsibilityId);
        finalCrit.addEqualTo("ruleBaseValuesId", (Object)rbv.getId());
        RuleResponsibilityBo rResp = (RuleResponsibilityBo)((Object)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)new QueryByCriteria(RuleResponsibilityBo.class, finalCrit)));
        if (rResp != null && rResp.getRuleBaseValuesId().equals(rbv.getId())) {
            return rResp;
        }
        return null;
    }

    @Override
    public List<RuleBaseValues> search(String docTypeName, String ruleId, String ruleTemplateId, String ruleDescription, String workgroupId, String principalId, Boolean delegateRule, Boolean activeInd, Map extensionValues, String workflowIdDirective) {
        ReportQueryByCriteria query;
        Criteria crit = this.getSearchCriteria(docTypeName, ruleTemplateId, ruleDescription, delegateRule, activeInd, extensionValues);
        if (ruleId != null) {
            crit.addEqualTo("id", (Object)ruleId);
        }
        if (workgroupId != null) {
            crit.addIn((Object)"id", (Query)this.getResponsibilitySubQuery(workgroupId));
        }
        List<String> workgroupIds = new ArrayList<String>();
        Boolean searchUser = Boolean.FALSE;
        Boolean searchUserInWorkgroups = Boolean.FALSE;
        if ("group".equals(workflowIdDirective)) {
            searchUserInWorkgroups = Boolean.TRUE;
        } else if (StringUtils.isBlank((String)workflowIdDirective)) {
            searchUser = Boolean.TRUE;
            searchUserInWorkgroups = Boolean.TRUE;
        } else {
            searchUser = Boolean.TRUE;
        }
        if (!StringUtils.isEmpty((String)principalId) && searchUserInWorkgroups.booleanValue()) {
            Principal principal = KimApiServiceLocator.getIdentityService().getPrincipal(principalId);
            if (principal == null) {
                throw new RiceRuntimeException("Failed to locate user for the given workflow id: " + principalId);
            }
            workgroupIds = KimApiServiceLocator.getGroupService().getGroupIdsByPrincipalId(principalId);
        }
        if ((query = this.getResponsibilitySubQuery(workgroupIds, principalId, searchUser, searchUserInWorkgroups)) != null) {
            crit.addIn((Object)"id", (Query)query);
        }
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(RuleBaseValues.class, crit, true));
    }

    @Override
    public List<RuleBaseValues> search(String docTypeName, String ruleTemplateId, String ruleDescription, Collection<String> workgroupIds, String workflowId, Boolean delegateRule, Boolean activeInd, Map extensionValues, Collection actionRequestCodes) {
        List results = null;
        Criteria crit = this.getSearchCriteria(docTypeName, ruleTemplateId, ruleDescription, delegateRule, activeInd, extensionValues);
        ReportQueryByCriteria query = this.getResponsibilitySubQuery(workgroupIds, workflowId, actionRequestCodes, workflowId != null, workgroupIds != null && !workgroupIds.isEmpty());
        if (query != null) {
            crit.addIn((Object)"ruleResponsibilities.ruleBaseValuesId", (Query)query);
        }
        results = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(RuleBaseValues.class, crit, true));
        return results;
    }

    private ReportQueryByCriteria getResponsibilitySubQuery(List<String> workgroupIds, String workflowId, Boolean searchUser, Boolean searchUserInWorkgroups) {
        ArrayList<String> workgroupIdStrings = new ArrayList<String>();
        for (String workgroupId : workgroupIds) {
            workgroupIdStrings.add(workgroupId);
        }
        return this.getResponsibilitySubQuery(workgroupIdStrings, workflowId, new ArrayList(), searchUser, searchUserInWorkgroups);
    }

    private ReportQueryByCriteria getResponsibilitySubQuery(Collection<String> workgroupIds, String workflowId, Collection actionRequestCodes, Boolean searchUser, Boolean searchUserInWorkgroups) {
        Criteria responsibilityCrit = null;
        if (actionRequestCodes != null && !actionRequestCodes.isEmpty()) {
            responsibilityCrit = new Criteria();
            responsibilityCrit.addIn("actionRequestedCd", actionRequestCodes);
        }
        ReportQueryByCriteria query = null;
        Criteria ruleResponsibilityNameCrit = null;
        if (!StringUtils.isEmpty((String)workflowId)) {
            if (searchUser != null && searchUser.booleanValue()) {
                ruleResponsibilityNameCrit = new Criteria();
                ruleResponsibilityNameCrit.addLike((Object)"ruleResponsibilityName", (Object)workflowId);
                ruleResponsibilityNameCrit.addEqualTo("ruleResponsibilityType", (Object)"F");
            }
            if (searchUserInWorkgroups != null && searchUserInWorkgroups.booleanValue() && workgroupIds != null && !workgroupIds.isEmpty()) {
                if (ruleResponsibilityNameCrit == null) {
                    ruleResponsibilityNameCrit = new Criteria();
                }
                Criteria workgroupCrit = new Criteria();
                workgroupCrit.addIn("ruleResponsibilityName", workgroupIds);
                workgroupCrit.addEqualTo("ruleResponsibilityType", (Object)"G");
                ruleResponsibilityNameCrit.addOrCriteria(workgroupCrit);
            }
        } else if (workgroupIds != null && workgroupIds.size() == 1) {
            ruleResponsibilityNameCrit = new Criteria();
            ruleResponsibilityNameCrit.addLike((Object)"ruleResponsibilityName", (Object)workgroupIds.iterator().next());
            ruleResponsibilityNameCrit.addEqualTo("ruleResponsibilityType", (Object)"G");
        } else if (workgroupIds != null && workgroupIds.size() > 1) {
            ruleResponsibilityNameCrit = new Criteria();
            ruleResponsibilityNameCrit.addIn("ruleResponsibilityName", workgroupIds);
            ruleResponsibilityNameCrit.addEqualTo("ruleResponsibilityType", (Object)"G");
        }
        if (ruleResponsibilityNameCrit != null) {
            if (responsibilityCrit == null) {
                responsibilityCrit = new Criteria();
            }
            responsibilityCrit.addAndCriteria(ruleResponsibilityNameCrit);
        }
        if (responsibilityCrit != null) {
            query = QueryFactory.newReportQuery(RuleResponsibilityBo.class, (Criteria)responsibilityCrit);
            query.setAttributes(new String[]{"ruleBaseValuesId"});
        }
        return query;
    }

    private Criteria getSearchCriteria(String docTypeName, String ruleTemplateId, String ruleDescription, Boolean delegateRule, Boolean activeInd, Map extensionValues) {
        Criteria crit = new Criteria();
        crit.addEqualTo("currentInd", (Object)Boolean.TRUE);
        crit.addEqualTo("templateRuleInd", (Object)Boolean.FALSE);
        if (activeInd != null) {
            crit.addEqualTo("active", (Object)activeInd);
        }
        if (docTypeName != null) {
            crit.addLike((Object)"UPPER(docTypeName)", (Object)docTypeName.toUpperCase());
        }
        if (ruleDescription != null && !ruleDescription.trim().equals("")) {
            crit.addLike((Object)"UPPER(description)", (Object)ruleDescription.toUpperCase());
        }
        if (ruleTemplateId != null) {
            crit.addEqualTo("ruleTemplateId", (Object)ruleTemplateId);
        }
        if (delegateRule != null) {
            crit.addEqualTo("delegateRule", (Object)delegateRule);
        }
        if (extensionValues != null && !extensionValues.isEmpty()) {
            for (Map.Entry entry : extensionValues.entrySet()) {
                if (StringUtils.isEmpty((String)((String)entry.getValue()))) continue;
                Criteria extensionCrit2 = new Criteria();
                extensionCrit2.addEqualTo("extensionValues.key", entry.getKey());
                extensionCrit2.addLike((Object)"UPPER(extensionValues.value)", (Object)("%" + (String)entry.getValue() + "%").toUpperCase());
                ReportQueryByCriteria query = QueryFactory.newReportQuery(RuleExtensionBo.class, (Criteria)extensionCrit2);
                query.setAttributes(new String[]{"ruleBaseValuesId"});
                crit.addIn((Object)"ruleExtensions.ruleBaseValuesId", (Query)query);
            }
        }
        return crit;
    }

    private Criteria getWorkgroupOrCriteria(Collection workgroupIds) {
        Criteria responsibilityCrit = new Criteria();
        for (String workgroupIdFromList : workgroupIds) {
            Criteria orCriteria = new Criteria();
            orCriteria.addLike((Object)"ruleResponsibilityName", (Object)workgroupIdFromList);
            responsibilityCrit.addOrCriteria(orCriteria);
        }
        ReportQueryByCriteria query = QueryFactory.newReportQuery(RuleResponsibilityBo.class, (Criteria)responsibilityCrit);
        query.setAttributes(new String[]{"ruleBaseValuesId"});
        Criteria crit = new Criteria();
        crit.addIn((Object)"responsibilities.ruleBaseValuesId", (Query)query);
        return crit;
    }

    private ReportQueryByCriteria getResponsibilitySubQuery(String ruleResponsibilityName) {
        Criteria responsibilityCrit = new Criteria();
        responsibilityCrit.addLike((Object)"ruleResponsibilityName", (Object)ruleResponsibilityName);
        ReportQueryByCriteria query = QueryFactory.newReportQuery(RuleResponsibilityBo.class, (Criteria)responsibilityCrit);
        query.setAttributes(new String[]{"ruleBaseValuesId"});
        return query;
    }

    private ReportQueryByCriteria getWorkgroupResponsibilitySubQuery(Set<Long> workgroupIds) {
        HashSet<String> workgroupIdStrings = new HashSet<String>();
        for (Long workgroupId : workgroupIds) {
            workgroupIdStrings.add(workgroupId.toString());
        }
        Criteria responsibilityCrit = new Criteria();
        responsibilityCrit.addIn("ruleResponsibilityName", workgroupIds);
        responsibilityCrit.addEqualTo("ruleResponsibilityType", (Object)"G");
        ReportQueryByCriteria query = QueryFactory.newReportQuery(RuleResponsibilityBo.class, (Criteria)responsibilityCrit);
        query.setAttributes(new String[]{"ruleBaseValuesId"});
        return query;
    }

    @Override
    public List<RuleBaseValues> findByPreviousRuleId(String previousRuleId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("previousRuleId", (Object)previousRuleId);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(RuleBaseValues.class, crit));
    }

    @Override
    public RuleBaseValues findDefaultRuleByRuleTemplateId(String ruleTemplateId) {
        Criteria crit = new Criteria();
        crit.addEqualTo("ruleTemplateId", (Object)ruleTemplateId);
        crit.addEqualTo("templateRuleInd", (Object)Boolean.TRUE);
        List rules = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(RuleBaseValues.class, crit));
        if (rules != null && !rules.isEmpty()) {
            return (RuleBaseValues)((Object)rules.get(0));
        }
        return null;
    }

    @Override
    public void retrieveAllReferences(RuleBaseValues rule) {
    }

    @Override
    public RuleBaseValues getParentRule(String ruleBaseValuesId) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("currentInd", (Object)Boolean.TRUE);
        criteria.addEqualTo("responsibilities.delegationRules.delegateRuleId", (Object)ruleBaseValuesId);
        Collection rules = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(RuleBaseValues.class, criteria));
        RuleBaseValues rule = null;
        for (RuleBaseValues currentRule : rules) {
            if (rule != null && currentRule.getVersionNbr() <= rule.getVersionNbr()) continue;
            rule = currentRule;
        }
        return rule;
    }

    @Override
    public List findOldDelegations(final RuleBaseValues oldRule, final RuleBaseValues newRule) {
        return (List)this.getPersistenceBrokerTemplate().execute(new PersistenceBrokerCallback(){

            public Object doInPersistenceBroker(PersistenceBroker pb) {
                ArrayList<RuleBaseValues> oldDelegations = new ArrayList<RuleBaseValues>();
                PreparedStatement ps = null;
                ResultSet rs = null;
                try {
                    ps = pb.serviceConnectionManager().getConnection().prepareStatement(RuleDAOOjbImpl.OLD_DELEGATIONS_SQL);
                    ps.setString(1, oldRule.getId());
                    ps.setString(2, newRule.getId());
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        oldDelegations.add(RuleDAOOjbImpl.this.findRuleBaseValuesById(rs.getString(1)));
                    }
                }
                catch (Exception e) {
                    throw new WorkflowRuntimeException("error saving deactivation date", (Throwable)e);
                }
                finally {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception e) {
                            LOG.error((Object)"error closing result set", (Throwable)e);
                        }
                    }
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Exception e) {
                            LOG.error((Object)"error closing preparedstatement", (Throwable)e);
                        }
                    }
                }
                return oldDelegations;
            }
        });
    }

    @Override
    public String findResponsibilityIdForRule(String ruleName, String ruleResponsibilityName, String ruleResponsibilityType) {
        Iterator iter;
        Criteria crit = new Criteria();
        crit.addEqualTo("ruleResponsibilityName", (Object)ruleResponsibilityName);
        crit.addEqualTo("ruleResponsibilityType", (Object)ruleResponsibilityType);
        crit.addEqualTo("ruleBaseValues.currentInd", (Object)Boolean.TRUE);
        crit.addEqualTo("ruleBaseValues.name", (Object)ruleName);
        List responsibilities = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(RuleResponsibilityBo.class, crit));
        if (responsibilities != null && (iter = responsibilities.iterator()).hasNext()) {
            RuleResponsibilityBo responsibility = (RuleResponsibilityBo)((Object)iter.next());
            return responsibility.getResponsibilityId();
        }
        return null;
    }
}

