/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.rule.RuleBaseValues;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.rule.web.RuleForm;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.web.KewKualiAction;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;

public class RuleAction
extends KewKualiAction {
    private static final String RULE_TEMPLATE_NAME_PROPERTY = "ruleTemplateName";
    private static final String DOC_TYPE_NAME_PROPERTY = "documentTypeName";
    private static final String RULE_TEMPLATE_ERROR = "rule.template.name.required";
    private static final String DOCUMENT_TYPE_ERROR = "rule.docType.name.required";
    private ConfigurationService kualiConfigurationService;

    public ActionForward createRule(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RuleForm form = (RuleForm)actionForm;
        if (!this.validateCreateRule(form)) {
            return mapping.findForward(this.getDefaultMapping());
        }
        return new ActionForward(this.generateMaintenanceUrl(request, form), true);
    }

    public ActionForward clearInitFields(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RuleForm form = (RuleForm)actionForm;
        form.clearSearchableAttributeProperties();
        return mapping.findForward(this.getDefaultMapping());
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RuleForm form = (RuleForm)actionForm;
        String question = request.getParameter("questionIndex");
        if (question == null) {
            return this.performQuestionWithoutInput(mapping, (ActionForm)form, request, response, "DocCancel", this.getKualiConfigurationService().getPropertyValueAsString("document.question.cancel.text"), "confirmationQuestion", "cancel", "");
        }
        String buttonClicked = request.getParameter("buttonClicked");
        if ("DocCancel".equals(question) && "1".equals(buttonClicked)) {
            return mapping.findForward("basic");
        }
        ActionForward dest = null;
        dest = StringUtils.isNotBlank((String)form.getBackLocation()) ? new ActionForward(form.getBackLocation(), true) : mapping.findForward("portal");
        return dest;
    }

    protected String generateMaintenanceUrl(HttpServletRequest request, RuleForm form) {
        return RuleAction.getApplicationBaseUrl() + "/kr/" + "maintenance.do" + "?" + "methodToCall" + "=" + "start" + "&" + "businessObjectClassName" + "=" + RuleBaseValues.class.getName() + "&" + "ruleCreationValues.docTypeName" + "=" + form.getDocumentTypeName() + "&" + "ruleCreationValues.ruleTemplateName" + "=" + form.getRuleTemplateName();
    }

    protected boolean validateCreateRule(RuleForm form) {
        if (StringUtils.isEmpty((String)form.getRuleTemplateName())) {
            GlobalVariables.getMessageMap().putError(RULE_TEMPLATE_NAME_PROPERTY, RULE_TEMPLATE_ERROR, new String[0]);
        } else {
            RuleTemplateBo ruleTemplate = KEWServiceLocator.getRuleTemplateService().findByRuleTemplateName(form.getRuleTemplateName().trim());
            if (ruleTemplate == null) {
                GlobalVariables.getMessageMap().putError(RULE_TEMPLATE_NAME_PROPERTY, RULE_TEMPLATE_ERROR, new String[0]);
            }
        }
        if (StringUtils.isEmpty((String)form.getDocumentTypeName())) {
            GlobalVariables.getMessageMap().putError(DOC_TYPE_NAME_PROPERTY, DOCUMENT_TYPE_ERROR, new String[0]);
        } else {
            DocumentType docType = KEWServiceLocator.getDocumentTypeService().findByName(form.getDocumentTypeName());
            if (docType == null) {
                GlobalVariables.getMessageMap().putError(DOC_TYPE_NAME_PROPERTY, DOCUMENT_TYPE_ERROR, new String[0]);
            }
        }
        return GlobalVariables.getMessageMap().hasNoErrors();
    }

    protected ConfigurationService getKualiConfigurationService() {
        if (this.kualiConfigurationService == null) {
            this.kualiConfigurationService = KRADServiceLocator.getKualiConfigurationService();
        }
        return this.kualiConfigurationService;
    }
}

