/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.bo.ui;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.kuali.rice.kew.api.util.CodeTranslator;
import org.kuali.rice.kim.api.responsibility.Responsibility;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.bo.ui.KimDocumentBoEditableBase;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleResponsibilityActionId;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityBo;
import org.kuali.rice.kim.impl.role.RoleResponsibilityBo;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.util.ObjectUtils;

@IdClass(value=KimDocumentRoleResponsibilityActionId.class)
@Entity
@Table(name="KRIM_PND_ROLE_RSP_ACTN_MT")
public class KimDocumentRoleResponsibilityAction
extends KimDocumentBoEditableBase {
    private static final long serialVersionUID = 696663543888096105L;
    @Id
    @GeneratedValue(generator="KRIM_ROLE_RSP_ACTN_ID_S")
    @GenericGenerator(name="KRIM_ROLE_RSP_ACTN_ID_S", strategy="org.kuali.rice.core.jpa.spring.RiceNumericStringSequenceStyleGenerator", parameters={@Parameter(name="sequence_name", value="KRIM_ROLE_RSP_ACTN_ID_S"), @Parameter(name="value_column", value="id")})
    @Column(name="ROLE_RSP_ACTN_ID")
    protected String roleResponsibilityActionId;
    @Column(name="ROLE_RSP_ID")
    protected String roleResponsibilityId;
    @Column(name="ROLE_MBR_ID")
    protected String roleMemberId;
    @Column(name="ACTN_TYP_CD")
    protected String actionTypeCode;
    @Column(name="ACTN_PLCY_CD")
    protected String actionPolicyCode;
    @Column(name="PRIORITY_NBR")
    protected Integer priorityNumber;
    @Column(name="FRC_ACTN")
    protected boolean forceAction;
    @Column(name="VER_NBR")
    protected Long versionNumber = 0L;
    @Transient
    protected ResponsibilityBo kimResponsibility;
    @Transient
    protected RoleResponsibilityBo roleResponsibility;

    public ResponsibilityBo getKimResponsibility() {
        if (ObjectUtils.isNull((Object)this.kimResponsibility) && ObjectUtils.isNotNull((Object)this.getRoleResponsibility())) {
            Responsibility info = KimApiServiceLocator.getResponsibilityService().getResponsibility(this.getRoleResponsibility().getResponsibilityId());
            this.kimResponsibility = ResponsibilityBo.from((Responsibility)info);
        }
        return this.kimResponsibility;
    }

    public void setKimResponsibility(ResponsibilityBo kimResponsibility) {
        this.kimResponsibility = kimResponsibility;
    }

    public String getRoleResponsibilityActionId() {
        return this.roleResponsibilityActionId;
    }

    public void setRoleResponsibilityActionId(String roleResponsibilityResolutionId) {
        this.roleResponsibilityActionId = roleResponsibilityResolutionId;
    }

    public String getRoleResponsibilityId() {
        return this.roleResponsibilityId;
    }

    public void setRoleResponsibilityId(String roleResponsibilityId) {
        this.roleResponsibilityId = roleResponsibilityId;
    }

    public String getActionTypeCode() {
        return this.actionTypeCode;
    }

    public void setActionTypeCode(String actionTypeCode) {
        this.actionTypeCode = actionTypeCode;
    }

    public Integer getPriorityNumber() {
        return this.priorityNumber;
    }

    public void setPriorityNumber(Integer priorityNumber) {
        this.priorityNumber = priorityNumber;
    }

    public String getActionPolicyCode() {
        return this.actionPolicyCode;
    }

    public void setActionPolicyCode(String actionPolicyCode) {
        this.actionPolicyCode = actionPolicyCode;
    }

    public String getRoleMemberId() {
        return this.roleMemberId;
    }

    public void setRoleMemberId(String roleMemberId) {
        this.roleMemberId = roleMemberId;
    }

    public String getActionPolicyDescription() {
        return (String)CodeTranslator.approvePolicyLabels.get(this.actionPolicyCode);
    }

    public String getActionTypeDescription() {
        return (String)CodeTranslator.arLabels.get(this.actionTypeCode);
    }

    public RoleResponsibilityBo getRoleResponsibility() {
        if (ObjectUtils.isNull((Object)this.roleResponsibility) && this.roleResponsibilityId != null) {
            this.roleResponsibility = (RoleResponsibilityBo)KRADServiceLocator.getBusinessObjectService().findBySinglePrimaryKey(RoleResponsibilityBo.class, (Object)this.getRoleResponsibilityId());
        }
        return this.roleResponsibility;
    }

    public void setRoleResponsibility(RoleResponsibilityBo roleResponsibility) {
        this.roleResponsibility = roleResponsibility;
    }

    public boolean isForceAction() {
        return this.forceAction;
    }

    public void setForceAction(boolean forceAction) {
        this.forceAction = forceAction;
    }
}

