/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.responsibility;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.kuali.rice.coreservice.impl.namespace.NamespaceBo;
import org.kuali.rice.kim.api.responsibility.ResponsibilityService;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityAttributeBo;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityBo;
import org.kuali.rice.kim.impl.responsibility.UberResponsibilityBo;
import org.kuali.rice.kim.impl.role.RoleBo;
import org.kuali.rice.kim.impl.role.RoleResponsibilityBo;
import org.kuali.rice.kim.inquiry.RoleMemberInquirableImpl;
import org.kuali.rice.kim.lookup.RoleLookupableHelperServiceImpl;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.uif.widget.Inquiry;
import org.kuali.rice.krad.util.ObjectUtils;

public class ResponsibilityInquirableImpl
extends RoleMemberInquirableImpl {
    protected final String KIM_RESPONSIBILITY_REQUIRED_ATTRIBUTE_ID = "kimResponsibilityRequiredAttributeId";
    protected final String RESPONSIBILITY_ID = "id";
    private static transient ResponsibilityService responsibilityService;

    public void buildInquirableLink(Object dataObject, String propertyName, Inquiry inquiry) {
        if ("name".equals(propertyName) || "nameToDisplay".equals(propertyName)) {
            HashMap<String, String> primaryKeys = new HashMap<String, String>();
            primaryKeys.put("id", "id");
            inquiry.buildInquiryLink(dataObject, propertyName, UberResponsibilityBo.class, primaryKeys);
        } else if ("namespaceCode".equals(propertyName) || "template.namespaceCode".equals(propertyName)) {
            HashMap<String, String> primaryKeys = new HashMap<String, String>();
            primaryKeys.put(propertyName, "code");
            inquiry.buildInquiryLink(dataObject, propertyName, NamespaceBo.class, primaryKeys);
        } else if ("detailObjects".equals(propertyName)) {
            super.buildInquirableLink(dataObject, propertyName, inquiry);
        } else if ("assignedToRolesToDisplay".equals(propertyName)) {
            super.buildInquirableLink(dataObject, propertyName, inquiry);
        } else {
            super.buildInquirableLink(dataObject, propertyName, inquiry);
        }
    }

    public HtmlData getInquiryUrl(BusinessObject businessObject, String attributeName, boolean forceInquiry) {
        if ("name".equals(attributeName) || "nameToDisplay".equals(attributeName)) {
            ArrayList<String> primaryKeys = new ArrayList<String>();
            primaryKeys.add("id");
            return this.getInquiryUrlForPrimaryKeys(UberResponsibilityBo.class, businessObject, primaryKeys, null);
        }
        if ("namespaceCode".equals(attributeName) || "template.namespaceCode".equals(attributeName)) {
            ArrayList<String> primaryKeys = new ArrayList<String>();
            primaryKeys.add("code");
            NamespaceBo parameterNamespace = new NamespaceBo();
            parameterNamespace.setCode((String)ObjectUtils.getPropertyValue((Object)businessObject, (String)attributeName));
            return this.getInquiryUrlForPrimaryKeys(NamespaceBo.class, parameterNamespace, primaryKeys, null);
        }
        if (!"detailObjects".equals(attributeName) && "assignedToRolesToDisplay".equals(attributeName)) {
            return this.getAssignedRoleInquiryUrl(businessObject);
        }
        return super.getInquiryUrl(businessObject, attributeName, forceInquiry);
    }

    protected HtmlData getAttributesInquiryUrl(BusinessObject businessObject, String attributeName) {
        List responsibilityAttributeData = (List)ObjectUtils.getPropertyValue((Object)businessObject, (String)attributeName);
        ArrayList<HtmlData.AnchorHtmlData> htmlData = new ArrayList<HtmlData.AnchorHtmlData>();
        ArrayList<String> primaryKeys = new ArrayList<String>();
        primaryKeys.add("attributeDataId");
        for (ResponsibilityAttributeBo responsibilityAttributeDataImpl : responsibilityAttributeData) {
            htmlData.add(this.getInquiryUrlForPrimaryKeys(ResponsibilityAttributeBo.class, responsibilityAttributeDataImpl, primaryKeys, this.getKimAttributeLabelFromDD(responsibilityAttributeDataImpl.getKimAttribute().getAttributeName()) + " : " + responsibilityAttributeDataImpl.getAttributeValue()));
        }
        return new HtmlData.MultipleAnchorHtmlData(htmlData);
    }

    protected HtmlData getAssignedRoleInquiryUrl(BusinessObject businessObject) {
        UberResponsibilityBo responsibility = (UberResponsibilityBo)businessObject;
        List assignedToRoles = responsibility.getAssignedToRoles();
        ArrayList<HtmlData.AnchorHtmlData> htmlData = new ArrayList<HtmlData.AnchorHtmlData>();
        if (assignedToRoles != null && !assignedToRoles.isEmpty()) {
            List<String> primaryKeys = Collections.singletonList("id");
            RoleService roleService = KimApiServiceLocator.getRoleService();
            for (RoleBo roleImpl : assignedToRoles) {
                Role role = roleService.getRole(roleImpl.getId());
                HtmlData.AnchorHtmlData inquiryHtmlData = this.getInquiryUrlForPrimaryKeys(RoleBo.class, role, primaryKeys, role.getNamespaceCode() + " " + role.getName());
                inquiryHtmlData.setHref(RoleLookupableHelperServiceImpl.getCustomRoleInquiryHref(inquiryHtmlData.getHref()));
                htmlData.add(inquiryHtmlData);
            }
        }
        return new HtmlData.MultipleAnchorHtmlData(htmlData);
    }

    public Object retrieveDataObject(Map fieldValues) {
        return this.getBusinessObject(fieldValues);
    }

    public BusinessObject getBusinessObject(Map fieldValues) {
        ResponsibilityBo responsibilityImpl = (ResponsibilityBo)KRADServiceLocator.getBusinessObjectService().findByPrimaryKey(ResponsibilityBo.class, Collections.singletonMap("id", fieldValues.get("id").toString()));
        return this.getResponsibilitiesSearchResultsCopy(responsibilityImpl);
    }

    public ResponsibilityService getResponsibilityService() {
        if (responsibilityService == null) {
            responsibilityService = KimApiServiceLocator.getResponsibilityService();
        }
        return responsibilityService;
    }

    private ResponsibilityBo getResponsibilitiesSearchResultsCopy(ResponsibilityBo responsibilitySearchResult) {
        UberResponsibilityBo responsibilitySearchResultCopy = new UberResponsibilityBo();
        try {
            PropertyUtils.copyProperties((Object)responsibilitySearchResultCopy, (Object)responsibilitySearchResult);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("responsibilityId", responsibilitySearchResultCopy.getId());
        List roleResponsibilitys = (List)KRADServiceLocator.getBusinessObjectService().findMatching(RoleResponsibilityBo.class, criteria);
        ArrayList<RoleBo> assignedToRoles = new ArrayList<RoleBo>();
        for (RoleResponsibilityBo roleResponsibilityImpl : roleResponsibilitys) {
            assignedToRoles.add(this.getRoleImpl(roleResponsibilityImpl.getRoleId()));
        }
        responsibilitySearchResultCopy.setAssignedToRoles(assignedToRoles);
        return responsibilitySearchResultCopy;
    }
}

