/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.type;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Transient;
import javax.xml.ws.WebServiceException;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.api.type.KimAttributeField;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.bo.impl.KimAttributes;
import org.kuali.rice.kim.document.IdentityManagementKimDocument;
import org.kuali.rice.kim.framework.services.KimFrameworkServiceLocator;
import org.kuali.rice.kim.framework.type.KimTypeService;
import org.kuali.rice.kim.service.KIMServiceLocatorInternal;
import org.kuali.rice.krad.util.GlobalVariables;

public class IdentityManagementTypeAttributeTransactionalDocument
extends IdentityManagementKimDocument {
    protected static final long serialVersionUID = -9064436454008712125L;
    @Transient
    protected transient KimTypeService kimTypeService;
    @Transient
    protected KimType kimType;
    @Transient
    protected List<? extends KimAttributes> attributes;
    @Transient
    protected transient List<KimAttributeField> definitions;
    @Transient
    protected transient Map<String, Object> attributeEntry;

    public List<? extends KimAttributes> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<? extends KimAttributes> attributes) {
        this.attributes = attributes;
    }

    public KimType getKimType() {
        return this.kimType;
    }

    public void setKimType(KimType kimType) {
        this.kimType = kimType;
    }

    public Map<String, Object> getAttributeEntry() {
        if (this.attributeEntry == null || this.attributeEntry.isEmpty()) {
            this.attributeEntry = KIMServiceLocatorInternal.getUiDocumentService().getAttributeEntries(this.getDefinitions());
        }
        return this.attributeEntry;
    }

    public String getCommaDelimitedAttributesLabels(String commaDelimitedAttributesNamesList) {
        String[] names = StringUtils.splitByWholeSeparator((String)commaDelimitedAttributesNamesList, (String)", ");
        StringBuffer commaDelimitedAttributesLabels = new StringBuffer();
        for (String name : names) {
            commaDelimitedAttributesLabels.append(this.getAttributeEntry().get(name.trim()) + ", ");
        }
        if (commaDelimitedAttributesLabels.toString().endsWith(", ")) {
            commaDelimitedAttributesLabels.delete(commaDelimitedAttributesLabels.length() - ", ".length(), commaDelimitedAttributesLabels.length());
        }
        return commaDelimitedAttributesLabels.toString();
    }

    public List<KimAttributeField> getDefinitions() {
        if (this.definitions == null || this.definitions.isEmpty()) {
            this.definitions = Collections.emptyList();
            KimTypeService kimTypeService = this.getKimTypeService(this.getKimType());
            if (kimTypeService != null) {
                try {
                    this.definitions = kimTypeService.getAttributeDefinitions(this.getKimType().getId());
                }
                catch (WebServiceException e) {
                    GlobalVariables.getMessageMap().putWarning("document.qualifier", "error.document.maintenance.group.remoteAttributesNotAvailable", new String[0]);
                    LOG.warn((Object)("Not able to retrieve attribute definitions via KimTypeservice from remote system for KIM Type: " + this.kimType.getName()), (Throwable)e);
                }
            }
        }
        return this.definitions;
    }

    public Map<String, KimAttributeField> getDefinitionsKeyedByAttributeName() {
        HashMap<String, KimAttributeField> map = new HashMap<String, KimAttributeField>();
        for (KimAttributeField field : this.getDefinitions()) {
            map.put(field.getAttributeField().getName(), field);
        }
        return map;
    }

    public void setDefinitions(List<KimAttributeField> definitions) {
        this.definitions = definitions;
    }

    protected KimTypeService getKimTypeService(KimType kimType) {
        if (this.kimTypeService == null) {
            this.kimTypeService = KimFrameworkServiceLocator.getKimTypeService((KimType)kimType);
        }
        return this.kimTypeService;
    }
}

