/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.dao.impl;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.kuali.rice.core.framework.persistence.jpa.criteria.Criteria;
import org.kuali.rice.core.framework.persistence.jpa.criteria.QueryByCriteria;
import org.kuali.rice.krad.bo.Attachment;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.dao.NoteDao;
import org.springframework.dao.DataAccessException;

public class NoteDaoJpa
implements NoteDao {
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public void save(Note note) throws DataAccessException {
        if (note != null && note.getNoteIdentifier() == null && note.getAttachment() != null) {
            Attachment attachment = note.getAttachment();
            note.setAttachment(null);
            this.entityManager.merge((Object)note);
            attachment.setNoteIdentifier(note.getNoteIdentifier());
            note.setAttachment(attachment);
        }
        this.entityManager.merge((Object)note);
    }

    @Override
    public void deleteNote(Note note) throws DataAccessException {
        this.entityManager.remove((Object)note.getAttachment());
        note.setAttachment(null);
        this.entityManager.remove((Object)note);
    }

    @Override
    public List<Note> findByremoteObjectId(String remoteObjectId) {
        Criteria criteria = new Criteria(Note.class.getName());
        criteria.eq("remoteObjectIdentifier", (Object)remoteObjectId);
        criteria.orderBy("notePostedTimestamp", true);
        return new ArrayList<Note>(new QueryByCriteria(this.entityManager, criteria).toQuery().getResultList());
    }

    @Override
    public Note getNoteByNoteId(Long noteId) {
        Criteria criteria = new Criteria(Note.class.getName());
        criteria.eq("noteIdentifier", (Object)noteId);
        return (Note)new QueryByCriteria(this.entityManager, criteria).toQuery().getSingleResult();
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

