/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.test;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.kuali.rice.test.MethodAware;
import org.kuali.rice.test.lifecycles.PerTestDataLoaderLifecycle;
import org.kuali.rice.test.runners.RiceUnitTestClassRunner;

@RunWith(value=RiceUnitTestClassRunner.class)
public abstract class BaseRiceTestCase
implements MethodAware {
    protected final Logger log = Logger.getLogger(this.getClass());
    private static final Map<String, Level> changedLogLevels = new HashMap<String, Level>();
    private String name;
    private PerTestDataLoaderLifecycle perTestDataLoaderLifecycle;
    protected Method method;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
        this.resetLogLevels();
    }

    protected void setLogLevel(String loggerName, Level newLevel) {
        Logger logger = Logger.getLogger((String)loggerName);
        if (!changedLogLevels.containsKey(loggerName)) {
            Level originalLevel = logger.getLevel();
            changedLogLevels.put(loggerName, originalLevel);
        }
        logger.setLevel(newLevel);
    }

    protected void resetLogLevels() {
        for (Map.Entry<String, Level> e : changedLogLevels.entrySet()) {
            String loggerName = e.getKey();
            Level originalLevel = e.getValue();
            Logger.getLogger((String)loggerName).setLevel(originalLevel);
        }
        changedLogLevels.clear();
    }

    @Override
    public void setTestMethod(Method testMethod) {
        this.method = testMethod;
        this.perTestDataLoaderLifecycle = new PerTestDataLoaderLifecycle(this.method);
    }

    protected PerTestDataLoaderLifecycle getPerTestDataLoaderLifecycle() {
        return this.perTestDataLoaderLifecycle;
    }
}

