/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kcb.service.impl;

import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kcb.bo.Message;
import org.kuali.rice.kcb.service.GlobalKCBServiceLocator;
import org.kuali.rice.kcb.service.MessageService;
import org.kuali.rice.kcb.test.KCBTestCase;
import org.kuali.rice.kcb.test.KCBTestData;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.springframework.dao.DataAccessException;

public class MessageServiceTest
extends KCBTestCase {
    private MessageService messageService;
    private Message MESSAGE;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.messageService = GlobalKCBServiceLocator.getInstance().getMessageService();
        this.MESSAGE = KCBTestData.getMessage1();
        this.MESSAGE = this.messageService.saveMessage(this.MESSAGE);
    }

    @Test
    public void testCreate() {
        Message m = new Message();
        m.setContent("test content 2");
        m.setChannel("channel2");
        m.setContentType("test content type 2");
        m.setDeliveryType("test delivery type 2");
        m.setRecipient("test recipient 2");
        m.setTitle("test title 2");
        m = this.messageService.saveMessage(m);
        Assert.assertNotNull((Object)m.getId());
        Collection ms = this.messageService.getAllMessages();
        Assert.assertNotNull((Object)ms);
        Assert.assertEquals((long)2L, (long)ms.size());
        Message m2 = this.messageService.getMessage(m.getId());
        Assert.assertNotNull((Object)m2);
        this.assertEqualsMD(m, m2);
        Message m1 = new Message();
        m1.setContent("a");
        m1.setChannel("a");
        m1.setContentType("a");
        m1.setDeliveryType("a");
        m1.setRecipient("a");
        m1.setTitle("a");
        this.messageService.saveMessage(m1);
    }

    @Test
    public void testDelete() {
        this.messageService.deleteMessage(this.MESSAGE);
        Collection ms = this.messageService.getAllMessages();
        Assert.assertNotNull((Object)ms);
        Assert.assertEquals((long)0L, (long)ms.size());
        Assert.assertNull((Object)this.messageService.getMessage(this.MESSAGE.getId()));
    }

    @Test
    public void testDuplicateCreate() {
        Message m = new Message(this.MESSAGE);
        KRADServiceLocator.getDataObjectService().save((Object)this.MESSAGE, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    @Test(expected=DataAccessException.class)
    public void testInvalidCreate() {
        Message m = new Message();
        KRADServiceLocator.getDataObjectService().save((Object)m, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    @Test
    public void testInvalidRead() {
        Message m = this.messageService.getMessage(Long.valueOf(-1L));
        Assert.assertNull((Object)m);
    }

    @Test(expected=DataAccessException.class)
    public void testInvalidUpdate() {
        Message m = this.messageService.getMessage(this.MESSAGE.getId());
        m.setChannel(null);
        KRADServiceLocator.getDataObjectService().save((Object)m, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    @Test
    public void testReadById() {
        Message m = this.messageService.getMessage(this.MESSAGE.getId());
        this.assertEqualsMD(this.MESSAGE, m);
    }

    @Test
    public void testUpdate() {
        Message m = this.messageService.getMessage(this.MESSAGE.getId());
        m.setTitle("A better title");
        m.setContent("different content");
        m = this.messageService.saveMessage(m);
        Message m2 = this.messageService.getMessage(m.getId());
        Assert.assertNotNull((Object)m2);
        this.assertEqualsMD(m, m2);
    }

    private void assertEqualsMD(Message expected, Message actual) {
        Assert.assertEquals((Object)expected.getId(), (Object)actual.getId());
        Assert.assertEquals((Object)expected.getCreationDateTime(), (Object)actual.getCreationDateTime());
        Assert.assertEquals((Object)expected.getContent(), (Object)actual.getContent());
        Assert.assertEquals((Object)expected.getContentType(), (Object)actual.getContentType());
        Assert.assertEquals((Object)expected.getDeliveryType(), (Object)actual.getDeliveryType());
        Assert.assertEquals((Object)expected.getRecipient(), (Object)actual.getRecipient());
        Assert.assertEquals((Object)expected.getTitle(), (Object)actual.getTitle());
    }
}

