/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kcb.service.impl;

import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.kcb.bo.RecipientDelivererConfig;
import org.kuali.rice.kcb.service.GlobalKCBServiceLocator;
import org.kuali.rice.kcb.service.RecipientPreferenceService;
import org.kuali.rice.kcb.test.KCBTestCase;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.test.BaselineTestCase;
import org.springframework.dao.DataAccessException;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.ROLLBACK_CLEAR_DB)
public class RecipientDelivererConfigTest
extends KCBTestCase {
    private RecipientPreferenceService prefsvc;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.prefsvc = GlobalKCBServiceLocator.getInstance().getRecipientPreferenceService();
        this.prefsvc.saveRecipientDelivererConfig("user1", "mock", new String[]{"channel1"});
    }

    @Test
    public void testCreate() throws Exception {
        this.prefsvc.saveRecipientDelivererConfig("user1", "mock", new String[]{"channel2"});
        Collection deliverers = this.prefsvc.getDeliverersForRecipient("user1");
        Assert.assertEquals((long)2L, (long)deliverers.size());
    }

    @Test
    public void testDelete() throws Exception {
        this.prefsvc.removeRecipientDelivererConfigs("user1");
        Assert.assertEquals((long)0L, (long)this.prefsvc.getDeliverersForRecipient("user1").size());
    }

    @Test(expected=RiceRuntimeException.class)
    public void testDuplicateCreate() throws Exception {
        this.prefsvc.saveRecipientDelivererConfig("user1", "mock", new String[]{"channel1"});
    }

    @Test(expected=DataAccessException.class)
    public void testInvalidUpdate() throws Exception {
        this.prefsvc.saveRecipientDelivererConfig("user1", null, new String[]{"channel2"});
        KRADServiceLocator.getDataObjectService().flush(RecipientDelivererConfig.class);
    }

    @Test
    public void testGetDeliverersForRecipientAndChannel() {
        Collection cfgs = this.prefsvc.getDeliverersForRecipientAndChannel("user1", "channel1");
        Assert.assertEquals((long)1L, (long)cfgs.size());
        Assert.assertEquals((Object)"mock", (Object)((RecipientDelivererConfig)cfgs.iterator().next()).getDelivererName());
    }
}

