/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.dao;

import java.util.HashMap;
import org.junit.Assert;
import org.kuali.rice.ken.bo.NotificationChannelBo;
import org.kuali.rice.ken.bo.NotificationChannelReviewerBo;
import org.kuali.rice.ken.bo.NotificationProducerBo;
import org.kuali.rice.ken.dao.BusinessObjectPersistenceTestCaseBase;
import org.kuali.rice.ken.test.util.MockObjectsUtil;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class NotificationChannelDaoTest
extends BusinessObjectPersistenceTestCaseBase {
    NotificationChannelBo channel1 = MockObjectsUtil.getTestChannel1();
    NotificationChannelBo channel2 = MockObjectsUtil.getTestChannel2();
    NotificationProducerBo mockProducer1 = MockObjectsUtil.getTestProducer1();
    private String[] updatedDescriptions = new String[]{"Test 1 - updated description", "Test 2 - updated description"};
    private boolean[] updatedSubscribables = new boolean[]{false, true};

    @Override
    protected void setup() {
        super.setup();
        this.businessObjectDao.save((Object)this.mockProducer1);
    }

    @Override
    protected boolean delete() {
        NotificationChannelBo mockChannel1 = MockObjectsUtil.getTestChannel1();
        NotificationChannelBo mockChannel2 = MockObjectsUtil.getTestChannel2();
        this.channel1 = new NotificationChannelBo();
        this.channel2 = new NotificationChannelBo();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("name", mockChannel1.getName());
        this.channel1 = (NotificationChannelBo)this.businessObjectDao.findMatching(NotificationChannelBo.class, criteria).iterator().next();
        criteria.clear();
        criteria.put("name", mockChannel2.getName());
        this.channel2 = (NotificationChannelBo)this.businessObjectDao.findMatching(NotificationChannelBo.class, criteria).iterator().next();
        try {
            this.businessObjectDao.delete((Object)this.channel1);
            this.businessObjectDao.delete((Object)this.channel2);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean retrieve() {
        NotificationChannelBo mockChannel1 = MockObjectsUtil.getTestChannel1();
        NotificationChannelBo mockChannel2 = MockObjectsUtil.getTestChannel2();
        this.channel1 = new NotificationChannelBo();
        this.channel2 = new NotificationChannelBo();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("name", mockChannel1.getName());
        this.channel1 = (NotificationChannelBo)this.businessObjectDao.findMatching(NotificationChannelBo.class, criteria).iterator().next();
        criteria.clear();
        criteria.put("name", mockChannel2.getName());
        this.channel2 = (NotificationChannelBo)this.businessObjectDao.findMatching(NotificationChannelBo.class, criteria).iterator().next();
        boolean success = true;
        success &= this.channel1 != null;
        success &= this.channel1.getDescription().equals(mockChannel1.getDescription());
        success &= this.channel1.isSubscribable() == mockChannel1.isSubscribable();
        success &= this.channel1.getProducers().size() == 1;
        success &= this.channel2 != null;
        success &= this.channel2.getDescription().equals(mockChannel2.getDescription());
        success &= this.channel2.isSubscribable() == mockChannel2.isSubscribable();
        return success &= this.channel2.getProducers().size() == 1;
    }

    @Override
    protected boolean insert() {
        try {
            this.channel1.getProducers().add(this.mockProducer1);
            this.businessObjectDao.save((Object)this.channel1);
            this.mockProducer1 = (NotificationProducerBo)this.businessObjectDao.findById(NotificationProducerBo.class, (Object)this.mockProducer1.getId());
            this.channel2.getProducers().add(this.mockProducer1);
            this.businessObjectDao.save((Object)this.channel2);
            Assert.assertEquals((long)1L, (long)this.channel2.getProducers().size());
            this.mockProducer1 = (NotificationProducerBo)this.businessObjectDao.findById(NotificationProducerBo.class, (Object)this.mockProducer1.getId());
            Assert.assertEquals((long)2L, (long)this.mockProducer1.getChannels().size());
            this.channel2 = (NotificationChannelBo)this.businessObjectDao.findById(NotificationChannelBo.class, (Object)this.channel2.getId());
            Assert.assertEquals((long)1L, (long)this.channel2.getProducers().size());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean update() {
        try {
            this.channel2 = (NotificationChannelBo)this.businessObjectDao.findById(NotificationChannelBo.class, (Object)this.channel2.getId());
            Assert.assertEquals((long)1L, (long)this.channel2.getProducers().size());
            this.channel1.setDescription(this.updatedDescriptions[0]);
            this.channel1.setSubscribable(this.updatedSubscribables[0]);
            this.channel1.getProducers().clear();
            this.businessObjectDao.save((Object)this.channel1);
            this.mockProducer1 = (NotificationProducerBo)this.businessObjectDao.findById(NotificationProducerBo.class, (Object)this.mockProducer1.getId());
            Assert.assertNotNull((Object)this.mockProducer1);
            Assert.assertEquals((long)1L, (long)this.mockProducer1.getChannels().size());
            this.channel2 = (NotificationChannelBo)this.businessObjectDao.findById(NotificationChannelBo.class, (Object)this.channel2.getId());
            Assert.assertEquals((long)1L, (long)this.channel2.getProducers().size());
            this.channel2.setDescription(this.updatedDescriptions[1]);
            this.channel2.setSubscribable(this.updatedSubscribables[1]);
            NotificationChannelReviewerBo reviewer = MockObjectsUtil.buildTestNotificationChannelReviewer(KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE, "aReviewer");
            reviewer.setChannel(this.channel2);
            this.channel2.getReviewers().add(reviewer);
            this.businessObjectDao.save((Object)this.channel2);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean validateChanges() {
        NotificationChannelBo mockChannel1 = MockObjectsUtil.getTestChannel1();
        NotificationChannelBo mockChannel2 = MockObjectsUtil.getTestChannel2();
        this.channel1 = new NotificationChannelBo();
        this.channel2 = new NotificationChannelBo();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("name", mockChannel1.getName());
        this.channel1 = (NotificationChannelBo)this.businessObjectDao.findMatching(NotificationChannelBo.class, criteria).iterator().next();
        criteria.clear();
        criteria.put("name", mockChannel2.getName());
        this.channel2 = (NotificationChannelBo)this.businessObjectDao.findMatching(NotificationChannelBo.class, criteria).iterator().next();
        boolean success = true;
        success &= this.channel1.getDescription().equals(this.updatedDescriptions[0]);
        success &= this.channel1.isSubscribable() == this.updatedSubscribables[0];
        success &= this.channel1.getProducers().size() == 0;
        success &= this.channel2.getDescription().equals(this.updatedDescriptions[1]);
        success &= this.channel2.isSubscribable() == this.updatedSubscribables[1];
        success &= this.channel2.getProducers().size() == 1;
        return success &= this.channel2.getReviewers().size() == 1;
    }
}

