/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.services.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.util.xml.XmlException;
import org.kuali.rice.ken.api.notification.Notification;
import org.kuali.rice.ken.api.notification.NotificationResponse;
import org.kuali.rice.ken.api.service.SendNotificationService;
import org.kuali.rice.ken.bo.NotificationBo;
import org.kuali.rice.ken.test.KENTestCase;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.test.BaselineTestCase;
import org.quartz.SchedulerException;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class SendNotificationServiceImplTest
extends KENTestCase {
    @Test
    public void testSendNotificationAsXml_validInput() throws InterruptedException, SchedulerException, IOException, XmlException {
        this.services.getNotificationMessageDeliveryResolverService().resolveNotificationMessageDeliveries();
        Thread.sleep(10000L);
        this.services.getNotificationMessageDeliveryAutoRemovalService().processAutoRemovalOfDeliveredNotificationMessageDeliveries();
        DocumentType docType = KEWServiceLocator.getDocumentTypeService().findByName("KualiNotification");
        List list = KEWServiceLocator.getActionRequestService().findPendingRootRequestsByDocumentType(docType.getDocumentTypeId());
        int count_before = list.size();
        this.LOG.info((Object)("ActionRequests: " + count_before));
        for (ActionRequestValue v : list) {
            this.LOG.info((Object)("Root request: " + v.getActionRequested() + " " + v.getPrincipalId() + " " + v.getStatus() + " " + v.getRoleName()));
        }
        SendNotificationService sendNotificationService = (SendNotificationService)GlobalResourceLoader.getService((QName)new QName("http://rice.kuali.org/ken/v2_0", "sendNotificationService"));
        String notificationMessageAsXml = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("valid_input.xml"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processingFlag", "UNRESOLVED");
        Collection notifications = this.services.getGenericDao().findMatching(NotificationBo.class, map);
        Assert.assertEquals((long)0L, (long)notifications.size());
        String[] result = new String[1];
        NotificationResponse response = sendNotificationService.invoke(notificationMessageAsXml);
        this.LOG.info((Object)("response XML: " + response));
        Assert.assertEquals((Object)"Success", (Object)response.getStatus());
        notifications = this.services.getGenericDao().findMatching(NotificationBo.class, map);
        Assert.assertEquals((long)1L, (long)notifications.size());
        this.LOG.info((Object)("Notification: " + notifications.iterator().next()));
        this.services.getNotificationMessageDeliveryResolverService().resolveNotificationMessageDeliveries();
        this.services.getNotificationMessageDeliveryAutoRemovalService().processAutoRemovalOfDeliveredNotificationMessageDeliveries();
        list = KEWServiceLocator.getActionRequestService().findPendingRootRequestsByDocumentType(docType.getDocumentTypeId());
        int count_after = list.size();
        this.LOG.info((Object)("ActionRequests before: " + count_before));
        this.LOG.info((Object)("ActionRequests after: " + count_after));
        for (ActionRequestValue v : list) {
            this.LOG.info((Object)("Root request: " + v.getActionRequested() + " " + v.getPrincipalId() + " " + v.getStatus() + " " + v.getRoleName()));
        }
        Assert.assertEquals((long)6L, (long)(count_after - count_before));
    }

    @Test
    public void testSendNotificationAsXml_invalidInput() throws IOException {
        SendNotificationService sendNotificationService = (SendNotificationService)GlobalResourceLoader.getService((QName)new QName("http://rice.kuali.org/ken/v2_0", "sendNotificationService"));
        String notificationMessageAsXml = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("invalid_input.xml"));
        try {
            sendNotificationService.invoke(notificationMessageAsXml);
            Assert.fail((String)"XmlException not thrown");
        }
        catch (XmlException xmlException) {
        }
        catch (WorkflowRuntimeException workflowRuntimeException) {
        }
        catch (Exception e) {
            Assert.fail((String)("Wrong exception thrown, expected XmlException: " + e));
        }
    }

    @Test
    public void testSendNotificationAsXml_producerNotAuthorized() throws IOException, XmlException {
        SendNotificationService sendNotificationService = (SendNotificationService)GlobalResourceLoader.getService((QName)new QName("http://rice.kuali.org/ken/v2_0", "sendNotificationService"));
        String notificationMessageAsXml = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("producer_not_authorized.xml"));
        NotificationResponse response = sendNotificationService.invoke(notificationMessageAsXml);
        Assert.assertEquals((Object)"Failure", (Object)response.getStatus());
        Assert.assertEquals((Object)"The notification message was received by the system; however, we cannot process it because the Producer specified cannot send notifications for the Notification Channel specified.", (Object)response.getMessage());
    }

    @Test
    public void testSendNotificationAsBo_validInput() throws InterruptedException, SchedulerException, IOException, XmlException {
        this.services.getNotificationMessageDeliveryResolverService().resolveNotificationMessageDeliveries();
        Thread.sleep(10000L);
        this.services.getNotificationMessageDeliveryAutoRemovalService().processAutoRemovalOfDeliveredNotificationMessageDeliveries();
        DocumentType docType = KEWServiceLocator.getDocumentTypeService().findByName("KualiNotification");
        List list = KEWServiceLocator.getActionRequestService().findPendingRootRequestsByDocumentType(docType.getDocumentTypeId());
        int count_before = list.size();
        this.LOG.info((Object)("ActionRequests: " + count_before));
        for (ActionRequestValue v : list) {
            this.LOG.info((Object)("Root request: " + v.getActionRequested() + " " + v.getPrincipalId() + " " + v.getStatus() + " " + v.getRoleName()));
        }
        SendNotificationService sendNotificationService = (SendNotificationService)GlobalResourceLoader.getService((QName)new QName("http://rice.kuali.org/ken/v2_0", "sendNotificationService"));
        String notificationMessageAsXml = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("valid_input.xml"));
        NotificationBo notificationBo = this.services.getNotificationMessageContentService().parseNotificationRequestMessage(notificationMessageAsXml);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processingFlag", "UNRESOLVED");
        Collection notifications = this.services.getGenericDao().findMatching(NotificationBo.class, map);
        Assert.assertEquals((long)0L, (long)notifications.size());
        String[] result = new String[1];
        Notification notificiation = NotificationBo.to((NotificationBo)notificationBo);
        NotificationResponse response = sendNotificationService.sendNotification(notificiation);
        this.LOG.info((Object)("response XML: " + response));
        Assert.assertEquals((Object)"Success", (Object)response.getStatus());
        notifications = this.services.getGenericDao().findMatching(NotificationBo.class, map);
        Assert.assertEquals((long)1L, (long)notifications.size());
        this.LOG.info((Object)("Notification: " + notifications.iterator().next()));
        this.services.getNotificationMessageDeliveryResolverService().resolveNotificationMessageDeliveries();
        this.services.getNotificationMessageDeliveryAutoRemovalService().processAutoRemovalOfDeliveredNotificationMessageDeliveries();
        list = KEWServiceLocator.getActionRequestService().findPendingRootRequestsByDocumentType(docType.getDocumentTypeId());
        int count_after = list.size();
        this.LOG.info((Object)("ActionRequests before: " + count_before));
        this.LOG.info((Object)("ActionRequests after: " + count_after));
        for (ActionRequestValue v : list) {
            this.LOG.info((Object)("Root request: " + v.getActionRequested() + " " + v.getPrincipalId() + " " + v.getStatus() + " " + v.getRoleName()));
        }
        Assert.assertEquals((long)6L, (long)(count_after - count_before));
    }
}

