/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.services.impl;

import java.util.Collection;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.ken.bo.NotificationChannelBo;
import org.kuali.rice.ken.bo.UserChannelSubscriptionBo;
import org.kuali.rice.ken.service.UserPreferenceService;
import org.kuali.rice.ken.test.KENTestCase;
import org.kuali.rice.ken.test.TestConstants;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class UserPreferenceServiceImplTest
extends KENTestCase {
    public static final String VALID_USER_ID = "testuser1";
    public static final String VALID_CHANNEL_ID = TestConstants.VALID_CHANNEL_ONE_ID.toString();
    public static final Long VALID_CHANNEL_ID_LONG = TestConstants.VALID_CHANNEL_ONE_ID;
    public static final String[] CHANNEL_SELECTED = new String[]{TestConstants.VALID_CHANNEL_ONE_ID.toString()};
    public static final String VALID_VALUE = "kuali-ken-testing@cornell.edu";

    @Test
    public void testSubscribeToChannel() {
        UserPreferenceService impl = this.services.getUserPreferenceService();
        HashMap<String, Long> primaryKeys = new HashMap<String, Long>();
        primaryKeys.put("id", VALID_CHANNEL_ID_LONG);
        NotificationChannelBo channel = (NotificationChannelBo)this.services.getGenericDao().findByPrimaryKey(NotificationChannelBo.class, primaryKeys);
        UserChannelSubscriptionBo newSub = new UserChannelSubscriptionBo();
        newSub.setUserId(VALID_USER_ID);
        newSub.setChannel(channel);
        impl.subscribeToChannel(newSub);
        UserChannelSubscriptionBo sub = impl.getSubscription(VALID_CHANNEL_ID, VALID_USER_ID);
        Assert.assertNotNull((Object)sub);
        Assert.assertEquals((Object)VALID_USER_ID, (Object)sub.getUserId());
        Assert.assertEquals((Object)VALID_CHANNEL_ID_LONG, (Object)sub.getChannel().getId());
    }

    @Test
    public void testGetCurrentSubscriptions() {
        UserPreferenceService impl = this.services.getUserPreferenceService();
        HashMap<String, Long> primaryKeys = new HashMap<String, Long>();
        primaryKeys.put("id", VALID_CHANNEL_ID_LONG);
        NotificationChannelBo channel = (NotificationChannelBo)this.services.getGenericDao().findByPrimaryKey(NotificationChannelBo.class, primaryKeys);
        UserChannelSubscriptionBo newSub = new UserChannelSubscriptionBo();
        newSub.setUserId(VALID_USER_ID);
        newSub.setChannel(channel);
        impl.subscribeToChannel(newSub);
        Collection subs = impl.getCurrentSubscriptions(VALID_USER_ID);
        Assert.assertEquals((long)1L, (long)subs.size());
    }

    @Test
    public void testUnsubscribeFromChannel() {
        UserPreferenceService impl = this.services.getUserPreferenceService();
        HashMap<String, Long> primaryKeys = new HashMap<String, Long>();
        primaryKeys.put("id", VALID_CHANNEL_ID_LONG);
        NotificationChannelBo channel = (NotificationChannelBo)this.services.getGenericDao().findByPrimaryKey(NotificationChannelBo.class, primaryKeys);
        UserChannelSubscriptionBo newSub = new UserChannelSubscriptionBo();
        newSub.setUserId(VALID_USER_ID);
        newSub.setChannel(channel);
        impl.subscribeToChannel(newSub);
        UserChannelSubscriptionBo userChannelSubscription = impl.getSubscription(VALID_CHANNEL_ID, VALID_USER_ID);
        impl.unsubscribeFromChannel(userChannelSubscription);
        UserChannelSubscriptionBo sub = impl.getSubscription(VALID_CHANNEL_ID, VALID_USER_ID);
        Assert.assertNull((Object)sub);
    }
}

