/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.service.impl;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kim.api.common.delegate.DelegateMember;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleMember;
import org.kuali.rice.kim.api.role.RoleMemberContract;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.api.role.RoleResponsibilityAction;
import org.kuali.rice.kim.api.role.RoleResponsibilityActionContract;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.impl.common.delegate.DelegateMemberAttributeDataBo;
import org.kuali.rice.kim.impl.common.delegate.DelegateMemberBo;
import org.kuali.rice.kim.impl.common.delegate.DelegateTypeBo;
import org.kuali.rice.kim.impl.role.RoleMemberAttributeDataBo;
import org.kuali.rice.kim.impl.role.RoleMemberBo;
import org.kuali.rice.kim.test.KIMTestCase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;

public class RoleServiceImplTest
extends KIMTestCase {
    private RoleService roleService;
    static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
    static final String ROLE_MEMBER_ID1 = "45123";
    static final String ROLE_ID = "100";
    static final String MEMBER_ID = "1";
    static final MemberType MEMBER_TYPE_R = MemberType.ROLE;
    static final String ACTIVE_FROM_STRING = "2011-01-01 12:00:00";
    static final DateTime ACTIVE_FROM = new DateTime((Object)FORMATTER.parseDateTime("2011-01-01 12:00:00"));
    static final String ACTIVE_TO_STRING1 = "2013-01-01 12:00:00";
    static final String ACTIVE_TO_STRING2 = "2014-01-01 12:00:00";
    static final DateTime ACTIVE_TO1 = new DateTime((Object)FORMATTER.parseDateTime("2013-01-01 12:00:00"));
    static final DateTime ACTIVE_TO2 = new DateTime((Object)FORMATTER.parseDateTime("2014-01-01 12:00:00"));
    private BusinessObjectService businessObjectService;

    public void setUp() throws Exception {
        super.setUp();
        this.roleService = (RoleService)GlobalResourceLoader.getService((QName)new QName("http://rice.kuali.org/kim/v2_0", "roleService"));
    }

    @Test
    public void testPrincipaHasRoleOfDirectAssignment() {
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add("r1");
        Assert.assertTrue((String)"p1 has direct role r1", (boolean)this.roleService.principalHasRole("p1", roleIds, Collections.emptyMap()));
        HashMap<String, String> qualification = new HashMap<String, String>();
        qualification.put("Attribute 2", "CHEM");
        Assert.assertTrue((String)"p1 has direct role r1 with rp2 attr data", (boolean)this.roleService.principalHasRole("p1", roleIds, qualification));
        qualification.clear();
        qualification.put("Attribute 3", "PHYS");
        Assert.assertTrue((String)"p1 has direct role r1 with rp2 attr data", (boolean)this.roleService.principalHasRole("p1", roleIds, (Map)Maps.newHashMap(qualification)));
    }

    @Test
    public void testPrincipalHasRoleOfHigherLevel() {
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add("r2");
        Assert.assertTrue((String)"p1 has assigned in higher level role r1", (boolean)this.roleService.principalHasRole("p1", roleIds, Collections.emptyMap()));
        Assert.assertTrue((String)"p1 has assigned in higher level role r1", (boolean)this.roleService.principalHasRole("p1", roleIds, Collections.emptyMap()));
    }

    @Test
    public void testDelegateMemberCreateUpdateRemove() {
        Role r2 = this.roleService.getRole("r2");
        RoleMember rm1 = this.roleService.assignPrincipalToRole("user2", r2.getNamespaceCode(), r2.getName(), new HashMap());
        String kimTypeId = MEMBER_ID;
        String id = "" + KRADServiceLocator.getSequenceAccessorService().getNextAvailableSequenceNumber("KRIM_DLGN_MBR_ID_S");
        DelegateTypeBo delegate = new DelegateTypeBo();
        delegate.setDelegationId(id);
        delegate.setDelegationType(DelegationType.PRIMARY);
        delegate.setRoleId(r2.getId());
        delegate.setActive(true);
        delegate.setKimTypeId("" + kimTypeId);
        delegate = (DelegateTypeBo)KRADServiceLocator.getBusinessObjectService().save((PersistableBusinessObject)delegate);
        DelegateMember.Builder delegateMemberInfo = DelegateMember.Builder.create();
        delegateMemberInfo.setAttributes(Collections.emptyMap());
        delegateMemberInfo.setDelegationId(delegate.getDelegationId());
        delegateMemberInfo.setMemberId("user4");
        delegateMemberInfo.setRoleMemberId(rm1.getId());
        delegateMemberInfo.setType(MemberType.PRINCIPAL);
        DelegateMember inDelegateMember = delegateMemberInfo.build();
        DelegateMember newDelegateMember = this.roleService.createDelegateMember(inDelegateMember);
        Assert.assertNotNull((String)"delegateMember not created", (Object)newDelegateMember);
        delegateMemberInfo.setDelegationMemberId(newDelegateMember.getDelegationMemberId());
        DateTime dateTimeFrom = DateTime.now().minusDays(3);
        delegateMemberInfo.setActiveFromDate(dateTimeFrom);
        DateTime dateTimeTo = DateTime.now().plusDays(3);
        delegateMemberInfo.setActiveToDate(dateTimeTo);
        inDelegateMember = delegateMemberInfo.build();
        DelegateMember updatedDelegateMember = this.roleService.updateDelegateMember(inDelegateMember);
        Assert.assertEquals((String)"Delegate member was updated", (Object)newDelegateMember.getDelegationMemberId(), (Object)updatedDelegateMember.getDelegationMemberId());
        Assert.assertNotNull((String)"updateDelegateMember not created", (Object)updatedDelegateMember);
        Assert.assertEquals((String)"activeFromDate not updated", (Object)dateTimeFrom, (Object)updatedDelegateMember.getActiveFromDate());
        Assert.assertEquals((String)"activeToDate not updated", (Object)dateTimeTo, (Object)updatedDelegateMember.getActiveToDate());
        ArrayList<DelegateMember> removeDelegateMembers = new ArrayList<DelegateMember>();
        removeDelegateMembers.add(updatedDelegateMember);
        this.roleService.removeDelegateMembers(removeDelegateMembers);
        DelegateMember removedDelegateMember = this.roleService.getDelegationMemberById(updatedDelegateMember.getDelegationMemberId());
        Assert.assertTrue((String)"removeDelegateMembers did not remove the existing member", (boolean)removedDelegateMember.getDelegationMemberId().equals(updatedDelegateMember.getDelegationMemberId()));
        Assert.assertTrue((String)"removeDelegateMembers did not remove the existing member", (boolean)removedDelegateMember.getVersionNumber().equals(updatedDelegateMember.getVersionNumber() + 1L));
        Assert.assertTrue((String)"removeDelegateMembers did not update activeToDate", (boolean)removedDelegateMember.getActiveToDate().isBeforeNow());
    }

    @Test
    public void testRoleMemberCreateUpdate() {
        Role roleId = this.roleService.getRole(ROLE_ID);
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add(roleId.getId());
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("parameterName", "parameterNameBefore");
        attributes.put("namespaceCode", "namespaceCodeBefore");
        attributes.put("componentName", "componentNameBefore");
        RoleMember roleMember = this.roleService.createRoleMember(RoleMember.Builder.create((String)ROLE_ID, (String)ROLE_MEMBER_ID1, (String)MEMBER_ID, (MemberType)MEMBER_TYPE_R, (DateTime)ACTIVE_FROM, (DateTime)ACTIVE_TO1, attributes, (String)"", (String)"").build());
        RoleMemberBo rmBo = this.getRoleMemberBo(roleMember.getId());
        RoleMember.Builder updatedRoleMember = RoleMember.Builder.create((RoleMemberContract)roleMember);
        updatedRoleMember.setActiveToDate(ACTIVE_TO2);
        HashMap<String, String> newAttributes = new HashMap<String, String>();
        newAttributes.put("parameterName", "parameterNameAfter");
        newAttributes.put("namespaceCode", "namespaceCodeAfter");
        newAttributes.put("componentName", "componentNameAfter");
        updatedRoleMember.setAttributes(newAttributes);
        this.roleService.updateRoleMember(updatedRoleMember.build());
        RoleMemberBo updatedRmBo = this.getRoleMemberBo(roleMember.getId());
        Assert.assertEquals((long)3L, (long)rmBo.getAttributeDetails().size());
        Assert.assertEquals((long)3L, (long)updatedRmBo.getAttributeDetails().size());
        for (RoleMemberAttributeDataBo newRoleMemberAttrDataBo : updatedRmBo.getAttributeDetails()) {
            for (RoleMemberAttributeDataBo oldRoleMemberAttrDataBo : rmBo.getAttributeDetails()) {
                if (!newRoleMemberAttrDataBo.getKimTypeId().equals(oldRoleMemberAttrDataBo.getKimTypeId()) || !newRoleMemberAttrDataBo.getKimAttributeId().equals(oldRoleMemberAttrDataBo.getKimAttributeId())) continue;
                Assert.assertEquals((Object)new Long(2L), (Object)newRoleMemberAttrDataBo.getVersionNumber());
            }
        }
    }

    @Test
    public void testRoleMemberCreateUpdateNoAttrChange() {
        Role roleId = this.roleService.getRole(ROLE_ID);
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add(roleId.getId());
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("parameterName", "parameterNameBefore");
        attributes.put("namespaceCode", "namespaceCodeBefore");
        attributes.put("componentName", "componentNameBefore");
        RoleMember roleMember = this.roleService.createRoleMember(RoleMember.Builder.create((String)ROLE_ID, (String)ROLE_MEMBER_ID1, (String)MEMBER_ID, (MemberType)MEMBER_TYPE_R, (DateTime)ACTIVE_FROM, (DateTime)ACTIVE_TO1, attributes, (String)"", (String)"").build());
        RoleMemberBo rmBo = this.getRoleMemberBo(roleMember.getId());
        RoleMember.Builder updatedRoleMember = RoleMember.Builder.create((RoleMemberContract)roleMember);
        updatedRoleMember.setActiveToDate(ACTIVE_TO2);
        updatedRoleMember.setAttributes(rmBo.getAttributes());
        this.roleService.updateRoleMember(updatedRoleMember.build());
        RoleMemberBo updatedRmBo = this.getRoleMemberBo(roleMember.getId());
        Assert.assertEquals((long)3L, (long)rmBo.getAttributeDetails().size());
        Assert.assertEquals((long)3L, (long)updatedRmBo.getAttributeDetails().size());
        for (RoleMemberAttributeDataBo newRoleMemberAttrDataBo : updatedRmBo.getAttributeDetails()) {
            for (RoleMemberAttributeDataBo oldRoleMemberAttrDataBo : rmBo.getAttributeDetails()) {
                if (!newRoleMemberAttrDataBo.getKimTypeId().equals(oldRoleMemberAttrDataBo.getKimTypeId()) || !newRoleMemberAttrDataBo.getKimAttributeId().equals(oldRoleMemberAttrDataBo.getKimAttributeId())) continue;
                Assert.assertEquals((Object)oldRoleMemberAttrDataBo.getAttributeValue(), (Object)newRoleMemberAttrDataBo.getAttributeValue());
                Assert.assertEquals((Object)new Long(2L), (Object)newRoleMemberAttrDataBo.getVersionNumber());
            }
        }
    }

    @Test
    public void testRoleMemberCreateUpdateRemoveOneAttr() {
        Role roleId = this.roleService.getRole(ROLE_ID);
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add(roleId.getId());
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("parameterName", "parameterNameBefore");
        attributes.put("namespaceCode", "namespaceCodeBefore");
        attributes.put("componentName", "componentNameBefore");
        RoleMember roleMember = this.roleService.createRoleMember(RoleMember.Builder.create((String)ROLE_ID, (String)ROLE_MEMBER_ID1, (String)MEMBER_ID, (MemberType)MEMBER_TYPE_R, (DateTime)ACTIVE_FROM, (DateTime)ACTIVE_TO1, attributes, (String)"", (String)"").build());
        RoleMemberBo rmBo = this.getRoleMemberBo(roleMember.getId());
        RoleMember.Builder updatedRoleMember = RoleMember.Builder.create((RoleMemberContract)roleMember);
        updatedRoleMember.setActiveToDate(ACTIVE_TO2);
        HashMap<String, String> newAttributes = new HashMap<String, String>();
        newAttributes.put("parameterName", "parameterNameAfter");
        newAttributes.put("namespaceCode", "namespaceCodeAfter");
        updatedRoleMember.setAttributes(newAttributes);
        this.roleService.updateRoleMember(updatedRoleMember.build());
        RoleMemberBo updatedRmBo = this.getRoleMemberBo(roleMember.getId());
        Assert.assertEquals((long)3L, (long)rmBo.getAttributeDetails().size());
        Assert.assertEquals((long)2L, (long)updatedRmBo.getAttributeDetails().size());
        for (RoleMemberAttributeDataBo newRoleMemberAttrDataBo : updatedRmBo.getAttributeDetails()) {
            for (RoleMemberAttributeDataBo oldRoleMemberAttrDataBo : rmBo.getAttributeDetails()) {
                if (!newRoleMemberAttrDataBo.getKimTypeId().equals(oldRoleMemberAttrDataBo.getKimTypeId()) || !newRoleMemberAttrDataBo.getKimAttributeId().equals(oldRoleMemberAttrDataBo.getKimAttributeId())) continue;
                Assert.assertEquals((Object)new Long(2L), (Object)newRoleMemberAttrDataBo.getVersionNumber());
            }
        }
    }

    @Test
    public void testRoleMemberCreateUpdateAddOneAttr() {
        Role roleId = this.roleService.getRole(ROLE_ID);
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add(roleId.getId());
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("parameterName", "parameterNameBefore");
        attributes.put("namespaceCode", "namespaceCodeBefore");
        RoleMember roleMember = this.roleService.createRoleMember(RoleMember.Builder.create((String)ROLE_ID, (String)ROLE_MEMBER_ID1, (String)MEMBER_ID, (MemberType)MEMBER_TYPE_R, (DateTime)ACTIVE_FROM, (DateTime)ACTIVE_TO1, attributes, (String)"", (String)"").build());
        RoleMemberBo rmBo = this.getRoleMemberBo(roleMember.getId());
        RoleMember.Builder updatedRoleMember = RoleMember.Builder.create((RoleMemberContract)roleMember);
        updatedRoleMember.setActiveToDate(ACTIVE_TO2);
        HashMap<String, String> newAttributes = new HashMap<String, String>();
        newAttributes.put("parameterName", "parameterNameAfter");
        newAttributes.put("namespaceCode", "namespaceCodeAfter");
        newAttributes.put("componentName", "componentNameAfter");
        updatedRoleMember.setAttributes(newAttributes);
        this.roleService.updateRoleMember(updatedRoleMember.build());
        RoleMemberBo updatedRmBo = this.getRoleMemberBo(roleMember.getId());
        Assert.assertEquals((long)2L, (long)rmBo.getAttributeDetails().size());
        Assert.assertEquals((long)3L, (long)updatedRmBo.getAttributeDetails().size());
        for (RoleMemberAttributeDataBo newRoleMemberAttrDataBo : updatedRmBo.getAttributeDetails()) {
            for (RoleMemberAttributeDataBo oldRoleMemberAttrDataBo : rmBo.getAttributeDetails()) {
                if (newRoleMemberAttrDataBo.getAttributeValue().equals("componentName")) {
                    Assert.assertEquals((Object)new Long(1L), (Object)newRoleMemberAttrDataBo.getVersionNumber());
                    continue;
                }
                if (!newRoleMemberAttrDataBo.getKimTypeId().equals(oldRoleMemberAttrDataBo.getKimTypeId()) || !newRoleMemberAttrDataBo.getKimAttributeId().equals(oldRoleMemberAttrDataBo.getKimAttributeId())) continue;
                Assert.assertEquals((Object)new Long(2L), (Object)newRoleMemberAttrDataBo.getVersionNumber());
            }
        }
    }

    @Test
    public void testDelegateMemberCreateUpdateRemoveWithAttr() {
        Role r2 = this.roleService.getRole(ROLE_ID);
        RoleMember rm1 = this.roleService.assignPrincipalToRole("user2", r2.getNamespaceCode(), r2.getName(), new HashMap());
        String kimTypeId = MEMBER_ID;
        String id = "" + KRADServiceLocator.getSequenceAccessorService().getNextAvailableSequenceNumber("KRIM_DLGN_MBR_ID_S");
        DelegateTypeBo delegate = new DelegateTypeBo();
        delegate.setDelegationId(id);
        delegate.setDelegationType(DelegationType.PRIMARY);
        delegate.setRoleId(r2.getId());
        delegate.setActive(true);
        delegate.setKimTypeId("" + kimTypeId);
        delegate = (DelegateTypeBo)KRADServiceLocator.getBusinessObjectService().save((PersistableBusinessObject)delegate);
        DelegateMember.Builder delegateMemberInfo = DelegateMember.Builder.create();
        delegateMemberInfo.setDelegationId(delegate.getDelegationId());
        delegateMemberInfo.setMemberId("user4");
        delegateMemberInfo.setRoleMemberId(rm1.getId());
        delegateMemberInfo.setType(MemberType.PRINCIPAL);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("parameterName", "parameterNameBefore");
        attributes.put("namespaceCode", "namespaceCodeBefore");
        attributes.put("componentName", "componentNameBefore");
        delegateMemberInfo.setAttributes(attributes);
        DelegateMember inDelegateMember = delegateMemberInfo.build();
        DelegateMember newDelegateMember = this.roleService.createDelegateMember(inDelegateMember);
        Assert.assertNotNull((String)"delegateMember not created", (Object)newDelegateMember);
        DelegateMemberBo originalDelegateMemberBo = this.getDelegateMemberBo(newDelegateMember.getDelegationMemberId());
        DateTime dateTimeFrom = DateTime.now().minusDays(3);
        delegateMemberInfo.setActiveFromDate(dateTimeFrom);
        DateTime dateTimeTo = DateTime.now().plusDays(3);
        delegateMemberInfo.setActiveToDate(dateTimeTo);
        delegateMemberInfo.setDelegationMemberId(newDelegateMember.getDelegationMemberId());
        HashMap<String, String> newAttributes = new HashMap<String, String>();
        newAttributes.put("parameterName", "parameterNameAfter");
        newAttributes.put("namespaceCode", "namespaceCodeAfter");
        newAttributes.put("componentName", "componentNameAfter");
        delegateMemberInfo.setAttributes(newAttributes);
        newDelegateMember = delegateMemberInfo.build();
        DelegateMember updateDelegateMember = this.roleService.updateDelegateMember(newDelegateMember);
        Assert.assertNotNull((String)"updateDelegateMember not updated", (Object)updateDelegateMember);
        Assert.assertEquals((String)"activeFromDate not updated", (Object)dateTimeFrom, (Object)updateDelegateMember.getActiveFromDate());
        Assert.assertEquals((String)"activeToDate not updated", (Object)dateTimeTo, (Object)updateDelegateMember.getActiveToDate());
        DelegateMemberBo updatedDelegateMemberBo = this.getDelegateMemberBo(updateDelegateMember.getDelegationMemberId());
        for (DelegateMemberAttributeDataBo newRoleMemberAttrDataBo : updatedDelegateMemberBo.getAttributeDetails()) {
            for (DelegateMemberAttributeDataBo oldRoleMemberAttrDataBo : updatedDelegateMemberBo.getAttributeDetails()) {
                if (!newRoleMemberAttrDataBo.getKimTypeId().equals(oldRoleMemberAttrDataBo.getKimTypeId()) || !newRoleMemberAttrDataBo.getKimAttributeId().equals(oldRoleMemberAttrDataBo.getKimAttributeId())) continue;
                Assert.assertEquals((Object)new Long(2L), (Object)newRoleMemberAttrDataBo.getVersionNumber());
            }
        }
        ArrayList<DelegateMember> removeDelegateMembers = new ArrayList<DelegateMember>();
        removeDelegateMembers.add(updateDelegateMember);
        this.roleService.removeDelegateMembers(removeDelegateMembers);
        DelegateMember removedDelegateMember = this.roleService.getDelegationMemberById(updateDelegateMember.getDelegationMemberId());
        Assert.assertTrue((String)"removeDelegateMembers did not remove the existing member", (boolean)removedDelegateMember.getDelegationMemberId().equals(updateDelegateMember.getDelegationMemberId()));
        Assert.assertTrue((String)"removeDelegateMembers did not remove the existing member", (boolean)removedDelegateMember.getVersionNumber().equals(updateDelegateMember.getVersionNumber() + 1L));
        Assert.assertTrue((String)"removeDelegateMembers did not update activeToDate", (boolean)removedDelegateMember.getActiveToDate().isBeforeNow());
    }

    protected RoleMemberBo getRoleMemberBo(String roleMemberId) {
        if (StringUtils.isBlank((String)roleMemberId)) {
            return null;
        }
        return (RoleMemberBo)this.getBusinessObjectService().findByPrimaryKey(RoleMemberBo.class, Collections.singletonMap("id", roleMemberId));
    }

    protected DelegateMemberBo getDelegateMemberBo(String delegationMemberId) {
        if (StringUtils.isBlank((String)delegationMemberId)) {
            return null;
        }
        return (DelegateMemberBo)this.getBusinessObjectService().findByPrimaryKey(DelegateMemberBo.class, Collections.singletonMap("delegationMemberId", delegationMemberId));
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KRADServiceLocator.getBusinessObjectService();
        }
        return this.businessObjectService;
    }

    @Test
    public void testPrincipalHasRoleContainsGroupAssigned() {
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add("r2");
        Assert.assertTrue((String)"p2 is assigned to g1 and g1 assigned to r2", (boolean)this.roleService.principalHasRole("p2", roleIds, Collections.emptyMap()));
    }

    @Test
    public void testAddPrincipalToRoleAndRemove() {
        Role r2 = this.roleService.getRole("r2");
        RoleMember rm1 = this.roleService.assignPrincipalToRole("user4", r2.getNamespaceCode(), r2.getName(), new HashMap());
        Assert.assertTrue((String)"principal should be assigned to role", (boolean)this.roleService.principalHasRole("user4", Collections.singletonList(r2.getId()), new HashMap()));
        this.roleService.removePrincipalFromRole("user4", r2.getNamespaceCode(), r2.getName(), new HashMap());
        RoleMember rm2 = this.roleService.assignPrincipalToRole("user4", r2.getNamespaceCode(), r2.getName(), new HashMap());
        Assert.assertFalse((boolean)rm1.getId().equals(rm2.getId()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCircularRoleAssignment() {
        HashMap map = new HashMap();
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add("r1");
        this.roleService.assignRoleToRole("r5", "AUTH_SVC_TEST2", "RoleThree", map);
    }

    protected RoleResponsibilityAction createRoleResponsibilityAction() {
        Role r = this.roleService.getRole("r1");
        List members = this.roleService.getRoleMembers(Collections.singletonList("r1"), null);
        RoleMembership rm = (RoleMembership)members.get(0);
        RoleResponsibilityAction.Builder builder = RoleResponsibilityAction.Builder.create();
        builder.setRoleMemberId(rm.getMemberId());
        builder.setActionTypeCode(ActionType.APPROVE.getCode());
        RoleResponsibilityAction saved = this.roleService.createRoleResponsibilityAction(builder.build());
        List rra = this.roleService.getRoleMemberResponsibilityActions(rm.getMemberId());
        Assert.assertEquals((long)1L, (long)rra.size());
        Assert.assertEquals((Object)saved, rra.get(0));
        return (RoleResponsibilityAction)rra.get(0);
    }

    @Test
    public void testCreateRoleResponsibilityAction() {
        this.createRoleResponsibilityAction();
    }

    @Test
    public void testUpdateRoleResponsibilityAction() {
        RoleResponsibilityAction rra = this.createRoleResponsibilityAction();
        RoleResponsibilityAction.Builder builder = RoleResponsibilityAction.Builder.create((RoleResponsibilityActionContract)rra);
        Assert.assertFalse((boolean)builder.isForceAction());
        builder.setForceAction(true);
        builder.setActionTypeCode(ActionType.ACKNOWLEDGE.getCode());
        RoleResponsibilityAction updated = this.roleService.updateRoleResponsibilityAction(builder.build());
        builder.setVersionNumber(updated.getVersionNumber());
        Assert.assertEquals((Object)builder.build(), (Object)updated);
        List rras = this.roleService.getRoleMemberResponsibilityActions(rra.getRoleMemberId());
        Assert.assertEquals((long)1L, (long)rras.size());
        Assert.assertEquals((Object)updated, rras.get(0));
    }

    @Test
    public void testDeleteRoleResponsibilityAction() {
        RoleResponsibilityAction rra = this.createRoleResponsibilityAction();
        this.roleService.deleteRoleResponsibilityAction(rra.getId());
        List rras = this.roleService.getRoleMemberResponsibilityActions(rra.getRoleMemberId());
        Assert.assertEquals((long)0L, (long)rras.size());
        try {
            this.roleService.deleteRoleResponsibilityAction(rra.getId());
            Assert.fail((String)"Expected to throw RiceIllegalStateException due to missing RuleResponsibilityAction");
        }
        catch (RiceIllegalStateException riceIllegalStateException) {
            // empty catch block
        }
    }
}

